/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.openshift.agent.cloud.os3.OS3Application;
import com.intellij.javaee.openshift.cloud.OSCloudType;
import com.intellij.openapi.ui.MessageType;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OS3ApplicationRuntime<T extends OS3Application>
extends CloudApplicationRuntime {
    private final ServerTaskExecutor myTaskExecutor;
    private final AgentTaskExecutor myAgentTaskExecutor;
    private final T myApplication;
    private final OS3ApplicationRuntime myParent;
    private final DeploymentStatus myStatus;

    public OS3ApplicationRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, T application, OS3ApplicationRuntime parent, DeploymentStatus status) {
        super(application.getName());
        this.myTaskExecutor = taskExecutor;
        this.myAgentTaskExecutor = agentTaskExecutor;
        this.myApplication = application;
        this.myParent = parent;
        this.myStatus = status;
    }

    public OS3ApplicationRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, String applicationName) {
        super(applicationName);
        this.myTaskExecutor = taskExecutor;
        this.myAgentTaskExecutor = agentTaskExecutor;
        this.myApplication = null;
        this.myParent = null;
        this.myStatus = null;
    }

    public T getApplication() {
        return this.myApplication;
    }

    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatus;
    }

    @Nullable
    public CloudApplicationRuntime getParent() {
        return this.myParent;
    }

    public ServerTaskExecutor getTaskExecutor() {
        return this.myTaskExecutor;
    }

    public AgentTaskExecutor getAgentTaskExecutor() {
        return this.myAgentTaskExecutor;
    }

    protected ServerType<?> getCloudType() {
        return OSCloudType.getInstance();
    }

    public boolean isUndeploySupported() {
        return false;
    }

    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            OS3ApplicationRuntime.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    public void delete() {
        this.getTaskExecutor().submit(() -> {
            try {
                this.getAgentTaskExecutor().execute(() -> {
                    this.myApplication.delete();
                    return null;
                });
            }
            catch (ServerRuntimeException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/openshift/cloud/OS3ApplicationRuntime", "undeploy"));
    }
}

