/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Authentication;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgentConfig;
import com.intellij.javaee.openshift.cloud.OSVersion;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.annotations.Nullable;

public class OS3CloudConfiguration
extends CloudConfigurationBase<OS3CloudConfiguration>
implements OS3CloudAgentConfig {
    private String myLibraServer;
    private String myOSBinaryLocation;
    private OS3Authentication myAuthentication = OS3Authentication.Password;
    private String myToken;

    @Transient
    public OSVersion getVersion() {
        return OSVersion.OS3;
    }

    @Override
    @Attribute(value="libraServer")
    public String getLibraServer() {
        return this.myLibraServer;
    }

    public void setLibraServer(String libraServer) {
        this.myLibraServer = libraServer;
    }

    @Override
    public String getOSBinaryLocation() {
        return this.myOSBinaryLocation;
    }

    public void setOSBinaryLocation(String osBinaryLocation) {
        this.myOSBinaryLocation = osBinaryLocation;
    }

    @Override
    public OS3Authentication getAuthentication() {
        return this.myAuthentication;
    }

    @Override
    @Transient
    public String getAuthenticationAsString() {
        return this.myAuthentication.name();
    }

    public void setAuthentication(OS3Authentication authentication) {
        this.myAuthentication = authentication != null ? authentication : OS3Authentication.Password;
    }

    public String getToken() {
        return this.myToken;
    }

    public void setToken(String token) {
        this.myToken = token;
    }

    @Transient
    public void setTokenSafe(String token) {
        CredentialAttributes attributes = this.createTokenCredentialAttributes();
        OS3CloudConfiguration.doSetSafeValue((CredentialAttributes)attributes, (String)this.getTokenCredentialsUser(), (String)token, this::setToken);
    }

    @Override
    public String getTokenSafe() {
        CredentialAttributes attributes = this.createTokenCredentialAttributes();
        return OS3CloudConfiguration.doGetSafeValue((CredentialAttributes)attributes, this::getToken);
    }

    @Nullable
    public String getCustomToolWindowId() {
        return "OpenShift Origin";
    }

    @Nullable
    protected String getServiceName() {
        String email = this.getEmail();
        return StringUtil.isEmpty((String)email) ? null : CredentialAttributesKt.generateServiceName((String)"OpenShift", (String)email);
    }

    private CredentialAttributes createTokenCredentialAttributes() {
        String tokenUser = this.getTokenCredentialsUser();
        String tokenServiceName = CredentialAttributesKt.generateServiceName((String)"OpenShift Token", (String)tokenUser);
        return OS3CloudConfiguration.createCredentialAttributes((String)tokenServiceName, (String)tokenUser);
    }

    private String getTokenCredentialsUser() {
        return this.getLibraServer();
    }

    public boolean shouldMigrateToPasswordSafe() {
        return !StringUtil.isEmpty((String)this.myToken) || super.shouldMigrateToPasswordSafe();
    }

    public void migrateToPasswordSafe() {
        super.migrateToPasswordSafe();
        String unsafeToken = this.myToken;
        if (!StringUtil.isEmpty((String)unsafeToken)) {
            this.setTokenSafe(unsafeToken);
        }
    }
}

