/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Authentication;
import com.intellij.javaee.openshift.cloud.OS3CloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSCloudType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.util.CloudConfigurableBase;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class OSCloudConfigurable
extends CloudConfigurableBase<OS3CloudConfiguration> {
    private static final String OS3_PROVIDER_URL = "https://localhost:8443";
    private DelayedRunner myRunner;
    private JBLabel myEmailLabel;
    private JTextField myEmailTextField;
    private JBLabel myPasswordLabel;
    private JPasswordField myPasswordField;
    private JPanel myMainPanel;
    private ComboBox<String> myLibraServerComboBox;
    private TextFieldWithBrowseButton myPathToOSBinary;
    private ComboBox<OS3Authentication> myAuthenticationComboBox;
    private JBLabel myTokenLabel;
    private JPasswordField myTokenTextField;
    private OS3CloudConfiguration myCoreConfiguration;

    public OSCloudConfigurable(OS3CloudConfiguration configuration) {
        super((ServerType)OSCloudType.getInstance(), (CloudConfigurationBase)configuration);
        this.$$$setupUI$$$();
        this.myPathToOSBinary.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(true, false, false, false, false, false)));
        this.fillServerUrls();
        this.setupAuthenticationComboBox();
        this.initConnectionData();
    }

    private void fillServerUrls() {
        this.myLibraServerComboBox.removeAllItems();
        this.myLibraServerComboBox.addItem((Object)OS3_PROVIDER_URL);
    }

    private void setupAuthenticationComboBox() {
        this.myAuthenticationComboBox.removeAllItems();
        for (OS3Authentication authentication : OS3Authentication.values()) {
            this.myAuthenticationComboBox.addItem((Object)authentication);
        }
        this.myAuthenticationComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.onAuthenticationChanged((OS3Authentication)((Object)((Object)e.getItem())));
            }
        });
    }

    private void onAuthenticationChanged(OS3Authentication authentication) {
        boolean passwordAuthentication = authentication == OS3Authentication.Password;
        boolean tokenAuthentication = authentication == OS3Authentication.Token;
        OSCloudConfigurable.setEnabledAndVisible((JComponent)this.myEmailLabel, passwordAuthentication);
        OSCloudConfigurable.setEnabledAndVisible(this.myEmailTextField, passwordAuthentication);
        OSCloudConfigurable.setEnabledAndVisible((JComponent)this.myPasswordLabel, passwordAuthentication);
        OSCloudConfigurable.setEnabledAndVisible(this.myPasswordField, passwordAuthentication);
        OSCloudConfigurable.setEnabledAndVisible((JComponent)this.myTokenLabel, tokenAuthentication);
        OSCloudConfigurable.setEnabledAndVisible(this.myTokenTextField, tokenAuthentication);
    }

    private static void setEnabledAndVisible(JComponent component, boolean value) {
        component.setEnabled(value);
        component.setVisible(value);
    }

    private void initConnectionData() {
        this.myRunner = new DelayedRunner(this.myMainPanel){

            protected boolean wasChanged() {
                OS3CloudConfiguration configuration = new OS3CloudConfiguration();
                try {
                    OSCloudConfigurable.this.applyCoreTo(configuration, true);
                }
                catch (ConfigurationException e) {
                    return true;
                }
                if (OSCloudConfigurable.this.myCoreConfiguration != null && OSCloudConfigurable.this.isCoreConfigEqual(OSCloudConfigurable.this.myCoreConfiguration, configuration)) {
                    return false;
                }
                OSCloudConfigurable.this.myCoreConfiguration = configuration;
                return true;
            }

            protected void run() {
            }
        };
    }

    public boolean isModified() {
        OS3CloudConfiguration configuration = new OS3CloudConfiguration();
        try {
            this.applyTo(configuration, true);
        }
        catch (ConfigurationException e) {
            return true;
        }
        return !this.isConfigEqual((OS3CloudConfiguration)this.myConfiguration, configuration);
    }

    private boolean isConfigEqual(OS3CloudConfiguration configuration1, OS3CloudConfiguration configuration2) {
        return this.isCoreConfigEqual(configuration1, configuration2) && Comparing.equal((String)configuration1.getOSBinaryLocation(), (String)configuration2.getOSBinaryLocation()) && Comparing.equal((Object)((Object)configuration1.getAuthentication()), (Object)((Object)configuration2.getAuthentication())) && Comparing.equal((String)configuration1.getTokenSafe(), (String)configuration2.getTokenSafe());
    }

    protected boolean isCoreConfigEqual(OS3CloudConfiguration configuration1, OS3CloudConfiguration configuration2) {
        return super.isCoreConfigEqual((CloudConfigurationBase)configuration1, (CloudConfigurationBase)configuration2) && Comparing.equal((String)configuration1.getLibraServer(), (String)configuration2.getLibraServer());
    }

    public void apply() throws ConfigurationException {
        this.applyTo((OS3CloudConfiguration)this.myConfiguration, false);
    }

    private void applyTo(OS3CloudConfiguration configuration, boolean forComparison) throws ConfigurationException {
        String token;
        OS3CloudConfiguration validationCoreConfig = new OS3CloudConfiguration();
        this.applyCoreTo(validationCoreConfig, forComparison);
        OS3Authentication authentication = (OS3Authentication)((Object)this.myAuthenticationComboBox.getSelectedItem());
        String string = token = authentication == OS3Authentication.Token ? new String(this.myTokenTextField.getPassword()) : null;
        if (authentication == OS3Authentication.Token && StringUtil.isEmpty((String)token)) {
            throw new RuntimeConfigurationError("Token required");
        }
        this.applyCoreTo(configuration, forComparison);
        configuration.setOSBinaryLocation(this.myPathToOSBinary.getText());
        configuration.setAuthentication(authentication);
        if (forComparison) {
            configuration.setToken(token);
        } else {
            configuration.setTokenSafe(token);
        }
    }

    protected void applyCoreTo(OS3CloudConfiguration configuration, boolean forComparison) throws ConfigurationException {
        String apiUrl = (String)this.myLibraServerComboBox.getEditor().getItem();
        if (StringUtil.isEmpty((String)apiUrl)) {
            throw new RuntimeConfigurationError("Server (API URL) required");
        }
        if (this.myAuthenticationComboBox.getSelectedItem() == OS3Authentication.Password) {
            super.applyCoreTo((CloudConfigurationBase)configuration, forComparison);
        } else {
            configuration.setEmail(this.myEmailTextField.getText());
            configuration.setPassword(null);
            configuration.setPasswordSafe(null);
        }
        configuration.setLibraServer(apiUrl);
    }

    public void reset() {
        super.reset();
        OS3Authentication authentication = ((OS3CloudConfiguration)this.myConfiguration).getAuthentication();
        this.myLibraServerComboBox.setSelectedItem((Object)((OS3CloudConfiguration)this.myConfiguration).getLibraServer());
        this.myPathToOSBinary.setText(((OS3CloudConfiguration)this.myConfiguration).getOSBinaryLocation());
        this.myAuthenticationComboBox.setSelectedItem((Object)authentication);
        if (authentication == OS3Authentication.Token) {
            this.myTokenTextField.setText(((OS3CloudConfiguration)this.myConfiguration).getTokenSafe());
        } else {
            this.myTokenTextField.setText(null);
        }
        this.onAuthenticationChanged(authentication);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myRunner);
    }

    protected JComponent getMainPanel() {
        return this.myMainPanel;
    }

    protected JTextField getEmailTextField() {
        return this.myEmailTextField;
    }

    protected JPasswordField getPasswordField() {
        return this.myPasswordField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JBLabel jBLabel;
        ComboBox comboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        ComboBox comboBox2;
        JPasswordField jPasswordField2;
        JTextField jTextField;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEmailLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Username(email):");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Password:");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEmailTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel.add((Component)jPasswordField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Server (API URL):");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibraServerComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myPathToOSBinary = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Path to 'oc':");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Authentication:");
        jPanel.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAuthenticationComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myTokenLabel = jBLabel = new JBLabel();
        jBLabel.setText("Token:");
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTokenTextField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel3.setLabelFor(jTextField);
        jBLabel2.setLabelFor(jPasswordField2);
        jBLabel4.setLabelFor((Component)comboBox2);
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel5.setLabelFor((Component)comboBox);
        jBLabel.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

