/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfiguration;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfigurationType;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;

public abstract class CucumberJavaRunConfigurationProducer
extends JavaRunConfigurationProducerBase<CucumberJavaRunConfiguration>
implements Cloneable {
    public static final String FORMATTER_OPTIONS_1_0 = " --format org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatter --monochrome";
    public static final String FORMATTER_OPTIONS_1_2 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatter --monochrome";
    public static final String FORMATTER_OPTIONS_2 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvm2SMFormatter --monochrome";
    public static final String FORMATTER_OPTIONS_3 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvm3SMFormatter";
    public static final String CUCUMBER_1_0_MAIN_CLASS = "cucumber.cli.Main";
    public static final String CUCUMBER_1_1_MAIN_CLASS = "cucumber.api.cli.Main";
    public static final String CUCUMBER_1_2_PLUGIN_CLASS = "cucumber.api.Plugin";
    public static final String CUCUMBER_2_CLASS_MARKER = "cucumber.api.formatter.Formatter";
    public static final String CUCUMBER_3_CLASS_MARKER = "cucumber.runner.TestCase";
    private static final String CUCUMBER_CORE_VERSION_3 = "3";
    private static final String CUCUMBER_CORE_VERSION_2 = "2";
    private static final String CUCUMBER_CORE_VERSION_1_2 = "1.2";
    private static final String CUCUMBER_CORE_VERSION_1_0 = "1";
    public static final Set<String> HOOK_ANNOTATION_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"cucumber.annotation.Before", "cucumber.annotation.After", "cucumber.api.java.Before", "cucumber.api.java.After"});

    protected CucumberJavaRunConfigurationProducer() {
        super((ConfigurationType)CucumberJavaRunConfigurationType.getInstance());
    }

    @Nullable
    protected abstract NullableComputable<String> getStepsGlue(@NotNull PsiElement var1);

    protected abstract String getConfigurationName(@NotNull ConfigurationContext var1);

    protected String getNameFilter(@NotNull ConfigurationContext context) {
        if (context == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return "";
    }

    @Nullable
    protected abstract VirtualFile getFileToRun(ConfigurationContext var1);

    protected boolean setupConfigurationFromContext(CucumberJavaRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        VirtualFile virtualFile = this.getFileToRun(context);
        if (virtualFile == null) {
            return false;
        }
        Project project = configuration.getProject();
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        if (virtualFile.isDirectory() && !FileTypeIndex.containsFileOfType((FileType)GherkinFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)virtualFile, (boolean)true))) {
            return false;
        }
        String mainClassName = null;
        String formatterOptions = null;
        Location location = context.getLocation();
        if (location != null) {
            String cucumberCoreVersion;
            if (LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_1_0_MAIN_CLASS})) {
                mainClassName = CUCUMBER_1_0_MAIN_CLASS;
                cucumberCoreVersion = CUCUMBER_CORE_VERSION_1_0;
            } else {
                mainClassName = CUCUMBER_1_1_MAIN_CLASS;
                cucumberCoreVersion = CucumberJavaRunConfigurationProducer.getCucumberCoreVersion(location);
            }
            configuration.setCucumberCoreVersion(cucumberCoreVersion);
            formatterOptions = CucumberJavaRunConfigurationProducer.getSMFormatterOptions(cucumberCoreVersion);
        }
        if (mainClassName == null) {
            return false;
        }
        VirtualFile file = this.getFileToRun(context);
        if (file == null) {
            return false;
        }
        if (StringUtil.isEmpty((String)configuration.getGlue())) {
            NullableComputable<String> glue = this.getStepsGlue(element);
            configuration.setGlue(glue);
        }
        configuration.setNameFilter(this.getNameFilter(context));
        configuration.setFilePath(file.getPath());
        String programParametersFromDefaultConfiguration = StringUtil.defaultIfEmpty((String)configuration.getProgramParameters(), (String)"");
        configuration.setProgramParameters(programParametersFromDefaultConfiguration + formatterOptions);
        if (configuration.getMainClassName() == null) {
            configuration.setMainClassName(mainClassName);
        }
        if (configuration.getNameFilter() != null && configuration.getNameFilter().length() > 0) {
            String newProgramParameters = configuration.getProgramParameters() + " --name \"" + configuration.getNameFilter() + "\"";
            configuration.setProgramParameters(newProgramParameters);
        }
        configuration.setSuggestedName(this.getConfigurationName(context));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
        return true;
    }

    public boolean isConfigurationFromContext(CucumberJavaRunConfiguration runConfiguration, ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Location classLocation = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        if (classLocation == null) {
            return false;
        }
        VirtualFile fileToRun = this.getFileToRun(context);
        if (fileToRun == null) {
            return false;
        }
        if (!fileToRun.getPath().equals(runConfiguration.getFilePath())) {
            return false;
        }
        if (!Comparing.strEqual((String)this.getNameFilter(context), (String)runConfiguration.getNameFilter())) {
            return false;
        }
        Module configurationModule = ((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule();
        return Comparing.equal((Object)classLocation.getModule(), (Object)configurationModule);
    }

    protected Set<String> getHookGlue(PsiElement element) {
        LinkedHashSet packages = ContainerUtil.newLinkedHashSet();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return packages;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        for (String fullyQualifiedAnnotationName : HOOK_ANNOTATION_NAMES) {
            PsiClass psiClass = javaPsiFacade.findClass(fullyQualifiedAnnotationName, dependenciesScope);
            if (psiClass == null) continue;
            Query psiMethods = AnnotatedElementsSearch.searchPsiMethods((PsiClass)psiClass, (SearchScope)GlobalSearchScope.allScope((Project)element.getProject()));
            Collection methods = psiMethods.findAll();
            CucumberJavaRunConfigurationProducer.addPackagesOfMethods(methods, packages);
        }
        return packages;
    }

    private static void addPackagesOfMethods(Collection<PsiMethod> psiMethods, Set<String> packages) {
        for (PsiMethod psiMethod : psiMethods) {
            PsiClassOwner file = (PsiClassOwner)psiMethod.getContainingFile();
            String packageName = file.getPackageName();
            if (!StringUtil.isNotEmpty((String)packageName)) continue;
            CucumberJavaUtil.addGlue(packageName, packages);
        }
    }

    @NotNull
    private static String getCucumberCoreVersion(@NotNull Location location) {
        if (location == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_3_CLASS_MARKER})) {
            if (CUCUMBER_CORE_VERSION_3 == null) {
                CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(2);
            }
            return CUCUMBER_CORE_VERSION_3;
        }
        if (LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_2_CLASS_MARKER})) {
            if (CUCUMBER_CORE_VERSION_2 == null) {
                CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(3);
            }
            return CUCUMBER_CORE_VERSION_2;
        }
        if (LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_1_2_PLUGIN_CLASS})) {
            if (CUCUMBER_CORE_VERSION_1_2 == null) {
                CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(4);
            }
            return CUCUMBER_CORE_VERSION_1_2;
        }
        if (CUCUMBER_CORE_VERSION_3 == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        return CUCUMBER_CORE_VERSION_3;
    }

    @NotNull
    private static String getSMFormatterOptions(@NotNull String cucumberCoreVersion) {
        if (cucumberCoreVersion == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (cucumberCoreVersion.equals(CUCUMBER_CORE_VERSION_1_0)) {
            if (FORMATTER_OPTIONS_1_0 == null) {
                CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(7);
            }
            return FORMATTER_OPTIONS_1_0;
        }
        if (cucumberCoreVersion.equals(CUCUMBER_CORE_VERSION_1_2)) {
            if (FORMATTER_OPTIONS_1_2 == null) {
                CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(8);
            }
            return FORMATTER_OPTIONS_1_2;
        }
        if (cucumberCoreVersion.equals(CUCUMBER_CORE_VERSION_2)) {
            if (FORMATTER_OPTIONS_2 == null) {
                CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(9);
            }
            return FORMATTER_OPTIONS_2;
        }
        if (FORMATTER_OPTIONS_3 == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        return FORMATTER_OPTIONS_3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfigurationProducer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cucumberCoreVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfigurationProducer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCucumberCoreVersion";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSMFormatterOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNameFilter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberCoreVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSMFormatterOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

