/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps.search;

import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.java.steps.reference.CucumberJavaParameterPomTarget;

public class CucumberJavaPomDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement element, int offsetInElement, Consumer<PomTarget> consumer) {
        if (element == null) {
            CucumberJavaPomDeclarationSearcher.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiLiteralExpression)) {
            return;
        }
        Object value = ((PsiLiteralExpression)element).getValue();
        if (!(value instanceof String)) {
            return;
        }
        String stringValue = (String)value;
        PsiNewExpression newExp = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        if (newExp != null) {
            String fqn;
            if (!CucumberJavaPomDeclarationSearcher.isFirstConstructorArgument(element, newExp)) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = newExp.getClassReference();
            if (classReference != null && "io.cucumber.cucumberexpressions.ParameterType".equals(fqn = classReference.getQualifiedName())) {
                consumer.consume((Object)new CucumberJavaParameterPomTarget(element, stringValue));
            }
        }
    }

    private static boolean isFirstConstructorArgument(@NotNull PsiElement element, @NotNull PsiNewExpression newExp) {
        PsiExpressionList argumentList;
        if (element == null) {
            CucumberJavaPomDeclarationSearcher.$$$reportNull$$$0(1);
        }
        if (newExp == null) {
            CucumberJavaPomDeclarationSearcher.$$$reportNull$$$0(2);
        }
        if ((argumentList = newExp.getArgumentList()) == null) {
            return false;
        }
        if (argumentList.getExpressionCount() == 0) {
            return false;
        }
        return argumentList.getExpressions()[0] == element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExp";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/java/steps/search/CucumberJavaPomDeclarationSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findDeclarationsAt";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstConstructorArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

