/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.model.Range;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RangeTooltipComponent
extends AnimatedComponent {
    public static final Color HIGHLIGHT_COLOR = new JBColor(4882943, 7910143);
    @NotNull
    private final Range myHighlightRange;
    @NotNull
    private final Range myViewRange;
    @NotNull
    private final Range myDataRange;
    @NotNull
    private final TooltipComponent myTooltipComponent;
    @Nullable
    private Point myLastPoint;

    public RangeTooltipComponent(@NotNull Range hightlight, @NotNull Range view, @NotNull Range data, Component component, @Nullable Class<? extends JLayeredPane> preferredTooltipParent) {
        if (hightlight == null) {
            RangeTooltipComponent.$$$reportNull$$$0(0);
        }
        if (view == null) {
            RangeTooltipComponent.$$$reportNull$$$0(1);
        }
        if (data == null) {
            RangeTooltipComponent.$$$reportNull$$$0(2);
        }
        this.myHighlightRange = hightlight;
        this.myViewRange = view;
        this.myDataRange = data;
        this.myTooltipComponent = new TooltipComponent(component, this, preferredTooltipParent);
        this.myViewRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::viewRangeChanged);
        this.myHighlightRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::highlightRangeChanged);
    }

    public RangeTooltipComponent(@NotNull Range hightlight, @NotNull Range view, @NotNull Range data, Component component) {
        if (hightlight == null) {
            RangeTooltipComponent.$$$reportNull$$$0(3);
        }
        if (view == null) {
            RangeTooltipComponent.$$$reportNull$$$0(4);
        }
        if (data == null) {
            RangeTooltipComponent.$$$reportNull$$$0(5);
        }
        this(hightlight, view, data, component, null);
    }

    public void registerListenersOn(Component component) {
        this.myTooltipComponent.registerListenersOn(component);
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RangeTooltipComponent.this.myLastPoint = null;
                RangeTooltipComponent.this.opaqueRepaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            private void handleMove(MouseEvent e) {
                RangeTooltipComponent.this.myLastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), RangeTooltipComponent.this);
                RangeTooltipComponent.this.viewRangeChanged();
                RangeTooltipComponent.this.opaqueRepaint();
            }
        };
        component.addMouseMotionListener(adapter);
        component.addMouseListener(adapter);
    }

    private void viewRangeChanged() {
        if (this.isShowing()) {
            if (this.myLastPoint != null) {
                double current = this.xToRange(this.myLastPoint.x);
                this.myHighlightRange.set(current, current);
            } else {
                this.myHighlightRange.clear();
            }
        }
    }

    private void highlightRangeChanged() {
        this.opaqueRepaint();
    }

    private double xToRange(int x) {
        return (double)x / this.getSize().getWidth() * this.myViewRange.getLength() + this.myViewRange.getMin();
    }

    private float rangeToX(double value) {
        return (float)((value - this.myViewRange.getMin()) / (this.myViewRange.getMax() - this.myViewRange.getMin()));
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myLastPoint == null || this.myHighlightRange.isEmpty() || this.myHighlightRange.getMin() < this.myDataRange.getMin()) {
            this.myTooltipComponent.setVisible(false);
            return;
        }
        this.myTooltipComponent.setVisible(true);
        float x = this.rangeToX(this.myHighlightRange.getMin());
        float pos = (float)((double)x * dim.getWidth());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(HIGHLIGHT_COLOR);
        g.setStroke(new BasicStroke(2.0f));
        Path2D.Float path = new Path2D.Float();
        path.moveTo(pos, 0.0f);
        path.lineTo((double)pos, dim.getHeight());
        g.draw(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "hightlight";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/RangeTooltipComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

