/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.hchart.DefaultHTreeChartReducer;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChartReducer;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTreeChart<N extends HNode<N>>
extends AnimatedComponent {
    private static final String NO_HTREE = "No data available.";
    private static final String NO_RANGE = "X range width is zero: Please use a wider range.";
    private static final int ZOOM_FACTOR = 20;
    private static final String ACTION_ZOOM_IN = "zoom in";
    private static final String ACTION_ZOOM_OUT = "zoom out";
    private static final String ACTION_MOVE_LEFT = "move left";
    private static final String ACTION_MOVE_RIGHT = "move right";
    private static final int ACTION_MOVEMENT_FACTOR = 5;
    private static final int BORDER_PLUS_PADDING = 2;
    private static final int INITIAL_Y_POSITION = 0;
    private final Orientation myOrientation;
    @Nullable
    private HRenderer<N> myRenderer;
    @Nullable
    private N myRoot;
    @NotNull
    private final Range myXRange;
    @NotNull
    private final Range myGlobalXRange;
    @NotNull
    private final Range myYRange;
    @NotNull
    private final List<Rectangle2D.Float> myRectangles;
    @NotNull
    private final List<N> myNodes;
    private boolean myRootVisible;
    @Nullable
    private N myFocusedNode;
    @NotNull
    private final List<Rectangle2D.Float> myDrawnRectangles;
    @NotNull
    private final List<N> myDrawnNodes;
    @NotNull
    private final HTreeChartReducer<N> myReducer;
    @Nullable
    private Image myCanvas;
    private boolean myDataUpdated;
    private int myCachedMaxHeight;

    public HTreeChart(@Nullable Range globalXRange, @NotNull Range viewXRange, Orientation orientation, @NotNull HTreeChartReducer<N> reducer) {
        if (viewXRange == null) {
            HTreeChart.$$$reportNull$$$0(0);
        }
        if (reducer == null) {
            HTreeChart.$$$reportNull$$$0(1);
        }
        this.myRectangles = new ArrayList<Rectangle2D.Float>();
        this.myNodes = new ArrayList<N>();
        this.myDrawnNodes = new ArrayList<N>();
        this.myDrawnRectangles = new ArrayList<Rectangle2D.Float>();
        this.myGlobalXRange = globalXRange != null ? globalXRange : new Range(-1.7976931348623157E308, Double.MAX_VALUE);
        this.myXRange = viewXRange;
        this.myRoot = null;
        this.myReducer = reducer;
        this.myYRange = new Range(0.0, 0.0);
        this.myOrientation = orientation;
        this.myRootVisible = true;
        this.setFocusable(true);
        this.initializeInputMap();
        this.initializeMouseEvents();
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.myXRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::changed);
        this.myYRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::changed);
        this.changed();
    }

    public HTreeChart(@Nullable Range globalXRange, @NotNull Range viewXRange, Orientation orientation) {
        if (viewXRange == null) {
            HTreeChart.$$$reportNull$$$0(2);
        }
        this(globalXRange, viewXRange, orientation, new DefaultHTreeChartReducer());
    }

    public void setRootVisible(boolean rootVisible) {
        this.myRootVisible = rootVisible;
        this.changed();
    }

    public void setFocusedNode(@Nullable N node) {
        this.myFocusedNode = node;
    }

    private void changed() {
        this.myDataUpdated = true;
        this.myCachedMaxHeight = this.calculateMaximumHeight();
        this.opaqueRepaint();
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        long startTime = System.nanoTime();
        if (this.myDataUpdated) {
            this.updateNodesAndClearCanvas();
            this.myDataUpdated = false;
        }
        g.setFont(this.getFont());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.myRoot == null || this.myRoot.getChildCount() == 0) {
            g.drawString(NO_HTREE, dim.width / 2 - this.mDefaultFontMetrics.stringWidth(NO_HTREE), dim.height / 2);
            return;
        }
        if (this.myXRange.getLength() == 0.0) {
            g.drawString(NO_RANGE, dim.width / 2 - this.mDefaultFontMetrics.stringWidth(NO_RANGE), dim.height / 2);
            return;
        }
        if (this.myCanvas == null || ImageUtil.getUserHeight((Image)this.myCanvas) != dim.height || ImageUtil.getUserWidth((Image)this.myCanvas) != dim.width) {
            this.redrawToCanvas(dim);
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myCanvas, (int)0, (int)0, null);
        this.addDebugInfo("Draw time %.2fms", (double)(System.nanoTime() - startTime) / 1000000.0);
        this.addDebugInfo("# of nodes %d", this.myNodes.size());
        this.addDebugInfo("# of reduced nodes %d", this.myDrawnNodes.size());
    }

    private void redrawToCanvas(@NotNull Dimension dim) {
        Graphics2D g;
        if (dim == null) {
            HTreeChart.$$$reportNull$$$0(3);
        }
        if (this.myCanvas != null && ImageUtil.getUserWidth((Image)this.myCanvas) >= dim.width && ImageUtil.getUserHeight((Image)this.myCanvas) >= dim.height) {
            g = (Graphics2D)this.myCanvas.getGraphics();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, dim.width, dim.height);
        } else {
            this.myCanvas = UIUtil.createImage((int)dim.width, (int)dim.height, (int)2);
            g = (Graphics2D)this.myCanvas.getGraphics();
        }
        g.setFont(this.getFont());
        this.myDrawnNodes.clear();
        this.myDrawnNodes.addAll(this.myNodes);
        this.myDrawnRectangles.clear();
        for (Rectangle2D.Float rect : this.myRectangles) {
            Rectangle2D.Float newRect = new Rectangle2D.Float();
            newRect.x = rect.x * (float)dim.getWidth();
            newRect.y = rect.y;
            newRect.width = Math.max(0.0f, rect.width * (float)dim.getWidth() - 2.0f);
            newRect.height = rect.height;
            if (this.myOrientation == Orientation.BOTTOM_UP) {
                newRect.y = (float)(dim.getHeight() - (double)newRect.y - newRect.getHeight());
            }
            this.myDrawnRectangles.add(newRect);
        }
        this.myReducer.reduce(this.myDrawnRectangles, this.myDrawnNodes);
        assert (this.myDrawnRectangles.size() == this.myDrawnNodes.size());
        assert (this.myRenderer != null);
        for (int i = 0; i < this.myDrawnNodes.size(); ++i) {
            HNode node = (HNode)this.myDrawnNodes.get(i);
            this.myRenderer.render(g, node, this.myDrawnRectangles.get(i), node == this.myFocusedNode);
        }
        g.dispose();
    }

    private void updateNodesAndClearCanvas() {
        this.myNodes.clear();
        this.myRectangles.clear();
        this.myCanvas = null;
        if (this.myRoot == null) {
            return;
        }
        if (this.inRange(this.myRoot)) {
            this.myNodes.add(this.myRoot);
            this.myRectangles.add(this.createRectangle(this.myRoot));
        }
        int head = 0;
        while (head < this.myNodes.size()) {
            HNode curNode = (HNode)this.myNodes.get(head++);
            for (int i = 0; i < curNode.getChildCount(); ++i) {
                Object child = curNode.getChildAt(i);
                if (!this.inRange(child)) continue;
                this.myNodes.add(child);
                this.myRectangles.add(this.createRectangle(child));
            }
        }
        if (!this.myRootVisible && !this.myNodes.isEmpty()) {
            this.myNodes.remove(0);
            this.myRectangles.remove(0);
        }
    }

    private boolean inRange(@NotNull N node) {
        if (node == null) {
            HTreeChart.$$$reportNull$$$0(4);
        }
        return (double)node.getStart() <= this.myXRange.getMax() && (double)node.getEnd() >= this.myXRange.getMin();
    }

    @NotNull
    private Rectangle2D.Float createRectangle(@NotNull N node) {
        if (node == null) {
            HTreeChart.$$$reportNull$$$0(5);
        }
        float left = (float)Math.max(0.0, ((double)node.getStart() - this.myXRange.getMin()) / this.myXRange.getLength());
        float right = (float)Math.min(1.0, ((double)node.getEnd() - this.myXRange.getMin()) / this.myXRange.getLength());
        Rectangle2D.Float rect = new Rectangle2D.Float();
        rect.x = left;
        rect.y = (float)((double)((this.mDefaultFontMetrics.getHeight() + 2) * node.getDepth()) - this.getYRange().getMin());
        rect.width = right - left;
        rect.height = this.mDefaultFontMetrics.getHeight();
        Rectangle2D.Float float_ = rect;
        if (float_ == null) {
            HTreeChart.$$$reportNull$$$0(6);
        }
        return float_;
    }

    private double positionToRange(double x) {
        return x / (double)this.getWidth() * this.myXRange.getLength() + this.myXRange.getMin();
    }

    public void setHRenderer(@NotNull HRenderer<N> r) {
        if (r == null) {
            HTreeChart.$$$reportNull$$$0(7);
        }
        this.myRenderer = r;
    }

    public void setHTree(@Nullable N root) {
        this.myRoot = root;
        this.changed();
    }

    @Nullable
    public N getNodeAt(Point point) {
        if (point != null) {
            for (int i = 0; i < this.myDrawnNodes.size(); ++i) {
                if (!HTreeChart.contains(this.myDrawnRectangles.get(i), point)) continue;
                return (N)((HNode)this.myDrawnNodes.get(i));
            }
        }
        return null;
    }

    private static boolean contains(@NotNull Rectangle2D rectangle, @NotNull Point p) {
        if (rectangle == null) {
            HTreeChart.$$$reportNull$$$0(8);
        }
        if (p == null) {
            HTreeChart.$$$reportNull$$$0(9);
        }
        return rectangle.getMinX() <= p.getX() && p.getX() <= rectangle.getMaxX() && rectangle.getMinY() <= p.getY() && p.getY() <= rectangle.getMaxY();
    }

    @NotNull
    public Orientation getOrientation() {
        Orientation orientation = this.myOrientation;
        if (orientation == null) {
            HTreeChart.$$$reportNull$$$0(10);
        }
        return orientation;
    }

    private void initializeInputMap() {
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), ACTION_ZOOM_IN);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_ZOOM_OUT);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), ACTION_MOVE_LEFT);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), ACTION_MOVE_RIGHT);
        this.getActionMap().put(ACTION_ZOOM_IN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.myXRange.getLength() / 5.0;
                HTreeChart.this.myXRange.set(HTreeChart.this.myXRange.getMin() + delta, HTreeChart.this.myXRange.getMax() - delta);
            }
        });
        this.getActionMap().put(ACTION_ZOOM_OUT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.myXRange.getLength() / 5.0;
                HTreeChart.this.myXRange.set(Math.max(HTreeChart.this.myGlobalXRange.getMin(), HTreeChart.this.myXRange.getMin() - delta), Math.min(HTreeChart.this.myGlobalXRange.getMax(), HTreeChart.this.myXRange.getMax() + delta));
            }
        });
        this.getActionMap().put(ACTION_MOVE_LEFT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.myXRange.getLength() / 5.0;
                delta = Math.min(HTreeChart.this.myXRange.getMin() - HTreeChart.this.myGlobalXRange.getMin(), delta);
                HTreeChart.this.myXRange.shift(-delta);
            }
        });
        this.getActionMap().put(ACTION_MOVE_RIGHT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.myXRange.getLength() / 5.0;
                delta = Math.min(HTreeChart.this.myGlobalXRange.getMax() - HTreeChart.this.myXRange.getMax(), delta);
                HTreeChart.this.myXRange.shift(delta);
            }
        });
    }

    private void initializeMouseEvents() {
        MouseAdapter adapter = new MouseAdapter(){
            private Point myLastPoint;

            @Override
            public void mouseMoved(MouseEvent e) {
                Object node = HTreeChart.this.getNodeAt(e.getPoint());
                if (node != HTreeChart.this.myFocusedNode) {
                    HTreeChart.this.myDataUpdated = true;
                    HTreeChart.this.myFocusedNode = node;
                    HTreeChart.this.opaqueRepaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!HTreeChart.this.hasFocus()) {
                    HTreeChart.this.requestFocusInWindow();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.myLastPoint = e.getPoint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int contentHeight = HTreeChart.this.getMaximumHeight();
                int viewHeight = HTreeChart.this.getHeight();
                double deltaY = e.getPoint().y - this.myLastPoint.y;
                double d = deltaY = HTreeChart.this.getOrientation() == Orientation.BOTTOM_UP ? deltaY : -deltaY;
                if (HTreeChart.this.myYRange.getMin() + deltaY < 0.0) {
                    deltaY = 0.0 - HTreeChart.this.myYRange.getMin();
                } else if (HTreeChart.this.myYRange.getMin() + (double)viewHeight + deltaY > (double)contentHeight) {
                    deltaY = Math.max(0.0, (double)(contentHeight - viewHeight) - HTreeChart.this.myYRange.getMin());
                }
                HTreeChart.this.getYRange().shift(deltaY);
                double deltaX = e.getPoint().x - this.myLastPoint.x;
                double deltaXToShift = HTreeChart.this.myXRange.getLength() / (double)HTreeChart.this.getWidth() * -deltaX;
                if (deltaXToShift > 0.0) {
                    deltaXToShift = Math.min(HTreeChart.this.myGlobalXRange.getMax() - HTreeChart.this.myXRange.getMax(), deltaXToShift);
                } else if (deltaXToShift < 0.0) {
                    deltaXToShift = Math.max(HTreeChart.this.myGlobalXRange.getMin() - HTreeChart.this.myXRange.getMin(), deltaXToShift);
                }
                HTreeChart.this.myXRange.shift(deltaXToShift);
                this.myLastPoint = e.getPoint();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double cursorRange = HTreeChart.this.positionToRange(e.getX());
                double leftDelta = (cursorRange - HTreeChart.this.myXRange.getMin()) / 20.0 * (double)e.getWheelRotation();
                double rightDelta = (HTreeChart.this.myXRange.getMax() - cursorRange) / 20.0 * (double)e.getWheelRotation();
                HTreeChart.this.myXRange.set(Math.max(HTreeChart.this.myGlobalXRange.getMin(), HTreeChart.this.myXRange.getMin() - leftDelta), Math.min(HTreeChart.this.myGlobalXRange.getMax(), HTreeChart.this.myXRange.getMax() + rightDelta));
            }
        };
        this.addMouseWheelListener(adapter);
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    public Range getYRange() {
        return this.myYRange;
    }

    public int getMaximumHeight() {
        return this.myCachedMaxHeight;
    }

    private int calculateMaximumHeight() {
        if (this.myRoot == null) {
            return 0;
        }
        int maxDepth = -1;
        LinkedList queue = new LinkedList();
        queue.add(this.myRoot);
        while (!queue.isEmpty()) {
            HNode n = (HNode)queue.poll();
            if (n.getDepth() > maxDepth) {
                maxDepth = n.getDepth();
            }
            for (int i = 0; i < n.getChildCount(); ++i) {
                queue.add(n.getChildAt(i));
            }
        }
        return (this.mDefaultFontMetrics.getHeight() + 2) * ++maxDepth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewXRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reducer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dim";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/chart/hchart/HTreeChart";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/chart/hchart/HTreeChart";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRectangle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "redrawToCanvas";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRectangle";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setHRenderer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Orientation {
        TOP_DOWN,
        BOTTOM_UP;

    }
}

