/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.font;

import com.google.common.collect.Sets;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Font;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static Font getFontAbleToDisplay(@NotNull String s, @NotNull Font defaultFont) {
        if (s == null) {
            FontUtil.$$$reportNull$$$0(0);
        }
        if (defaultFont == null) {
            FontUtil.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isMac || FontUtil.isExtendedAscii(s)) {
            Font font = defaultFont;
            if (font == null) {
                FontUtil.$$$reportNull$$$0(2);
            }
            return font;
        }
        HashSet fonts = Sets.newHashSetWithExpectedSize((int)10);
        FontPreferences fontPreferences = EditorColorsManager.getInstance().getGlobalScheme().getFontPreferences();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u00ff') continue;
            fonts.add(ComplementaryFontsRegistry.getFontAbleToDisplay((int)s.charAt(i), (int)0, (FontPreferences)fontPreferences, null).getFont());
        }
        if (fonts.isEmpty()) {
            Font font = defaultFont;
            if (font == null) {
                FontUtil.$$$reportNull$$$0(3);
            }
            return font;
        }
        Font bestFont = defaultFont;
        int max = 0;
        for (Font f : fonts) {
            int supportedChars = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (!f.canDisplay(s.charAt(i))) continue;
                ++supportedChars;
            }
            if (supportedChars <= max) continue;
            max = supportedChars;
            bestFont = f;
        }
        Font font = bestFont;
        if (font == null) {
            FontUtil.$$$reportNull$$$0(4);
        }
        return font;
    }

    private static boolean isExtendedAscii(@NotNull String s) {
        if (s == null) {
            FontUtil.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFont";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/font/FontUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/font/FontUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontAbleToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFontAbleToDisplay";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExtendedAscii";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

