/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectObserver;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public class AspectModel<T extends Enum<T>>
extends AspectObserver {
    private Collection<Dependency<T>> myDependencies = Collections.newSetFromMap(new WeakHashMap());

    public void changed(T aspect) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>(this.myDependencies.size());
        deps.addAll(this.myDependencies);
        deps.forEach(dependency -> ((Dependency)dependency).changed(aspect));
    }

    public Dependency<T> addDependency(@NotNull AspectObserver observer) {
        if (observer == null) {
            AspectModel.$$$reportNull$$$0(0);
        }
        Dependency dependency = new Dependency();
        observer.addDependency(dependency);
        this.myDependencies.add(dependency);
        return dependency;
    }

    int getDependenciesSize() {
        return this.myDependencies.size();
    }

    public void removeDependencies(AspectObserver observer) {
        ArrayList observerDependencies = new ArrayList(observer.getDependencies());
        observer.getDependencies().removeAll(this.myDependencies);
        this.myDependencies.removeAll(observerDependencies);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/android/tools/adtui/model/AspectModel", "addDependency"));
    }

    public static class Dependency<U extends Enum<U>> {
        private Multimap<U, Runnable> myListeners = HashMultimap.create();

        private Dependency() {
        }

        public Dependency<U> onChange(U aspect, Runnable runnable) {
            this.myListeners.put(aspect, (Object)runnable);
            return this;
        }

        private void changed(U aspect) {
            this.myListeners.get(aspect).forEach(Runnable::run);
        }
    }
}

