/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SeriesData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModel
extends AspectModel<Aspect> {
    @NotNull
    private final Range mySelectionRange;
    @NotNull
    private final Range myPreviousSelectionRange;
    @NotNull
    private final List<SelectionListener> myListeners;
    @NotNull
    private final List<DurationDataModel<? extends ConfigurableDurationData>> myConstraints;
    private boolean mySelectionEnabled;
    private boolean myIsUpdating;
    private boolean myPostponeSelectionEvent;

    public SelectionModel(@NotNull Range selection) {
        if (selection == null) {
            SelectionModel.$$$reportNull$$$0(0);
        }
        this.myListeners = new ArrayList<SelectionListener>();
        this.mySelectionRange = selection;
        this.myPreviousSelectionRange = new Range(this.mySelectionRange);
        this.mySelectionEnabled = true;
        this.mySelectionRange.addDependency(this).onChange(Range.Aspect.RANGE, this::selectionChanged);
        this.myConstraints = new ArrayList<DurationDataModel<? extends ConfigurableDurationData>>();
    }

    public void addConstraint(@Nullable DurationDataModel<? extends ConfigurableDurationData> constraints) {
        this.myConstraints.add(constraints);
    }

    public void addListener(SelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void clearListeners() {
        this.myListeners.clear();
    }

    private void fireListeners() {
        if (this.myIsUpdating) {
            this.myPostponeSelectionEvent = true;
            return;
        }
        Consumer<SelectionListener> event = null;
        if (this.myPreviousSelectionRange.isEmpty() && !this.mySelectionRange.isEmpty()) {
            event = SelectionListener::selectionCreated;
        } else if (!this.myPreviousSelectionRange.isEmpty() && this.mySelectionRange.isEmpty()) {
            event = SelectionListener::selectionCleared;
        } else if (this.myPreviousSelectionRange.isEmpty() && this.mySelectionRange.isEmpty()) {
            event = SelectionListener::selectionCreationFailure;
        }
        this.myPreviousSelectionRange.set(this.mySelectionRange);
        if (event != null) {
            this.myListeners.forEach(event);
        }
    }

    private void selectionChanged() {
        this.changed(Aspect.SELECTION);
        this.fireListeners();
    }

    public void beginUpdate() {
        this.myIsUpdating = true;
    }

    public void endUpdate() {
        if (this.myIsUpdating) {
            this.myIsUpdating = false;
            if (this.myPostponeSelectionEvent) {
                this.myPostponeSelectionEvent = false;
                this.fireListeners();
            }
        }
    }

    public void clear() {
        if (!this.mySelectionEnabled) {
            return;
        }
        this.mySelectionRange.clear();
    }

    public void set(double min, double max) {
        if (!this.mySelectionEnabled) {
            return;
        }
        if (this.myConstraints.isEmpty()) {
            this.mySelectionRange.set(min, max);
            return;
        }
        Range proposedRange = new Range(min, max);
        Range resultRange = null;
        ConfigurableDurationData resultDurationData = null;
        boolean found = false;
        for (DurationDataModel<? extends ConfigurableDurationData> constraint : this.myConstraints) {
            DataSeries<? extends ConfigurableDurationData> series = constraint.getSeries().getDataSeries();
            List<SeriesData<? extends ConfigurableDurationData>> constraints = series.getDataForXRange(new Range(min, max));
            for (SeriesData<? extends ConfigurableDurationData> data : constraints) {
                long dataMax;
                Range r;
                long duration = ((ConfigurableDurationData)data.value).getDuration();
                if (duration == Long.MAX_VALUE && !((ConfigurableDurationData)data.value).getSelectableWhenMaxDuration() || (r = new Range(data.x, dataMax = duration == Long.MAX_VALUE ? duration : data.x + duration)).getIntersection(proposedRange).isEmpty()) continue;
                resultRange = r;
                resultDurationData = (ConfigurableDurationData)data.value;
                if (r.getIntersection(this.mySelectionRange).isEmpty()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        if (resultRange == null) {
            this.mySelectionRange.clear();
            if (this.myPreviousSelectionRange.isEmpty()) {
                this.selectionChanged();
            }
        } else if (!this.mySelectionRange.equals(resultRange)) {
            this.myPreviousSelectionRange.clear();
            if (resultDurationData.canSelectPartialRange()) {
                this.mySelectionRange.set(resultRange.getIntersection(proposedRange));
            } else {
                this.mySelectionRange.set(resultRange);
            }
        }
    }

    @NotNull
    public Range getSelectionRange() {
        Range range = this.mySelectionRange;
        if (range == null) {
            SelectionModel.$$$reportNull$$$0(1);
        }
        return range;
    }

    public void setSelectionEnabled(boolean enabled) {
        this.mySelectionEnabled = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/SelectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/SelectionModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        SELECTION;

    }
}

