/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ptable;

import com.android.tools.adtui.ptable.PTableItem;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class PTableModel
extends AbstractTableModel {
    private List<PTableItem> myItems = Collections.emptyList();

    public void setItems(@NotNull List<PTableItem> items) {
        if (items == null) {
            PTableModel.$$$reportNull$$$0(0);
        }
        Set<PTableItem> openGroups = this.findOpenGroups();
        this.myItems = items;
        this.restoreOpenGroups(openGroups);
        this.fireTableDataChanged();
    }

    public void insertRow(int row, @NotNull PTableItem item) {
        if (item == null) {
            PTableModel.$$$reportNull$$$0(1);
        }
        this.myItems.add(row, item);
        this.fireTableRowsInserted(row, row);
    }

    public void deleteRow(int row) {
        this.myItems.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.myItems.get(row);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.myItems.get(row).setValue(value);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.myItems.get(row).isEditable(col);
    }

    public void collapse(int row) {
        if (row >= this.myItems.size()) {
            return;
        }
        PTableItem item = this.myItems.get(row);
        if (item.hasChildren() && item.isExpanded()) {
            item.setExpanded(false);
            List<PTableItem> children = item.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.myItems.remove(row + 1);
            }
        }
        this.fireTableDataChanged();
    }

    public int getParent(int row) {
        if (row >= this.myItems.size()) {
            return row;
        }
        PTableItem item = this.myItems.get(row);
        if (item.getParent() == null) {
            return row;
        }
        PTableItem parent = item.getParent();
        while (--row >= 0 && this.myItems.get(row) != parent) {
        }
        return row;
    }

    public void expand(int row) {
        this.expandWithoutNotifying(row);
        this.fireTableDataChanged();
    }

    private void expandWithoutNotifying(int row) {
        if (row >= this.myItems.size()) {
            return;
        }
        PTableItem item = this.myItems.get(row);
        if (item.hasChildren() && !item.isExpanded()) {
            item.setExpanded(true);
            List<PTableItem> children = item.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.myItems.add(row + 1 + i, children.get(i));
            }
        }
    }

    @NotNull
    private Set<PTableItem> findOpenGroups() {
        Set<PTableItem> set = this.myItems.stream().filter(PTableItem::isExpanded).collect(Collectors.toSet());
        if (set == null) {
            PTableModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    private void restoreOpenGroups(@NotNull Set<PTableItem> openGroups) {
        if (openGroups == null) {
            PTableModel.$$$reportNull$$$0(3);
        }
        for (int row = 0; row < this.myItems.size(); ++row) {
            PTableItem item = this.myItems.get(row);
            if (!openGroups.contains(item)) continue;
            this.expandWithoutNotifying(row);
            row += item.getChildren().size();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/ptable/PTableModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/ptable/PTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findOpenGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "insertRow";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restoreOpenGroups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

