/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedColumnTable
extends JBTable
implements PropertyChangeListener {
    private int fixedColumnCount;
    private final JTable fixed;

    public FixedColumnTable(@NotNull TableModel model) {
        if (model == null) {
            FixedColumnTable.$$$reportNull$$$0(0);
        }
        super(model);
        this.addPropertyChangeListener(this);
        this.fixed = new JBTable(){

            public int getRowHeight() {
                return FixedColumnTable.this.getRowHeight();
            }

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (!toggle && !extend) {
                    FixedColumnTable.clearSelectionAndAnchorAndLead(FixedColumnTable.this.getColumnModel().getSelectionModel());
                }
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }
        };
        this.fixed.setAutoCreateColumnsFromModel(false);
        this.fixed.setModel(model);
        this.fixed.setSelectionModel(this.getSelectionModel());
        this.setAutoResizeMode(0);
        this.fixed.setAutoResizeMode(0);
        this.fixed.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                JViewport fixedViewport = (JViewport)SwingUtilities.getUnwrappedParent(FixedColumnTable.this.fixed);
                Dimension size = fixedViewport.getPreferredSize();
                size.width = FixedColumnTable.this.fixed.getWidth();
                fixedViewport.setPreferredSize(size);
                FixedColumnTable.this.getScrollPane().revalidate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/ui/FixedColumnTable$2", "componentResized"));
            }
        });
        this.fixed.setInputMap(0, this.getInputMap(0));
        this.fixed.setActionMap(this.getActionMap());
    }

    public int[] getSelectedColumnModelIndices() {
        return IntStream.concat(Arrays.stream(this.fixed.getSelectedColumns()).map(this.fixed::convertColumnIndexToModel), Arrays.stream(this.getSelectedColumns()).map(arg_0 -> this.convertColumnIndexToModel(arg_0))).toArray();
    }

    public void removeEditor() {
        super.removeEditor();
        this.fixed.removeEditor();
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (!toggle && !extend) {
            FixedColumnTable.clearSelectionAndAnchorAndLead(this.fixed.getColumnModel().getSelectionModel());
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    private static void clearSelectionAndAnchorAndLead(@NotNull ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            FixedColumnTable.$$$reportNull$$$0(1);
        }
        selectionModel.clearSelection();
        selectionModel.setAnchorSelectionIndex(-1);
        selectionModel.setLeadSelectionIndex(-1);
    }

    public void setDefaultRenderer(@NotNull Class<?> columnClass, @Nullable TableCellRenderer renderer) {
        if (columnClass == null) {
            FixedColumnTable.$$$reportNull$$$0(2);
        }
        super.setDefaultRenderer(columnClass, renderer);
        if (this.fixed != null) {
            this.fixed.setDefaultRenderer(columnClass, renderer);
        }
    }

    public void setDefaultEditor(@NotNull Class<?> columnClass, @NotNull TableCellEditor editor) {
        if (columnClass == null) {
            FixedColumnTable.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            FixedColumnTable.$$$reportNull$$$0(4);
        }
        super.setDefaultEditor(columnClass, editor);
        if (this.fixed != null) {
            this.fixed.setDefaultEditor(columnClass, editor);
        }
    }

    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        super.setCellSelectionEnabled(cellSelectionEnabled);
        this.fixed.setCellSelectionEnabled(cellSelectionEnabled);
    }

    public void setRowSorter(@NotNull RowSorter<? extends TableModel> sorter) {
        if (sorter == null) {
            FixedColumnTable.$$$reportNull$$$0(5);
        }
        super.setRowSorter(sorter);
        this.fixed.setRowSorter(sorter);
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            scrollPane.setViewportBorder(null);
            scrollPane.setRowHeaderView(this.fixed);
            scrollPane.setCorner("UPPER_LEFT_CORNER", this.fixed.getTableHeader());
        }
    }

    @Nullable
    private JScrollPane getScrollPane() {
        Container grandparent;
        Container parent = SwingUtilities.getUnwrappedParent((Component)((Object)this));
        if (parent instanceof JViewport && (grandparent = parent.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)grandparent;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || SwingUtilities.getUnwrappedView(viewport) != this) {
                return null;
            }
            return scrollPane;
        }
        return null;
    }

    public int getTotalColumnCount() {
        return (this.fixed == null ? 0 : this.fixed.getColumnCount()) + this.getColumnCount();
    }

    public void setFixedColumnCount(int fixedColumnCount) {
        this.fixedColumnCount = fixedColumnCount;
        this.updateFixedColumns();
    }

    public void addColumn(@NotNull TableColumn column) {
        if (column == null) {
            FixedColumnTable.$$$reportNull$$$0(6);
        }
        if (column.getModelIndex() < this.fixedColumnCount) {
            this.fixed.addColumn(column);
        } else {
            super.addColumn(column);
        }
    }

    public void removeColumn(@NotNull TableColumn column) {
        if (column == null) {
            FixedColumnTable.$$$reportNull$$$0(7);
        }
        if (column.getModelIndex() < this.fixedColumnCount) {
            this.fixed.removeColumn(column);
        } else {
            super.removeColumn(column);
        }
    }

    @NotNull
    public TableColumn getColumn(int columnIndex) {
        if (columnIndex < this.fixed.getColumnCount()) {
            TableColumn tableColumn = this.fixed.getColumnModel().getColumn(columnIndex);
            if (tableColumn == null) {
                FixedColumnTable.$$$reportNull$$$0(8);
            }
            return tableColumn;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(columnIndex - this.fixed.getColumnCount());
        if (tableColumn == null) {
            FixedColumnTable.$$$reportNull$$$0(9);
        }
        return tableColumn;
    }

    @NotNull
    public TableCellRenderer getCellRendererAtModel(int row, int column) {
        if (column < this.fixed.getColumnCount()) {
            TableCellRenderer tableCellRenderer = this.fixed.getCellRenderer(this.fixed.convertRowIndexToView(row), this.fixed.convertColumnIndexToView(column));
            if (tableCellRenderer == null) {
                FixedColumnTable.$$$reportNull$$$0(10);
            }
            return tableCellRenderer;
        }
        TableCellRenderer tableCellRenderer = this.getCellRenderer(this.convertRowIndexToView(row), this.convertColumnIndexToView(column));
        if (tableCellRenderer == null) {
            FixedColumnTable.$$$reportNull$$$0(11);
        }
        return tableCellRenderer;
    }

    @NotNull
    public Object getFixedColumnValueAt(int row, int column) {
        Object object = this.fixed.getValueAt(row, column);
        if (object == null) {
            FixedColumnTable.$$$reportNull$$$0(12);
        }
        return object;
    }

    private void updateFixedColumns() {
        TableColumn col1;
        int col;
        TableColumnModel model1 = this.fixed.getColumnModel();
        TableColumnModel model2 = this.getColumnModel();
        for (col = model1.getColumnCount() - 1; col >= 0; --col) {
            col1 = model1.getColumn(col);
            if (col1.getModelIndex() < this.fixedColumnCount) continue;
            model1.removeColumn(col1);
            model2.addColumn(col1);
            model2.moveColumn(model2.getColumnCount(), 0);
        }
        for (col = 0; col < model2.getColumnCount(); ++col) {
            col1 = model2.getColumn(col);
            if (col1.getModelIndex() >= this.fixedColumnCount) continue;
            model2.removeColumn(col1);
            model1.addColumn(col1);
            --col;
        }
        this.fixed.setPreferredScrollableViewportSize(this.fixed.getPreferredSize());
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        String name;
        if (event == null) {
            FixedColumnTable.$$$reportNull$$$0(13);
        }
        if ("selectionModel".equals(name = event.getPropertyName())) {
            this.fixed.setSelectionModel(this.getSelectionModel());
        } else if ("model".equals(name)) {
            this.fixed.setModel(this.getModel());
            this.updateFixedColumns();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/ui/FixedColumnTable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/ui/FixedColumnTable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellRendererAtModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixedColumnValueAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clearSelectionAndAnchorAndLead";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultRenderer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRowSorter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addColumn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeColumn";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

