/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.inspection;

import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodFix;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.inspection.ArquillianDeploymentCountInspectionBase;
import com.intellij.plugins.jboss.arquillian.utils.ArquillianUtils;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianDeploymentAbsentInspection
extends ArquillianDeploymentCountInspectionBase {
    @NonNls
    static final String deploymentMethodName = "createDeployment";

    private static void addProblemIfAnchorNotNull(@NotNull ProblemsHolder holder, @Nullable PsiElement anchor, @NotNull LocalQuickFix[] fixes) {
        if (holder == null) {
            ArquillianDeploymentAbsentInspection.$$$reportNull$$$0(0);
        }
        if (fixes == null) {
            ArquillianDeploymentAbsentInspection.$$$reportNull$$$0(1);
        }
        if (anchor == null) {
            return;
        }
        holder.registerProblem(holder.getManager().createProblemDescriptor(anchor, ArquillianBundle.message("arquillian.deployment.absent", new Object[0]), holder.isOnTheFly(), fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
    }

    private static LocalQuickFix createCreateDeploymentMethodFix(final PsiClass aClass, Set<String> conflictNames) {
        int index = 0;
        String methodName = deploymentMethodName;
        while (conflictNames.contains(methodName)) {
            methodName = deploymentMethodName + ++index;
        }
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)aClass.getProject()).getCodeTemplate("Arquillian Deployment Method.java");
        String templateText = fileTemplate.getText();
        String deploymentRegex = "\\$\\{DEPLOYMENT_NAME\\}";
        String methodText = templateText.replaceAll(deploymentRegex, methodName);
        PsiMethod newMethod = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createMethodFromText(methodText, (PsiElement)aClass);
        final String finalMethodName = methodName;
        return new AddMethodFix(newMethod, aClass){

            protected void postAddAction(@NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, PsiMethod newMethod) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiIdentifier nameIdentifier = newMethod.getNameIdentifier();
                if (editor == null || nameIdentifier == null) {
                    super.postAddAction(file, null, newMethod);
                    return;
                }
                Project project = file.getProject();
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                TextRange range = nameIdentifier.getTextRange();
                editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
                editor.getCaretModel().moveToOffset(nameIdentifier.getTextRange().getStartOffset());
                Template template = TemplateManager.getInstance((Project)aClass.getProject()).createTemplate("", "");
                ConstantNode nameExpr = new ConstantNode(finalMethodName);
                template.addVariable(finalMethodName, (Expression)nameExpr, (Expression)nameExpr, true);
                TemplateManager.getInstance((Project)project).startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentAbsentInspection$1", "postAddAction"));
            }
        };
    }

    @Override
    protected void checkDeploymentMethods(@NotNull PsiClass aClass, @NotNull List<PsiMethod> deploymentMethods, @NotNull ProblemsHolder holder) {
        if (aClass == null) {
            ArquillianDeploymentAbsentInspection.$$$reportNull$$$0(2);
        }
        if (deploymentMethods == null) {
            ArquillianDeploymentAbsentInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            ArquillianDeploymentAbsentInspection.$$$reportNull$$$0(4);
        }
        ArrayList<Object> fixList = new ArrayList<Object>();
        PsiClassType shrinkWrapArchiveType = PsiType.getTypeByName((String)"org.jboss.shrinkwrap.api.Archive", (Project)aClass.getProject(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)aClass.getProject()));
        HashSet<String> conflictNames = new HashSet<String>();
        for (PsiMethod method : aClass.getMethods()) {
            PsiModifierList modifierList;
            if (method.getParameterList().getParametersCount() > 0 || !(modifierList = method.getModifierList()).hasModifierProperty("static")) continue;
            conflictNames.add(method.getName());
            PsiType methodReturnType = method.getReturnType();
            if (methodReturnType == null || !TypeConversionUtil.isAssignable((PsiType)shrinkWrapArchiveType, (PsiType)methodReturnType)) continue;
            AddAnnotationFix addAnnotationFix = new AddAnnotationFix("org.jboss.arquillian.container.test.api.Deployment", (PsiModifierListOwner)method, new String[0]);
            fixList.add(addAnnotationFix);
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            holder.registerProblem((PsiElement)(nameIdentifier == null ? method : nameIdentifier), ArquillianBundle.message("arquillian.deployment.candidate", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{addAnnotationFix});
        }
        fixList.add(0, ArquillianDeploymentAbsentInspection.createCreateDeploymentMethodFix(aClass, conflictNames));
        LocalQuickFix[] fixes = fixList.toArray(LocalQuickFix.EMPTY_ARRAY);
        ArquillianDeploymentAbsentInspection.addProblemIfAnchorNotNull(holder, ArquillianUtils.getJunitArquillianEnabledElement(aClass), fixes);
        ArquillianDeploymentAbsentInspection.addProblemIfAnchorNotNull(holder, ArquillianUtils.getTestngArquillianEnabledElement(aClass), fixes);
    }

    @Override
    protected boolean wouldLikeToCheckMethodCount(int count) {
        return count == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentMethods";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentAbsentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addProblemIfAnchorNotNull";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDeploymentMethods";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

