/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerMode;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerSettingsState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerTransport;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianRunConfigurationCoordinator {
    @NotNull
    private final Project project;

    public ArquillianRunConfigurationCoordinator(@NotNull Project project) {
        if (project == null) {
            ArquillianRunConfigurationCoordinator.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    @Nullable
    public ArquillianContainerState getContainerState(ArquillianRunConfiguration runConfiguration) {
        return ArquillianContainersManager.getInstance(this.project).findStateByName(runConfiguration.getContainerStateName());
    }

    @Nullable
    public RemoteConnectionCreator getRemoteConnectionCreator(ArquillianRunConfiguration runConfiguration) {
        ArquillianContainerState containerState = this.getContainerState(runConfiguration);
        if (containerState == null || !containerState.configurationSpecificState.remoteDebuggingEnabled) {
            return null;
        }
        final RemoteDebuggerSettingsState remoteDebuggerSettings = containerState.configurationSpecificState.settings.clone();
        return new RemoteConnectionCreator(){

            public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
                return new RemoteConnection(remoteDebuggerSettings.transport == RemoteDebuggerTransport.Socket, remoteDebuggerSettings.host, remoteDebuggerSettings.transport == RemoteDebuggerTransport.Socket ? remoteDebuggerSettings.port : remoteDebuggerSettings.sharedMemoryAddress, remoteDebuggerSettings.mode == RemoteDebuggerMode.Listen);
            }

            public boolean isPollConnection() {
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianRunConfigurationCoordinator", "<init>"));
    }
}

