/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.chart;

import com.intellij.jboss.jbpm.BpmnUtils;
import com.intellij.jboss.jbpm.chart.model.BpmnChartDataModel;
import com.intellij.jboss.jbpm.chart.model.BpmnChartEdge;
import com.intellij.jboss.jbpm.chart.model.BpmnChartNode;
import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.model.xml.bpmndc.Bounds;
import com.intellij.jboss.jbpm.model.xml.bpmndc.Point;
import com.intellij.jboss.jbpm.model.xml.bpmndi.BPMNEdge;
import com.intellij.jboss.jbpm.render.size.ChartNodeSizeEnhancer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnChartLayoutCoordinator
implements ChartLayoutCoordinator {
    @NotNull
    private final Project project;
    @NotNull
    private final BpmnChartDataModel dataModel;

    public BpmnChartLayoutCoordinator(@NotNull Project project, @NotNull BpmnChartDataModel dataModel) {
        if (project == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(0);
        }
        if (dataModel == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.dataModel = dataModel;
    }

    @Nullable
    public List<ChartLayoutCoordinator.Point> getEdgePoints(@NotNull String sourceNodeId, @NotNull String targetNodeId) {
        BpmnChartEdge chartEdge;
        if (sourceNodeId == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(2);
        }
        if (targetNodeId == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(3);
        }
        if ((chartEdge = (BpmnChartEdge)this.dataModel.getEdge(Pair.create((Object)sourceNodeId, (Object)targetNodeId))) == null || chartEdge.getLayout() == null) {
            return null;
        }
        return JBIterable.from(chartEdge.getLayout().getWaypoints()).transform(point -> new ChartLayoutCoordinator.Point(BpmnUtils.getAttributeValue(point.getX()), BpmnUtils.getAttributeValue(point.getY()))).toList();
    }

    @Nullable
    public Runnable getChangeEdgePointsAction(@NotNull String sourceNodeId, @NotNull String targetNodeId, @NotNull List<ChartLayoutCoordinator.Point> points) {
        BpmnChartEdge chartEdge;
        if (sourceNodeId == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(4);
        }
        if (targetNodeId == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(5);
        }
        if (points == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(6);
        }
        if ((chartEdge = (BpmnChartEdge)this.dataModel.getEdge(Pair.create((Object)sourceNodeId, (Object)targetNodeId))) == null) {
            return null;
        }
        BPMNEdge edgeLayout = chartEdge.getLayout();
        if (edgeLayout == null) {
            return null;
        }
        if (points.equals(this.getEdgePoints(sourceNodeId, targetNodeId))) {
            return null;
        }
        return () -> {
            if (points == null) {
                BpmnChartLayoutCoordinator.$$$reportNull$$$0(13);
            }
            List<Point> wayPoints = edgeLayout.getWaypoints();
            for (Point point : wayPoints) {
                point.undefine();
            }
            for (Point point : points) {
                Point wayPoint = edgeLayout.addWaypoint();
                wayPoint.getX().setValue((Object)((ChartLayoutCoordinator.Point)point).x);
                wayPoint.getY().setValue((Object)((ChartLayoutCoordinator.Point)point).y);
            }
        };
    }

    @Nullable
    public ChartLayoutCoordinator.NodeLayout getNodeLayout(@NotNull String fqn, ChartNodeSizeEnhancer enhancer) {
        BpmnChartNode chartNode;
        if (fqn == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(7);
        }
        if ((chartNode = (BpmnChartNode)this.dataModel.getNode(fqn)) == null || chartNode.getLayout() == null) {
            return null;
        }
        Bounds bounds = chartNode.getLayout().getBounds();
        return BpmnChartLayoutCoordinator.createNodeLayout(bounds, enhancer);
    }

    @NotNull
    private static ChartLayoutCoordinator.Size createNodeSize(Bounds bounds, @Nullable ChartNodeSizeEnhancer enhancer) {
        ChartLayoutCoordinator.Size size = new ChartLayoutCoordinator.Size(BpmnUtils.getAttributeValue(bounds.getWidth()), BpmnUtils.getAttributeValue(bounds.getHeight()));
        if (enhancer != null) {
            size = enhancer.enhance(size);
        }
        ChartLayoutCoordinator.Size size2 = size;
        if (size2 == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(8);
        }
        return size2;
    }

    @NotNull
    private static ChartLayoutCoordinator.NodeLayout createNodeLayout(Bounds bounds, @Nullable ChartNodeSizeEnhancer enhancer) {
        ChartLayoutCoordinator.Size size = BpmnChartLayoutCoordinator.createNodeSize(bounds, enhancer);
        double x = BpmnUtils.getAttributeValue(bounds.getX());
        double y = BpmnUtils.getAttributeValue(bounds.getY());
        ChartLayoutCoordinator.NodeLayout nodeLayout = ChartLayoutCoordinator.NodeLayout.createByEdges((double)x, (double)y, (double)(x + size.width), (double)(y + size.height));
        if (nodeLayout == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(9);
        }
        return nodeLayout;
    }

    @Nullable
    public Runnable getChangeNodeLayoutAction(@NotNull String fqn, @Nullable ChartLayoutCoordinator.NodeLayout layout, @Nullable ChartNodeSizeEnhancer enhancer) {
        ChartLayoutCoordinator.Size newSize;
        BpmnChartNode chartNode;
        if (fqn == null) {
            BpmnChartLayoutCoordinator.$$$reportNull$$$0(10);
        }
        if ((chartNode = (BpmnChartNode)this.dataModel.getNode(fqn)) == null) {
            return null;
        }
        if (chartNode.getLayout() == null) {
            if (layout == null) {
                return null;
            }
            return () -> {
                if (fqn == null) {
                    BpmnChartLayoutCoordinator.$$$reportNull$$$0(12);
                }
                chartNode.setLayout(this.dataModel.createNodeShape(fqn, layout.getCenter(), layout.getSize()));
            };
        }
        if (layout == null) {
            return () -> {
                if (fqn == null) {
                    BpmnChartLayoutCoordinator.$$$reportNull$$$0(11);
                }
                ((BpmnChartNode)this.dataModel.getNode(fqn)).removeLayout();
            };
        }
        Bounds bounds = chartNode.getLayout().getBounds();
        ChartLayoutCoordinator.NodeLayout oldLayout = BpmnChartLayoutCoordinator.createNodeLayout(bounds, enhancer);
        if (oldLayout.equals((Object)layout)) {
            return null;
        }
        ChartLayoutCoordinator.Size oldSize = BpmnChartLayoutCoordinator.createNodeSize(bounds, enhancer);
        boolean resizeNode = !oldSize.equals((Object)(newSize = new ChartLayoutCoordinator.Size(layout.getWidth(), layout.getHeight())));
        return () -> {
            Bounds bounds1 = chartNode.getLayout().getBounds();
            bounds1.getX().setValue((Object)layout.getLeft());
            bounds1.getY().setValue((Object)layout.getTop());
            if (resizeNode) {
                bounds1.getWidth().setValue((Object)layout.getWidth());
                bounds1.getHeight().setValue((Object)layout.getHeight());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNodeId";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNodeId";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeSize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEdgePoints";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChangeEdgePointsAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeLayout";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChangeNodeLayoutAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChangeNodeLayoutAction$3";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChangeNodeLayoutAction$2";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChangeEdgePointsAction$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

