/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jboss.jbpm.BpmnUtils;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.converters.FlowElementConverter;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TBaseElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TDefinitions;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TBaseElementConverter
extends ResolvingConverter<TBaseElement> {
    @NotNull
    public Collection<? extends TBaseElement> getVariants(ConvertContext context) {
        BpmnDomModel model = FlowElementConverter.getDomModel(context);
        List<Object> list = model == null ? Collections.emptyList() : this.getBaseElements(model);
        if (list == null) {
            TBaseElementConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    public TBaseElement fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        BpmnDomModel domModel = FlowElementConverter.getDomModel(context);
        if (domModel == null) {
            return null;
        }
        List<TBaseElement> baseElements = this.getBaseElements(domModel);
        for (TBaseElement element : baseElements) {
            if (!s.equals(element.getId().getStringValue())) continue;
            return element;
        }
        return null;
    }

    protected abstract Set<String> possiblyReferencedTypes();

    private List<TBaseElement> getBaseElements(BpmnDomModel domModel) {
        Set<String> tags = this.possiblyReferencedTypes();
        TDefinitions definitions = domModel.getDefinitions();
        ArrayList<TBaseElement> result = new ArrayList<TBaseElement>();
        BpmnUtils.processAllElements(Collections.singletonList(definitions), (Processor<? super TBaseElement>)((Processor)child -> {
            XmlTag tag = child.getXmlTag();
            String localName = tag.getLocalName();
            if (tags == null || tags.contains(localName)) {
                result.add((TBaseElement)child);
            }
            return true;
        }));
        return result;
    }

    public String toString(@Nullable TBaseElement element, ConvertContext context) {
        if (element == null) {
            return null;
        }
        return element.getId().getStringValue();
    }

    public LookupElement createLookupElement(TBaseElement identified) {
        return FlowElementConverter.createLookupElementImpl(identified);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/converters/TBaseElementConverter", "getVariants"));
    }

    public static class AnyBaseElementConverter
    extends TBaseElementConverter {
        @Override
        protected Set<String> possiblyReferencedTypes() {
            return null;
        }
    }
}

