/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.el;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpdlELVariablesCollectorUtil {
    private static final List<Pair<String, String>> predefinedVars = new ArrayList<Pair<String, String>>();

    public static List<JspImplicitVariable> collectPredefinedVariables(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JpdlELVariablesCollectorUtil.$$$reportNull$$$0(0);
        }
        ArrayList<JspImplicitVariable> vars = new ArrayList<JspImplicitVariable>();
        PsiType objectClassType = JpdlELVariablesCollectorUtil.getObjectClassType(psiFile.getProject());
        for (Pair<String, String> pair : predefinedVars) {
            String varName = (String)pair.first;
            String className = (String)pair.second;
            PsiType psiType = JpdlELVariablesCollectorUtil.getPsiClassTypeByName(psiFile.getProject(), className);
            if (psiType == null) {
                psiType = objectClassType;
            }
            JpdlELVariablesCollectorUtil.addImplicitVariable((PsiElement)new FakePsiElement(){

                public PsiElement getParent() {
                    return psiFile;
                }
            }, varName, vars, psiType, psiFile);
        }
        return vars;
    }

    @Nullable
    private static PsiType getPsiClassTypeByName(Project project, String className) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = psiFacade.findClass(className, GlobalSearchScope.allScope((Project)project));
        return psiClass == null ? null : psiFacade.getElementFactory().createType(psiClass);
    }

    private static PsiType getObjectClassType(Project project) {
        PsiType psiType = JpdlELVariablesCollectorUtil.getPsiClassTypeByName(project, "java.lang.Object");
        return psiType == null ? PsiType.VOID : psiType;
    }

    private static void addImplicitVariable(PsiElement psiElement, @Nullable String name, List<JspImplicitVariable> result, @Nullable PsiType type, PsiFile file) {
        if (name == null || name.length() == 0 || type == null) {
            return;
        }
        result.add((JspImplicitVariable)new ELImplicitVariable((PsiElement)file, name, type, psiElement, "NESTED"));
    }

    static {
        predefinedVars.add((Pair<String, String>)Pair.create((Object)"processInstance", (Object)"org.jbpm.api.ProcessInstance"));
        predefinedVars.add((Pair<String, String>)Pair.create((Object)"processDefinition", (Object)"org.jbpm.api.ProcessDefinition"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/jboss/jpdl/el/JpdlELVariablesCollectorUtil", "collectPredefinedVariables"));
    }
}

