/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CoverageListNode
extends AbstractTreeNode {
    protected CoverageSuitesBundle myBundle;
    protected CoverageViewManager.StateBean myStateBean;
    private final FileStatusManager myFileStatusManager;

    public CoverageListNode(Project project, @NotNull PsiNamedElement classOrPackage, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean) {
        if (classOrPackage == null) {
            CoverageListNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)classOrPackage);
        this.myName = (String)ReadAction.compute(() -> {
            if (classOrPackage == null) {
                CoverageListNode.$$$reportNull$$$0(4);
            }
            return classOrPackage.getName();
        });
        this.myBundle = bundle;
        this.myStateBean = stateBean;
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Object[] children = CoverageViewTreeStructure.getChildren((Object)this, this.myBundle, this.myStateBean);
        List<CoverageListNode> list = Arrays.asList((CoverageListNode[])children);
        if (list == null) {
            CoverageListNode.$$$reportNull$$$0(1);
        }
        return list;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            CoverageListNode.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object value;
            if (presentation == null) {
                CoverageListNode.$$$reportNull$$$0(3);
            }
            if ((value = this.getValue()) instanceof PsiNamedElement) {
                if (value instanceof PsiQualifiedNamedElement && (this.myStateBean.myFlattenPackages && ((PsiNamedElement)value).getContainingFile() == null || this.getParent() instanceof CoverageListRootNode)) {
                    presentation.setPresentableText(((PsiQualifiedNamedElement)value).getQualifiedName());
                } else {
                    presentation.setPresentableText(((PsiNamedElement)value).getName());
                }
                presentation.setIcon(((PsiElement)value).getIcon(0));
            }
        });
    }

    public FileStatus getFileStatus() {
        PsiFile containingFile = (PsiFile)ReadAction.compute(() -> {
            Object value = this.getValue();
            if (value instanceof PsiElement && ((PsiElement)value).isValid()) {
                return ((PsiElement)value).getContainingFile();
            }
            return null;
        });
        return containingFile != null ? this.myFileStatusManager.getStatus(containingFile.getVirtualFile()) : super.getFileStatus();
    }

    public boolean canNavigate() {
        Object value = this.getValue();
        return value instanceof PsiElement && ((PsiElement)value).isValid() && ((PsiElement)value).getContainingFile() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            PsiNamedElement value = (PsiNamedElement)this.getValue();
            if (requestFocus) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)value, (boolean)true);
            } else if (value instanceof NavigationItem) {
                ((NavigationItem)value).navigate(requestFocus);
            }
        }
    }

    public int getWeight() {
        return (Integer)ReadAction.compute(() -> {
            Object value = this.getValue();
            if (value instanceof PsiElement && ((PsiElement)value).getContainingFile() != null) {
                return 40;
            }
            return 30;
        });
    }

    public boolean contains(VirtualFile file) {
        boolean equalContainingFile;
        Object value = this.getValue();
        if (value instanceof PsiElement && (equalContainingFile = Comparing.equal((Object)PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value)), (Object)file))) {
            return true;
        }
        if (value instanceof PsiDirectory) {
            return this.contains(file, (PsiDirectory)value);
        }
        if (value instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = ((PsiDirectoryContainer)value).getDirectories()) {
                if (!this.contains(file, directory)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(VirtualFile file, PsiDirectory value) {
        if (this.myStateBean.myFlattenPackages) {
            return Comparing.equal((Object)value.getVirtualFile(), (Object)file.getParent());
        }
        return VfsUtilCore.isAncestor((VirtualFile)value.getVirtualFile(), (VirtualFile)file, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$update$1";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

