/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javaee.cloudfoundry.CFBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class CFManifest {
    private static final String APPLICATIONS_BLOCK_NAME = "applications";
    private static final String SERVICES_BLOCK_NAME = "services";
    private static final String MEMORY_PARAMETER_NAME = "memory";
    private static final String INSTANCES_PARAMETER_NAME = "instances";
    private static final String APPLICATION_PARAMETERS_NAME = "name";
    private static final String DOMAIN_PARAMETER_NAME = "domain";
    private static final String DOMAINS_PARAMETER_NAME = "domains";
    private static final String BUILD_PACK_URL_PARAMETER_NAME = "buildpack";
    private static final String COMMAND_PARAMETER_NAME = "command";
    private static final String DISK_QUOTA_PARAMETER_NAME = "disk_quota";
    private static final String HOST_PARAMETER_NAME = "host";
    private static final String HOSTS_PARAMETER_NAME = "hosts";
    private static final String NO_HOSTNAME_PARAMETER_NAME = "no-hostname";
    private static final String NO_ROUTE_PARAMETER_NAME = "no-route";
    private static final String STACK_PARAMETER_NAME = "stack";
    private static final String ENV_PARAMETER_NAME = "env";
    private static final String TIMEOUT_PARAMETER_NAME = "timeout";
    private static final String INHERIT_PARAMETER_NAME = "inherit";
    private String myPath;
    private String myCurrentApplication;

    public CFManifest(String path) {
        this.myPath = path;
    }

    public CFManifest() {
        this("");
    }

    public void validate() throws RuntimeConfigurationError {
        if (StringUtil.isEmpty((String)this.myPath)) {
            return;
        }
        this.doGetApplications();
        this.addCommonApplicationParameters(new HashMap());
    }

    @NotNull
    private Map getApplicationParameters() {
        for (Object application : this.getApplications()) {
            Map applicationMap = (Map)ObjectUtils.tryCast(application, Map.class);
            if (applicationMap == null) continue;
            String applicationName = (String)ObjectUtils.tryCast(applicationMap.get(APPLICATION_PARAMETERS_NAME), String.class);
            if (this.myCurrentApplication != null && !StringUtil.equals((CharSequence)applicationName, (CharSequence)this.myCurrentApplication)) continue;
            HashMap result = new HashMap();
            try {
                this.addCommonApplicationParameters(result);
            }
            catch (RuntimeConfigurationError runtimeConfigurationError) {
                // empty catch block
            }
            result.putAll(applicationMap);
            HashMap hashMap = result;
            if (hashMap == null) {
                CFManifest.$$$reportNull$$$0(0);
            }
            return hashMap;
        }
        Map map = Collections.emptyMap();
        if (map == null) {
            CFManifest.$$$reportNull$$$0(1);
        }
        return map;
    }

    private void addCommonApplicationParameters(Map applicationParams) throws RuntimeConfigurationError {
        Map root = this.getYamlManifestRoot();
        String inheritedPath = (String)ObjectUtils.tryCast(root.get(INHERIT_PARAMETER_NAME), String.class);
        if (inheritedPath != null) {
            if (!FileUtil.isAbsolute((String)inheritedPath)) {
                inheritedPath = FileUtil.join((String[])new String[]{new File(this.myPath).getParentFile().getPath(), inheritedPath});
            }
            CFManifest inheritedManifest = new CFManifest(inheritedPath);
            inheritedManifest.addCommonApplicationParameters(applicationParams);
        }
        applicationParams.putAll(root);
    }

    private Map getYamlManifestRoot() throws RuntimeConfigurationError {
        if (StringUtil.isEmpty((String)this.myPath)) {
            throw new RuntimeConfigurationError("Manifest path is not specified");
        }
        File manifestFile = new File(this.myPath);
        Yaml yaml = new Yaml();
        try {
            Object root = yaml.load(FileUtil.loadFile((File)manifestFile, (Charset)CharsetToolkit.UTF8_CHARSET));
            Map result = (Map)ObjectUtils.tryCast((Object)root, Map.class);
            if (result == null) {
                throw new ManifestFileException("manifest file is empty");
            }
            return result;
        }
        catch (IOException e) {
            throw new ManifestFileException(e);
        }
        catch (YAMLException e) {
            throw new ManifestFileException((Exception)((Object)e));
        }
    }

    public Integer getMemory() {
        return this.getDiskOrMemoryLimit(MEMORY_PARAMETER_NAME);
    }

    public Integer getDiskQuota() {
        return this.getDiskOrMemoryLimit(DISK_QUOTA_PARAMETER_NAME);
    }

    public Integer getTimeout() {
        return (Integer)ObjectUtils.tryCast(this.getApplicationParameters().get(TIMEOUT_PARAMETER_NAME), Integer.class);
    }

    private Integer getDiskOrMemoryLimit(String parameter) {
        Object memoryParameter = this.getApplicationParameters().get(parameter);
        if (memoryParameter == null) {
            return null;
        }
        if (memoryParameter instanceof Integer) {
            return (Integer)memoryParameter;
        }
        if (memoryParameter instanceof String) {
            String memoryParameterString = (String)memoryParameter;
            if (StringUtil.isEmpty((String)memoryParameterString)) {
                return null;
            }
            for (MemorySuffix memorySuffix : MemorySuffix.values()) {
                if (!StringUtil.endsWithIgnoreCase((String)memoryParameterString, (String)memorySuffix.getSuffix()) && !StringUtil.endsWithIgnoreCase((String)memoryParameterString, (String)memorySuffix.getExtendedSuffix())) continue;
                return CFManifest.getMemoryValue(memoryParameterString, memorySuffix);
            }
        }
        return null;
    }

    private static Integer getMemoryValue(String value, MemorySuffix suffix) {
        value = StringUtil.toUpperCase((String)value);
        String numberPart = StringUtil.trimEnd((String)value, (String)suffix.getSuffix());
        numberPart = StringUtil.trimEnd((String)numberPart, (String)suffix.getExtendedSuffix());
        try {
            return Integer.parseInt(numberPart) * suffix.getRatio();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Integer getInstances() {
        return (Integer)ObjectUtils.tryCast(this.getApplicationParameters().get(INSTANCES_PARAMETER_NAME), Integer.class);
    }

    public List<String> getApplicationServices() {
        return this.getListParameter(SERVICES_BLOCK_NAME);
    }

    public List<String> getDomains() {
        ArrayList<String> result = new ArrayList<String>(this.getListParameter(DOMAINS_PARAMETER_NAME));
        ContainerUtil.addIfNotNull(result, (Object)ObjectUtils.tryCast(this.getApplicationParameters().get(DOMAIN_PARAMETER_NAME), String.class));
        return result;
    }

    private List<String> getListParameter(String parameterName) {
        Object listParameter = this.getApplicationParameters().get(parameterName);
        return listParameter instanceof List ? ContainerUtil.map((Collection)((List)listParameter), (Function)Function.TO_STRING) : Collections.emptyList();
    }

    public String getBuildpackUrl() {
        return (String)ObjectUtils.tryCast(this.getApplicationParameters().get(BUILD_PACK_URL_PARAMETER_NAME), String.class);
    }

    public String getStack() {
        return (String)ObjectUtils.tryCast(this.getApplicationParameters().get(STACK_PARAMETER_NAME), String.class);
    }

    public Map<String, String> getEnvs() {
        Map envMap = (Map)ObjectUtils.tryCast(this.getApplicationParameters().get(ENV_PARAMETER_NAME), Map.class);
        if (envMap == null) {
            return Collections.emptyMap();
        }
        return ContainerUtil.map2MapNotNull(envMap.entrySet(), entry -> {
            String name = (String)ObjectUtils.tryCast(entry.getKey(), String.class);
            String value = (String)ObjectUtils.tryCast(entry.getValue(), String.class);
            return name != null && value != null ? new Pair((Object)name, (Object)value) : null;
        });
    }

    public String getCommand() {
        return (String)ObjectUtils.tryCast(this.getApplicationParameters().get(COMMAND_PARAMETER_NAME), String.class);
    }

    public List<String> getHosts() {
        ArrayList<String> result = new ArrayList<String>(this.getListParameter(HOSTS_PARAMETER_NAME));
        ContainerUtil.addIfNotNull(result, (Object)ObjectUtils.tryCast(this.getApplicationParameters().get(HOST_PARAMETER_NAME), String.class));
        return result;
    }

    public boolean noHostName() {
        return (Boolean)ObjectUtils.notNull((Object)ObjectUtils.tryCast(this.getApplicationParameters().get(NO_HOSTNAME_PARAMETER_NAME), Boolean.class), (Object)false);
    }

    public boolean noRoute() {
        return (Boolean)ObjectUtils.notNull((Object)ObjectUtils.tryCast(this.getApplicationParameters().get(NO_ROUTE_PARAMETER_NAME), Boolean.class), (Object)false);
    }

    @NotNull
    private List getApplications() {
        List list;
        try {
            list = this.doGetApplications();
        }
        catch (RuntimeConfigurationError e) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                CFManifest.$$$reportNull$$$0(3);
            }
            return list2;
        }
        if (list == null) {
            CFManifest.$$$reportNull$$$0(2);
        }
        return list;
    }

    private List doGetApplications() throws RuntimeConfigurationError {
        List applications = (List)ObjectUtils.tryCast(this.getYamlManifestRoot().get(APPLICATIONS_BLOCK_NAME), List.class);
        if (applications == null) {
            throw new RuntimeConfigurationError("Invalid manifest format: incorrect applications section.");
        }
        return applications;
    }

    @NotNull
    public List<String> getApplicationsNames() {
        ArrayList<String> result = new ArrayList<String>();
        List applications = this.getApplications();
        for (Object application : applications) {
            String applicationName;
            Map applicationMap = (Map)ObjectUtils.tryCast(application, Map.class);
            if (applicationMap == null || !StringUtil.isNotEmpty((String)(applicationName = (String)ObjectUtils.tryCast(applicationMap.get(APPLICATION_PARAMETERS_NAME), String.class)))) continue;
            result.add(applicationName);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            CFManifest.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public String getPath() {
        return this.myPath;
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    public void setCurrentApplication(String application) {
        this.myCurrentApplication = application;
    }

    public String getCurrentApplication() {
        return this.myCurrentApplication;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/cloudfoundry/cloud/CFManifest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationParameters";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplications";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationsNames";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ManifestFileException
    extends RuntimeConfigurationError {
        ManifestFileException(Exception cause) {
            this(cause.getMessage());
        }

        ManifestFileException(String message) {
            super(CFBundle.getText("CFManifest.invalid.manifest.file", CFManifest.this.myPath, message));
        }
    }

    private static enum MemorySuffix {
        MEGABYTE("M", "MB", 1),
        GIGABYTE("G", "GB", 1024);

        private final String mySuffix;
        private final String myExtendedSuffix;
        private final int myRatio;

        private MemorySuffix(String suffix, String extendedSuffix, int ratio) {
            this.mySuffix = suffix;
            this.myExtendedSuffix = extendedSuffix;
            this.myRatio = ratio;
        }

        public String getSuffix() {
            return this.mySuffix;
        }

        public String getExtendedSuffix() {
            return this.myExtendedSuffix;
        }

        public int getRatio() {
            return this.myRatio;
        }
    }
}

