/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.javaee.oss.jetty.server.JettyIniProcessor;
import com.intellij.javaee.oss.jetty.server.JettyIniScanner;
import com.intellij.javaee.oss.jetty.server.JettyLocalModel;
import com.intellij.javaee.oss.server.JavaeePortConfig;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.javaee.oss.util.ConfigFileWrapper;
import java.io.File;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;

public class JettyPortConfig
extends JavaeePortConfig {
    private static final String PORT_PROPERTY = "jetty.port";
    private static final String HTTP_PORT_PROPERTY = "jetty.http.port";
    private static final JavaeePortConfig.Factory<JettyLocalModel> DEFAULT_FACTORY = new JettyFactory();

    public static int getHttp(JettyLocalModel model) {
        return JettyPortConfig.get(DEFAULT_FACTORY, (JavaeeServerModel)model, (int)model.getDefaultPort());
    }

    private static int doGetIniPort(JettyLocalModel model) {
        return model.getVersionHandler().hasIniFile() ? new JettyIniPortScanner(model.getWorkDir()).getPort() : Integer.MAX_VALUE;
    }

    private static int doGetConfigPort(JettyLocalModel model) {
        Integer configPort = (Integer)new ConfigFileWrapper<Integer>(){

            protected Integer doGet(Element rootElement) throws JDOMException {
                XPath xPath = XPath.newInstance((String)"/Configure/Call/Arg/New/Set[@name='port']/Property[@name='jetty.port' or @name='jetty.http.port']/@default");
                String port = xPath.valueOf((Object)rootElement.getDocument());
                return JavaeePortConfig.safeParseInt((String)port);
            }
        }.get(JettyPortConfig.getConfigFile(model));
        return configPort != null ? configPort : Integer.MAX_VALUE;
    }

    private static File getConfigFile(JettyLocalModel model) {
        return new File(model.getHome(), model.getVersionHandler().getHttpPortConfigFilePath());
    }

    protected long getStamp(JavaeeServerModel data) {
        JettyLocalModel localModel = (JettyLocalModel)data;
        long stamp = JettyPortConfig.getStamp((File)JettyPortConfig.getConfigFile(localModel));
        for (File file : JettyIniScanner.getIniFiles(localModel.getWorkDir())) {
            stamp ^= JettyPortConfig.getStamp((File)file);
        }
        return stamp;
    }

    protected int getPort(JavaeeServerModel model) {
        JettyLocalModel serverModel = (JettyLocalModel)model;
        Integer httpPortVmOption = JettyPortConfig.safeParseInt((String)model.getVmArgument(serverModel.isJetty93Plus() ? HTTP_PORT_PROPERTY : PORT_PROPERTY));
        if (httpPortVmOption != null) {
            return httpPortVmOption;
        }
        int iniPort = JettyPortConfig.doGetIniPort(serverModel);
        return iniPort == Integer.MAX_VALUE ? JettyPortConfig.doGetConfigPort(serverModel) : iniPort;
    }

    private static class JettyFactory
    implements JavaeePortConfig.Factory<JettyLocalModel> {
        private JettyFactory() {
        }

        @NotNull
        public CachedConfig.Key createKey(JettyLocalModel data) {
            CachedConfig.Key key = new CachedConfig.Key(new String[]{data.getHome(), "VM:" + data.getVmArguments()});
            if (key == null) {
                JettyFactory.$$$reportNull$$$0(0);
            }
            return key;
        }

        @NotNull
        public JavaeePortConfig createConfig(JettyLocalModel data) {
            JettyPortConfig jettyPortConfig = new JettyPortConfig();
            if (jettyPortConfig == null) {
                JettyFactory.$$$reportNull$$$0(1);
            }
            return jettyPortConfig;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/javaee/oss/jetty/server/JettyPortConfig$JettyFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfig";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class JettyIniPortProcessor
    extends JettyIniProcessor {
        private Integer myPort = Integer.MAX_VALUE;

        JettyIniPortProcessor(String workDir) {
            super(workDir);
        }

        JettyIniPortProcessor(File iniFile) {
            super(iniFile);
        }

        public Integer getPort() {
            this.process();
            return this.myPort;
        }

        @Override
        protected void processParameter(String paramName, String value) {
            if (JettyPortConfig.PORT_PROPERTY.equals(paramName) || JettyPortConfig.HTTP_PORT_PROPERTY.equals(paramName)) {
                this.myPort = Integer.parseInt(value);
            }
        }
    }

    private static class JettyIniPortScanner {
        private final String myWorkDir;
        private final JettyIniPortProcessor myDefaultIniProcessor;

        JettyIniPortScanner(String workDir) {
            this.myWorkDir = workDir;
            this.myDefaultIniProcessor = new JettyIniPortProcessor(this.myWorkDir);
        }

        public Integer getPort() {
            for (File iniFile : JettyIniScanner.getIniFiles(this.myWorkDir)) {
                JettyIniPortProcessor iniPortProcessor = new JettyIniPortProcessor(iniFile);
                Integer port = iniPortProcessor.getPort();
                if (port == Integer.MAX_VALUE) continue;
                return port;
            }
            return this.myDefaultIniProcessor.getPort();
        }
    }
}

