/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.version;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.model.JettyConfigArgElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigCallElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigNewElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigRefElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigSetElement;
import com.intellij.javaee.oss.jetty.model.JettyWebRootElement;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyConfigFileChecker;
import com.intellij.javaee.oss.jetty.server.JettyConfigFileWriter;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesCollector;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesEditor;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentModel;
import com.intellij.javaee.oss.jetty.server.JettyIniProcessor;
import com.intellij.javaee.oss.jetty.server.JettyIniProducer;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.javaee.oss.util.AbstractConnectorCommand;
import com.intellij.javaee.util.JavaeeJdomUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jdom.DocType;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JettyVersionHandlerBase
implements JettyVersionHandler {
    private static final Logger LOG = Logger.getInstance(JettyVersionHandlerBase.class);

    private static boolean isObjectStarted(MBeanServerConnection connection, ObjectName name) throws IOException {
        try {
            return (Boolean)AbstractConnectorCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)name, (String)"started");
        }
        catch (JMException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    protected String createWebAppObjectNameOfFile(File webApp) {
        return this.createWebAppObjectName(FileUtil.getNameWithoutExtension((File)webApp));
    }

    protected String createWebAppObjectName(@Nullable String nameAttribute) {
        StringBuilder result = new StringBuilder();
        result.append(this.getWebAppClassName());
        result.append(":type=webappcontext");
        if (nameAttribute != null) {
            result.append(",");
            result.append(this.getWebAppClassAttributeName());
            result.append("=");
            result.append(nameAttribute);
        }
        result.append(",id=*");
        return result.toString();
    }

    protected String getWebAppClassAttributeName() {
        return "name";
    }

    protected ObjectName getServerObjectName() throws MalformedObjectNameException {
        return AbstractConnectorCommand.createObjectName((String)(this.getServerClassName() + ":type=server,id=0"));
    }

    private ObjectName getScannerObjectName() throws MalformedObjectNameException {
        return AbstractConnectorCommand.createObjectName((String)(this.getUtilClassName() + ":type=scanner,id=0"));
    }

    private ObjectName getJmxObjectName() throws MalformedObjectNameException {
        return AbstractConnectorCommand.createObjectName((String)(this.getJmxClassName() + ":type=mbeancontainer,id=0"));
    }

    protected JettyConfigFileWriter getConfigFileWriter(final File contextDeployTempDir) {
        return new JettyConfigFileWriter(){

            @Override
            protected void createContent(JettyWebRootElement rootElement) {
                JettyConfigCallElement callElement = rootElement.addCall();
                callElement.getName().setValue((Object)"addLifeCycle");
                JettyConfigArgElement argElement = callElement.addArg();
                JettyConfigNewElement newElement = 1.setupNewElement(argElement, JettyVersionHandlerBase.this.getContextDeployerPackageName() + ".ContextDeployer");
                JettyConfigSetElement setContextsElement = 1.setupSetElement(newElement, "contexts");
                JettyConfigRefElement refElement = setContextsElement.addRef();
                refElement.getId().setValue((Object)"Contexts");
                JettyConfigSetElement setDirElement = 1.setupSetElement(newElement, "configurationDir");
                setDirElement.setValue(contextDeployTempDir.getAbsolutePath());
                1.setupScanIntervalSetElement(newElement);
            }
        };
    }

    @Override
    public File writeStartupConfigFile(Project project, File configDir, File deployDir) throws IOException {
        return this.getConfigFileWriter(deployDir).writeConfigFile(project, this, this.getContextsConfigFilename(), this.getServerClassName() + ".Server", configDir, null);
    }

    @Override
    public DeploymentStatus getDeploymentStatus(MBeanServerConnection connection, ObjectName objectName) throws IOException, JMException {
        Object started = AbstractConnectorCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)objectName, (String)"started");
        if (Boolean.TRUE.equals(started)) {
            return DeploymentStatus.DEPLOYED;
        }
        Object failed = AbstractConnectorCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)objectName, (String)"failed");
        if (Boolean.TRUE.equals(failed)) {
            return DeploymentStatus.FAILED;
        }
        return DeploymentStatus.NOT_DEPLOYED;
    }

    @Override
    public boolean isStarted(MBeanServerConnection connection) throws IOException, JMException {
        return JettyVersionHandlerBase.isObjectStarted(connection, this.getServerObjectName()) || JettyVersionHandlerBase.isObjectStarted(connection, this.getScannerObjectName()) || JettyVersionHandlerBase.isObjectStarted(connection, this.getJmxObjectName());
    }

    @Override
    public String getHttpPortConfigFilePath() {
        return "etc/jetty.xml";
    }

    protected String getContextsConfigFilename() {
        return "contexts-config.xml";
    }

    @Override
    public String[] getWebAppObjectNames(JettyDeploymentModel deployment, File webApp) {
        return new String[]{this.getWebAppObjectName(deployment, webApp)};
    }

    @Override
    public FileTypeDescriptor getConfigFileTypeDescriptor() {
        return JettyUtil.CONFIG_FILE_DESCRIPTOR;
    }

    @Override
    public Collection<String> getCommandLineParameters(Collection<String> configFiles) {
        return configFiles;
    }

    @Override
    public List<JettyConfigFileChecker> getConfigFileCheckers(JettyConfigFilesEditor editor) {
        return Arrays.asList(new JettyConfigFileChecker(editor, "etc/jetty.xml", "main config file is not included"), new JettyConfigFileChecker(editor, "etc/jetty-jmx.xml", "JMX config file is not included"));
    }

    @Override
    public JettyConfigFilesCollector getConfigFilesCollector(String home, String workDir, List<JettyConfigFile> configFiles) {
        return new JettyXmlConfigCollector(home, workDir, configFiles);
    }

    @Override
    public JettyIniProducer getIniProducer(String home, Set<String> activePaths) {
        return new PathIniProducer(home, activePaths);
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull String workingDirectory, @NotNull String homeDirectory, @NotNull Collection<String> configurationFiles) {
        if (workingDirectory == null) {
            JettyVersionHandlerBase.$$$reportNull$$$0(0);
        }
        if (homeDirectory == null) {
            JettyVersionHandlerBase.$$$reportNull$$$0(1);
        }
        if (configurationFiles == null) {
            JettyVersionHandlerBase.$$$reportNull$$$0(2);
        }
        JavaParameters javaParameters = new JavaParameters();
        if (javaParameters == null) {
            JettyVersionHandlerBase.$$$reportNull$$$0(3);
        }
        return javaParameters;
    }

    protected abstract String getWebAppObjectName(JettyDeploymentModel var1, File var2);

    protected abstract String getContextDeployerPackageName();

    protected abstract String getServerClassName();

    protected abstract String getUtilClassName();

    protected abstract String getJmxClassName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/jetty/version/JettyVersionHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/jetty/version/JettyVersionHandlerBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PathIniProducer
    extends JettyIniProducer {
        private Set<String> myActivePaths;

        PathIniProducer(String home, Set<String> configFiles) {
            super(home, configFiles);
        }

        @Override
        public void process() {
            this.myActivePaths = new LinkedHashSet<String>(this.getConfigFiles());
            super.process();
            for (String activePath : this.myActivePaths) {
                this.addIniLine(activePath);
            }
        }

        @Override
        protected void processPathLine(String path) {
            Iterator<String> activePathIterator = this.myActivePaths.iterator();
            String localPath = FileUtil.toSystemIndependentName((String)path);
            while (activePathIterator.hasNext()) {
                String activePath = activePathIterator.next();
                activePathIterator.remove();
                this.addIniLine(FileUtil.toSystemIndependentName((String)activePath));
                if (!activePath.equals(localPath)) continue;
                break;
            }
        }
    }

    private class JettyXmlConfigCollector
    extends JettyConfigFilesCollector {
        @NonNls
        private static final String DOCTYPE_ELEMENT_NAME = "Configure";
        @NonNls
        private static final String ETC_FOLDER = "etc";
        @NonNls
        private static final String XML_EXTENSION = ".xml";

        JettyXmlConfigCollector(String home, String workDir, List<JettyConfigFile> configFiles) {
            super(home, workDir, configFiles, XML_EXTENSION);
        }

        @Override
        public void scanIni() {
            new JettyIniProcessor(this.getWorkDir()){

                @Override
                protected void processPathLine(String path) {
                    JettyXmlConfigCollector.this.getOrCreateConfigFile(FileUtil.toSystemDependentName((String)path)).setActive(true);
                }
            }.process();
        }

        @Override
        protected File[] doScanDir() {
            return new File(this.getHome(), ETC_FOLDER).listFiles(pathname -> {
                if (!pathname.getName().endsWith(XML_EXTENSION)) {
                    return false;
                }
                try {
                    DocType docType = JavaeeJdomUtil.loadDocument((File)pathname).getDocType();
                    if (!(docType != null && DOCTYPE_ELEMENT_NAME.equals(docType.getElementName()) && JettyVersionHandlerBase.this.getConfigDocTypePublicId().equals(docType.getPublicID()) && JettyVersionHandlerBase.this.getConfigDocTypeSystemId().equals(docType.getSystemID()))) {
                        return false;
                    }
                }
                catch (IOException | JDOMException e) {
                    return false;
                }
                return true;
            });
        }
    }
}

