/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jfr;

import java.nio.file.Paths;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedThread;
import jdk.jfr.consumer.RecordingFile;

public class Reader {
    private static final String SAMPLE_EVENT_NAME = "jdk.ExecutionSample";
    private static final String THREAD_FILED = "sampledThread";
    private static final String THREAD_STATE_FIELD = "state";

    public static void main(String[] args) {
        try {
            Class.forName("jdk.jfr.consumer.RecordingFile");
        }
        catch (ClassNotFoundException | LinkageError e) {
            System.err.println("Error: At least OracleJDK 9 or OpenJDK 11 is required");
            System.exit(1);
        }
        if (args.length < 1) {
            return;
        }
        try {
            RecordingFile recording = new RecordingFile(Paths.get(args[0], new String[0]));
            int executionSampleEvents = 0;
            int allEvents = 0;
            while (recording.hasMoreEvents()) {
                RecordedEvent event = recording.readEvent();
                if (event.getEventType().getName().endsWith(SAMPLE_EVENT_NAME)) {
                    ++executionSampleEvents;
                    try {
                        RecordedThread thread = (RecordedThread)event.getValue(THREAD_FILED);
                        String state = (String)event.getValue(THREAD_STATE_FIELD);
                        long eventTime = event.getStartTime().toEpochMilli();
                        System.out.println("thread:" + thread.getJavaName());
                        System.out.println("state:" + state);
                        System.out.println("time:" + eventTime);
                        String info = "";
                        if (event.getStackTrace().isTruncated()) {
                            info = "truncated";
                        }
                        System.out.println("stack:" + info);
                        for (RecordedFrame frame : event.getStackTrace().getFrames()) {
                            try {
                                String type = frame.getType();
                                if (type.equals("JIT compiled")) {
                                    type = "JIT";
                                }
                                RecordedMethod method = frame.getMethod();
                                String cls = method.getType().getName();
                                System.out.println(type + " " + cls + " " + method.getName() + " " + method.getDescriptor());
                            }
                            catch (Exception ex) {
                                System.out.println("[unknown]");
                            }
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println("Error: Unexpected dump format: " + ex.getMessage());
                        System.exit(1);
                        continue;
                    }
                }
                ++allEvents;
            }
            System.out.println("statistics:all=" + allEvents + " samples=" + executionSampleEvents);
        }
        catch (NoClassDefFoundError ex) {
            System.err.println("Error: At least OracleJDK 9 or OpenJDK 11 is required");
            System.exit(1);
        }
        catch (Error | Exception ex) {
            System.err.println("Error: " + ex.getMessage());
            System.exit(1);
        }
    }
}

