/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.reactor.inspections;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.frameworks.reactor.inspections.ReactorUastInspectionBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;

public abstract class BaseNonBlockingScopeInspection
extends ReactorUastInspectionBase {
    private static final Set<String> PUBLISHER_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"org.reactivestreams.Publisher", "reactor.core.publisher.Mono", "reactor.core.publisher.Flux"});

    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BaseNonBlockingScopeInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                UCallExpression callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)element);
                if (callExpression == null) {
                    return;
                }
                if (!BaseNonBlockingScopeInspection.this.isSuspiciousCallOnPublisher(callExpression)) {
                    return;
                }
                if (!BaseNonBlockingScopeInspection.isCalledInNonBlockingContext(callExpression)) {
                    return;
                }
                PsiElement methodIdentifierPsi = AnalysisUastUtil.getMethodIdentifierSourcePsi((UCallExpression)callExpression);
                if (methodIdentifierPsi == null) {
                    return;
                }
                BaseNonBlockingScopeInspection.this.report(holder, methodIdentifierPsi);
            }
        };
        if (psiElementVisitor == null) {
            BaseNonBlockingScopeInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    protected abstract void report(@NotNull ProblemsHolder var1, @NotNull PsiElement var2);

    protected boolean isSuspiciousCallOnPublisher(UCallExpression callExpression) {
        UExpression receiver = callExpression.getReceiver();
        if (receiver == null) {
            return false;
        }
        PsiClass receiverPsiClass = AnalysisUastUtil.getTypePsiClass((PsiType)receiver.getExpressionType());
        if (receiverPsiClass == null) {
            return false;
        }
        if (!BaseNonBlockingScopeInspection.isPublisherTypeFqnName(receiverPsiClass.getQualifiedName())) {
            return false;
        }
        if (!BaseNonBlockingScopeInspection.isMethodFromPublisher(callExpression)) {
            return false;
        }
        return this.shouldReportCall(receiver, callExpression);
    }

    protected abstract boolean shouldReportCall(UExpression var1, UCallExpression var2);

    private static boolean isMethodFromPublisher(UCallExpression expression) {
        PsiMethod calledMethod = expression.resolve();
        if (calledMethod == null) {
            return false;
        }
        return BaseNonBlockingScopeInspection.isMethodFromPublisher(calledMethod);
    }

    public static boolean isMethodFromPublisher(@NotNull PsiMethod calledMethod) {
        PsiMethod[] superMethods;
        if (calledMethod == null) {
            BaseNonBlockingScopeInspection.$$$reportNull$$$0(2);
        }
        if ((superMethods = calledMethod.findDeepestSuperMethods()).length == 0) {
            PsiClass methodClass = calledMethod.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            return BaseNonBlockingScopeInspection.isPublisherTypeFqnName(methodClass.getQualifiedName());
        }
        for (PsiMethod superMethod : superMethods) {
            PsiClass methodClass = superMethod.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            if (BaseNonBlockingScopeInspection.isPublisherTypeFqnName(methodClass.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public static boolean isCalledInNonBlockingContext(@NotNull UCallExpression expression) {
        PsiType contextMethodReturnType;
        PsiClass contextMethodReturnTypeClass;
        if (expression == null) {
            BaseNonBlockingScopeInspection.$$$reportNull$$$0(3);
        }
        return (contextMethodReturnTypeClass = AnalysisUastUtil.getTypePsiClass((PsiType)(contextMethodReturnType = AnalysisUastUtil.getContainingMethodOrLambdaReturnType((UCallExpression)expression)))) != null && BaseNonBlockingScopeInspection.isPublisherTypeFqnName(contextMethodReturnTypeClass.getQualifiedName());
    }

    public static boolean isPublisherTypeFqnName(String fqnName) {
        return PUBLISHER_TYPES.contains(fqnName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/frameworks/reactor/inspections/BaseNonBlockingScopeInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/frameworks/reactor/inspections/BaseNonBlockingScopeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMethodFromPublisher";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCalledInNonBlockingContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

