/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.reactor.inspections.reactor;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.frameworks.reactor.inspections.BaseNonBlockingScopeInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;

public class ReactorNonBlockingMethodChecker
implements NonBlockingContextChecker {
    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            ReactorNonBlockingMethodChecker.$$$reportNull$$$0(0);
        }
        return JavaPsiFacade.getInstance((Project)file.getProject()).findClass("reactor.core.publisher.Mono", file.getResolveScope()) != null;
    }

    public boolean isContextNonBlockingFor(@NotNull PsiElement element) {
        UCallExpression callExpression;
        if (element == null) {
            ReactorNonBlockingMethodChecker.$$$reportNull$$$0(1);
        }
        if ((callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)element)) == null) {
            return false;
        }
        return BaseNonBlockingScopeInspection.isCalledInNonBlockingContext(callExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/frameworks/reactor/inspections/reactor/ReactorNonBlockingMethodChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isContextNonBlockingFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

