/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.osgi.SpringOsgiBundle;
import com.intellij.spring.osgi.inspections.SpringOsgiBaseInspection;
import com.intellij.spring.osgi.model.xml.BaseOsgiReference;
import com.intellij.spring.osgi.model.xml.InterfacesOwner;
import com.intellij.spring.osgi.model.xml.Service;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringOsgiServiceCommonInspection
extends SpringOsgiBaseInspection {
    @Override
    protected void checkOsgiService(Service service, Beans beans, DomElementAnnotationHolder holder, CommonSpringModel springModel) {
        super.checkOsgiService(service, beans, holder, springModel);
        SpringOsgiServiceCommonInspection.checkRefBeanIsAssignable(service, holder);
    }

    private static void checkIsInterfaces(Service service, DomElementAnnotationHolder holder) {
        Map<DomElement, PsiClass> serviceInterfaces = SpringOsgiServiceCommonInspection.getServiceInterfaces(service);
        for (DomElement domElement : serviceInterfaces.keySet()) {
            PsiClass psiClass = serviceInterfaces.get(domElement);
            if (psiClass == null || psiClass.isInterface()) continue;
            holder.createProblem(domElement, SpringOsgiBundle.message("service.common.inspection.is.interface", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkRefBeanIsAssignable(Service service, DomElementAnnotationHolder holder) {
        SpringBean innerBean;
        HashSet<PsiClass> mustBeImplemned = new HashSet<PsiClass>(SpringOsgiServiceCommonInspection.getServiceInterfaces(service).values());
        SpringBeanPointer beanPointer = (SpringBeanPointer)service.getRef().getValue();
        if (beanPointer != null) {
            SpringOsgiServiceCommonInspection.checkIsImplemented(service.getRef(), beanPointer.getSpringBean(), mustBeImplemned, holder);
        }
        if ((innerBean = service.getBean()) != null && DomUtil.hasXml((DomElement)innerBean)) {
            SpringOsgiServiceCommonInspection.checkIsImplemented((DomElement)innerBean, (CommonSpringBean)innerBean, mustBeImplemned, holder);
        }
    }

    private static Map<DomElement, PsiClass> getServiceInterfaces(InterfacesOwner interfacesOwner) {
        Project project = interfacesOwner.getManager().getProject();
        HashMap<DomElement, PsiClass> interfaces = new HashMap<DomElement, PsiClass>();
        GenericAttributeValue<PsiClass> anInterface = interfacesOwner.getInterface();
        PsiClass psiClass = (PsiClass)anInterface.getValue();
        if (psiClass != null) {
            interfaces.put((DomElement)anInterface, psiClass);
        }
        for (SpringValue value : interfacesOwner.getInterfaces().getValues()) {
            PsiClass aClass;
            String stringValue = value.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)stringValue) || (aClass = JavaPsiFacade.getInstance((Project)project).findClass(stringValue, GlobalSearchScope.allScope((Project)project))) == null) continue;
            interfaces.put((DomElement)value, aClass);
        }
        return interfaces;
    }

    private static void checkIsImplemented(DomElement domElement, CommonSpringBean bean, Set<PsiClass> mustBeImplmented, DomElementAnnotationHolder holder) {
        Collection<PsiClass> psiClasses = SpringOsgiServiceCommonInspection.getSupportedTypes(bean);
        for (PsiClass aClass : mustBeImplmented) {
            boolean implemented = false;
            for (PsiClass supportedType : psiClasses) {
                if (!supportedType.equals(aClass) && !supportedType.isInheritor(aClass, true)) continue;
                implemented = true;
                break;
            }
            if (implemented) continue;
            holder.createProblem(domElement, SpringOsgiBundle.message("service.common.inspection.interface.must.be.implemented", aClass.getQualifiedName()), new LocalQuickFix[0]);
        }
    }

    private static Collection<PsiClass> getSupportedTypes(CommonSpringBean bean) {
        if (bean instanceof BaseOsgiReference) {
            return SpringOsgiServiceCommonInspection.getServiceInterfaces((BaseOsgiReference)bean).values();
        }
        return ContainerUtil.mapNotNull((Object[])BeanService.getInstance().getEffectiveBeanTypes(bean), PsiTypesUtil::getPsiClass);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringOsgiServiceCommonInspection" == null) {
            SpringOsgiServiceCommonInspection.$$$reportNull$$$0(0);
        }
        return "SpringOsgiServiceCommonInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/osgi/inspections/SpringOsgiServiceCommonInspection", "getShortName"));
    }
}

