/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.model.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.converters.SpringBeanResolveConverterForDefiniteClasses;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.osgi.model.xml.Service;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;

public class ServiceBeanRefConverter
extends SpringBeanResolveConverterForDefiniteClasses {
    protected String[] getClassNames(ConvertContext context) {
        String[] stringArray;
        ArrayList<String> classes = new ArrayList<String>();
        DomElement element = context.getInvocationElement();
        Service service = (Service)element.getParentOfType(Service.class, false);
        if (service != null) {
            PsiClass psiClass = (PsiClass)service.getInterface().getValue();
            if (psiClass != null) {
                classes.add(psiClass.getQualifiedName());
            }
            for (SpringValue value : service.getInterfaces().getValues()) {
                PsiClass aClass;
                String stringValue = value.getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)stringValue)) continue;
                GlobalSearchScope scope = context.getSearchScope();
                if (scope == null) {
                    scope = GlobalSearchScope.allScope((Project)context.getProject());
                }
                if ((aClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(stringValue, scope)) == null) continue;
                classes.add(aClass.getQualifiedName());
            }
        }
        if (classes.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "java.lang.Object";
        } else {
            stringArray = ArrayUtil.toStringArray(classes);
        }
        return stringArray;
    }
}

