/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.agent.version9;

import com.intellij.javaee.weblogic.agent.version9.mbeansModel.AbstractWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.EditServiceWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.MBeansFactory;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.DomainRuntimeServiceWL9MBean;
import java.io.IOException;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeblogicJMXConnector<T extends AbstractWL9MBean> {
    private static final String T3_PROTOCOL = "t3";
    private static final String JNDI_ROOT = "/jndi/";
    private static final String DOMAIN_RUNTIME_MBEAN_SERVER = "weblogic.management.mbeanservers.domainruntime";
    private static final String EDIT_MBEAN_SERVER = "weblogic.management.mbeanservers.edit";
    private static final String WL_PROTOCOL_PROVIDER_PACKAGES = "weblogic.management.remote";
    protected MBeanServerConnection myConnection;
    private JMXConnector myConnector;
    private final String myMBeanServer;

    protected WeblogicJMXConnector(String mbeanServer) {
        this.myMBeanServer = mbeanServer;
    }

    public void connect(String hostname, int port, String username, String password) throws IOException {
        if (this.myConnection != null) {
            return;
        }
        JMXServiceURL serviceURL = new JMXServiceURL(T3_PROTOCOL, hostname, port, JNDI_ROOT + this.myMBeanServer);
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("java.naming.security.principal", username);
        h.put("java.naming.security.credentials", password);
        h.put("jmx.remote.protocol.provider.pkgs", WL_PROTOCOL_PROVIDER_PACKAGES);
        h.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
        this.myConnector = JMXConnectorFactory.connect(serviceURL, h);
        this.myConnection = this.myConnector.getMBeanServerConnection();
    }

    public void disconnect() throws IOException {
        if (this.myConnector != null) {
            this.myConnector.close();
        }
        this.myConnection = null;
        this.myConnector = null;
    }

    public abstract T createRootMBean() throws JMException;

    public static WeblogicJMXConnector<DomainRuntimeServiceWL9MBean> createDomainRuntimeConnector() {
        return new WeblogicJMXConnector<DomainRuntimeServiceWL9MBean>(DOMAIN_RUNTIME_MBEAN_SERVER){

            @Override
            public DomainRuntimeServiceWL9MBean createRootMBean() throws JMException {
                return MBeansFactory.createDomainRuntimeService(this.myConnection);
            }
        };
    }

    public static WeblogicJMXConnector<EditServiceWL9MBean> createEditServiceConnector() {
        return new WeblogicJMXConnector<EditServiceWL9MBean>(EDIT_MBEAN_SERVER){

            @Override
            public EditServiceWL9MBean createRootMBean() throws JMException {
                return MBeansFactory.createEditService(this.myConnection);
            }
        };
    }
}

