/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.actions;

import com.intellij.appengine.cloud.AppEngineCloudType;
import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadApplicationAction
extends AnAction {
    public static final String LAST_RUN_CONFIGURATION_PROPERTY = "JAVA_APP_ENGINE_LAST_RUN_CONFIGURATION";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            UploadApplicationAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && ProjectFacetManager.getInstance((Project)project).hasFacets(AppEngineFacet.ID));
        if (project != null) {
            RunnerAndConfigurationSettings configurationToRun = UploadApplicationAction.getConfigurationToRun(project);
            String text = configurationToRun == null ? this.getTemplatePresentation().getText() : "Upload App Engine Application '" + configurationToRun.getName() + "'";
            e.getPresentation().setText(text);
        }
    }

    @Nullable
    private static RunnerAndConfigurationSettings getConfigurationToRun(@NotNull Project project) {
        if (project == null) {
            UploadApplicationAction.$$$reportNull$$$0(1);
        }
        List configurations = DeploymentConfigurationManager.getInstance((Project)project).getDeploymentConfigurations((ServerType)AppEngineCloudType.getInstance());
        String lastName = PropertiesComponent.getInstance((Project)project).getValue(LAST_RUN_CONFIGURATION_PROPERTY);
        if (lastName != null) {
            for (RunnerAndConfigurationSettings configuration : configurations) {
                if (!configuration.getName().equals(lastName)) continue;
                return configuration;
            }
        }
        return (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem((List)configurations);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        RunnerAndConfigurationSettings configurationToRun;
        if (e == null) {
            UploadApplicationAction.$$$reportNull$$$0(2);
        }
        if ((configurationToRun = UploadApplicationAction.getConfigurationToRun(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT))) != null) {
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)configurationToRun, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        } else {
            AppEngineCloudType serverType = AppEngineCloudType.getInstance();
            List servers = RemoteServersManager.getInstance().getServers((ServerType)serverType);
            DeploymentConfigurationManager.getInstance((Project)project).createAndRunConfiguration((ServerType)serverType, (RemoteServer)ContainerUtil.getFirstItem((List)servers), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/appengine/actions/UploadApplicationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurationToRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

