/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationRunDashboardChecker
implements StartupActivity {
    private static final NotificationGroup DASHBOARD_NOTIFICATION_GROUP = new NotificationGroup("Run Dashboard", NotificationDisplayType.STICKY_BALLOON, false);
    private static final String SHOW_RUN_DASHBOARD_NOTIFICATION = "show.run.dashboard.notification";
    private final Object myLock = new Object();
    private Notification myNotification;

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            SpringBootApplicationRunDashboardChecker.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        boolean converted = SpringBootApplicationRunDashboardChecker.convertDeprecateSetting(project);
        if (!PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_RUN_DASHBOARD_NOTIFICATION, true)) {
            return;
        }
        project.getMessageBus().connect((Disposable)project).subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!PropertiesComponent.getInstance((Project)project).getBoolean(SpringBootApplicationRunDashboardChecker.SHOW_RUN_DASHBOARD_NOTIFICATION, true)) {
                    return;
                }
                if (settings.getType().equals(SpringBootApplicationConfigurationTypeBase.getInstance())) {
                    DumbService.getInstance((Project)project).runWhenSmart(() -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        SpringBootApplicationRunDashboardChecker.this.checkRunDashboardAvailability(project);
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$runConfigurationAdded$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!converted) {
            this.checkRunDashboardAvailability(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRunDashboardAvailability(@NotNull Project project) {
        List settings;
        if (project == null) {
            SpringBootApplicationRunDashboardChecker.$$$reportNull$$$0(1);
        }
        if ((settings = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance())).size() <= 1) {
            return;
        }
        if (RunDashboardManager.getInstance((Project)project).getTypes().contains(SpringBootApplicationConfigurationTypeBase.getInstance().getId())) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myNotification != null && !this.myNotification.isExpired()) {
                return;
            }
            this.myNotification = DASHBOARD_NOTIFICATION_GROUP.createNotification("Run Dashboard", "<html><body>Multiple Spring Boot run configurations were detected.<br>Run Dashboard allows to manage multiple run configurations at once.<br><br><a href=\"show\">Show run configurations in Run Dashboard</a><br><br><a href=\"ignore\">Do not show again for this project</a></body></html>", NotificationType.INFORMATION, (notification, event) -> {
                if (project == null) {
                    SpringBootApplicationRunDashboardChecker.$$$reportNull$$$0(5);
                }
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String description = event.getDescription();
                if ("ignore".equals(description)) {
                    PropertiesComponent.getInstance((Project)project).setValue(SHOW_RUN_DASHBOARD_NOTIFICATION, false, true);
                    notification.expire();
                } else if ("show".equals(description)) {
                    notification.hideBalloon();
                    DumbService.getInstance((Project)project).runWhenSmart(() -> {
                        if (project == null) {
                            SpringBootApplicationRunDashboardChecker.$$$reportNull$$$0(6);
                        }
                        SpringBootApplicationRunDashboardChecker.showInRunDashboard(project);
                    });
                }
            });
            this.myNotification.notify(project);
        }
    }

    private static void showInRunDashboard(@NotNull Project project) {
        if (project == null) {
            SpringBootApplicationRunDashboardChecker.$$$reportNull$$$0(2);
        }
        RunDashboardManager dashboardManager = RunDashboardManager.getInstance((Project)project);
        HashSet types = ContainerUtil.newHashSet((Iterable)dashboardManager.getTypes());
        types.add(SpringBootApplicationConfigurationTypeBase.getInstance().getId());
        dashboardManager.setTypes((Set)types);
    }

    private static boolean convertDeprecateSetting(@NotNull Project project) {
        if (project == null) {
            SpringBootApplicationRunDashboardChecker.$$$reportNull$$$0(3);
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        ConfigurationFactory defaultFactory = SpringBootApplicationConfigurationTypeBase.getInstance().getDefaultConfigurationFactory();
        SpringBootApplicationRunConfiguration templateConfiguration = (SpringBootApplicationRunConfiguration)runManager.getConfigurationTemplate(defaultFactory).getConfiguration();
        List settings = runManager.getConfigurationSettingsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
        if (settings.stream().anyMatch(configurationSettings -> ((SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration()).isShowInDashboard())) {
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                if (project == null) {
                    SpringBootApplicationRunDashboardChecker.$$$reportNull$$$0(4);
                }
                templateConfiguration.setShowInDashboard(false);
                settings.forEach(configurationSettings -> ((SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration()).setShowInDashboard(false));
                SpringBootApplicationRunDashboardChecker.showInRunDashboard(project);
            });
            return true;
        }
        if (templateConfiguration.isShowInDashboard()) {
            DumbService.getInstance((Project)project).runWhenSmart(() -> templateConfiguration.setShowInDashboard(false));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRunDashboardAvailability";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showInRunDashboard";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "convertDeprecateSetting";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$convertDeprecateSetting$4";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkRunDashboardAvailability$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

