/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.application.ApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManagerImpl;
import com.intellij.spring.boot.run.update.TriggerFilePolicy;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

class SpringBootCommandLineState
extends ApplicationCommandLineState<SpringBootApplicationRunConfiguration> {
    static final String DEBUG_PARAMETER = "-Ddebug";
    static final String TIERED_STOP_AT_LEVEL_1_PARAMETER = "-XX:TieredStopAtLevel=1";
    static final String NO_VERIFY_PARAMETER = "-noverify";
    static final String HIDE_BANNER_PARAMETER = "-Dspring.main.show_banner=false";
    static final String HIDE_BANNER_PARAMETER_1_5 = "-Dspring.main.banner-mode=OFF";
    static final String ACTIVE_PROFILES_PARAMETER = "-Dspring.profiles.active";
    static final String TRIGGER_FILE_PARAMETER = "-Dspring.devtools.restart.trigger-file";
    static final String OUTPUT_ANSI_ENABLED_PARAMETER = "-Dspring.output.ansi.enabled=always";
    static final String JMX_REMOTE_PARAMETER = "-Dcom.sun.management.jmxremote";
    static final String LIVE_BEAN_PARAMETER = "-Dspring.liveBeansView.mbeanDomain";
    static final String LIFECYCLE_PARAMETER = "-Dspring.application.admin.enabled=true";
    private static final String JMX_REMOTE_PORT_PARAMETER = "com.sun.management.jmxremote.port";
    private static final String JMX_REMOTE_AUTH_PARAMETER = "com.sun.management.jmxremote.authenticate";
    private static final String JMX_REMOTE_SSL_PARAMETER = "com.sun.management.jmxremote.ssl";
    private boolean myJmxEnabled;
    private int myJmxPort;

    SpringBootCommandLineState(@NotNull SpringBootApplicationRunConfiguration configuration, ExecutionEnvironment environment) {
        if (configuration == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(0);
        }
        super((ModuleBasedConfiguration)configuration, environment);
        this.myJmxEnabled = false;
        this.myJmxPort = -1;
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters params = super.createJavaParameters();
        this.applySpringBootSettings(params);
        this.createJmxParameters(params);
        return params;
    }

    protected boolean isProvidedScopeIncluded() {
        return ((SpringBootApplicationRunConfiguration)this.myConfiguration).isIncludeProvidedScope();
    }

    private void applySpringBootSettings(JavaParameters params) {
        ParametersList vmParametersList = params.getVMParametersList();
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isDebugMode()) {
            vmParametersList.add(DEBUG_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isEnableLaunchOptimization()) {
            vmParametersList.add(TIERED_STOP_AT_LEVEL_1_PARAMETER);
            vmParametersList.add(NO_VERIFY_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isHideBanner()) {
            if (SpringBootLibraryUtil.isAtLeastVersion((Module)((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0)) {
                vmParametersList.add(HIDE_BANNER_PARAMETER_1_5);
            } else {
                vmParametersList.add(HIDE_BANNER_PARAMETER);
            }
        }
        if (StringUtil.isNotEmpty((String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles())) {
            vmParametersList.add("-Dspring.profiles.active=" + ((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles());
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).getUpdateActionUpdatePolicy() instanceof TriggerFilePolicy) {
            vmParametersList.add("-Dspring.devtools.restart.trigger-file=.restartTriggerFile");
        }
        vmParametersList.add(OUTPUT_ANSI_ENABLED_PARAMETER);
        for (SpringBootAdditionalParameter parameter : ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAdditionalParameters()) {
            if (!parameter.isEnabled()) continue;
            String parameterValue = parameter.getValue();
            if (StringUtil.isNotEmpty((String)parameterValue)) {
                vmParametersList.add("-D" + parameter.getName() + "=" + parameterValue);
                continue;
            }
            vmParametersList.add("-D" + parameter.getName());
        }
    }

    private void createJmxParameters(JavaParameters params) {
        if (!((SpringBootApplicationRunConfiguration)this.myConfiguration).isEnableJmxAgent()) {
            return;
        }
        if (SpringBootLibraryUtil.isBelowVersion((Module)((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            return;
        }
        ParametersList vmParametersList = params.getVMParametersList();
        vmParametersList.add(JMX_REMOTE_PARAMETER);
        this.myJmxEnabled = true;
        vmParametersList.add(LIVE_BEAN_PARAMETER);
        vmParametersList.add(LIFECYCLE_PARAMETER);
        String auth = vmParametersList.getPropertyValue(JMX_REMOTE_AUTH_PARAMETER);
        if (!"false".equalsIgnoreCase(auth)) {
            return;
        }
        String ssl = vmParametersList.getPropertyValue(JMX_REMOTE_SSL_PARAMETER);
        if (!"false".equalsIgnoreCase(ssl)) {
            return;
        }
        String jmxPort = vmParametersList.getPropertyValue(JMX_REMOTE_PORT_PARAMETER);
        if (jmxPort != null) {
            try {
                this.myJmxPort = Integer.parseInt(jmxPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(2);
        }
        ExecutionResult result = super.execute(executor, runner);
        if (this.myJmxEnabled) {
            result.getProcessHandler().putUserData(SpringBootApplicationLifecycleManagerImpl.JMX_ENABLED, (Object)Boolean.TRUE);
            if (this.myJmxPort > 0) {
                result.getProcessHandler().putUserData(SpringBootApplicationLifecycleManager.JMX_PORT, (Object)this.myJmxPort);
            }
            SpringBootApplicationLifecycleManager.getInstance((Project)((SpringBootApplicationRunConfiguration)this.getConfiguration()).getProject());
        }
        ExecutionResult executionResult = result;
        if (executionResult == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(3);
        }
        return executionResult;
    }

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        AnAction action;
        Object[] actions = super.createActions(console, processHandler, executor);
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).getUpdateActionUpdatePolicy() != null && (action = ActionManager.getInstance().getAction("UpdateRunningApplication")) != null) {
            AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])actions, (Object)action);
            if (anActionArray == null) {
                SpringBootCommandLineState.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }
        if (actions == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(5);
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/SpringBootCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/SpringBootCommandLineState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

