/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.editor.SpringBootAdditionalParamsTableView;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.UIUtil;
import icons.SpringApiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootSettingsPanel
extends JPanel
implements PanelWithAnchor {
    private JPanel myRootPanel;
    private JComponent myAnchor;
    private JBCheckBox myEnableDebugOutput;
    private JBCheckBox myEnableLaunchOptimization;
    private JBCheckBox myHideBanner;
    private JBCheckBox myEnableJmxAgent;
    private JPanel myAdditionalParametersPanel;
    private LabeledComponent<TextFieldWithAutoCompletion<String>> myActiveProfiles;
    private JLabel myDevToolsMessage;
    private LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> myUpdateActionPolicy;
    private ContextHelpLabel myUpdateActionHelpLabel;
    private LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> myFrameDeactivationPolicy;
    private ContextHelpLabel myFrameDeactivationHelpLabel;
    private JPanel myUpdatePoliciesPanel;
    private JBLabel myAdditionalParametersLabel;
    private SpringBootAdditionalParamsTableView myAdditionalParamsTable;
    private final Project myProject;
    private Module myModule;

    public SpringBootSettingsPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.initAdditionalParamsTable();
        if (Registry.is((String)"compiler.automake.allow.when.app.running")) {
            this.myDevToolsMessage.setIcon(AllIcons.General.BalloonError);
            this.myDevToolsMessage.setText("Background compilation enabled");
        }
        UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myUpdateActionPolicy, this.myFrameDeactivationPolicy});
        this.myUpdatePoliciesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Running Application Update Policies", (boolean)true));
    }

    private void initAdditionalParamsTable() {
        this.myAdditionalParamsTable = new SpringBootAdditionalParamsTableView(this.myProject);
        this.myAdditionalParametersPanel.add((Component)ToolbarDecorator.createDecorator((JTable)((Object)this.myAdditionalParamsTable)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SpringBootSettingsPanel.this.myAdditionalParamsTable.addAdditionalParameter();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)((Object)SpringBootSettingsPanel.this.myAdditionalParamsTable));
            }
        }).createPanel(), "Center");
        this.myAdditionalParametersLabel.setLabelFor((Component)((Object)this.myAdditionalParamsTable));
    }

    void resetEditorFrom(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            SpringBootSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myEnableDebugOutput.setSelected(configuration.isDebugMode());
        this.myEnableLaunchOptimization.setSelected(configuration.isEnableLaunchOptimization());
        this.myHideBanner.setSelected(configuration.isHideBanner());
        this.myEnableJmxAgent.setSelected(configuration.isEnableJmxAgent());
        ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).setText(configuration.getActiveProfiles());
        ((ComboBox)this.myUpdateActionPolicy.getComponent()).setSelectedItem((Object)configuration.getUpdateActionUpdatePolicy());
        ((ComboBox)this.myFrameDeactivationPolicy.getComponent()).setSelectedItem((Object)configuration.getFrameDeactivationUpdatePolicy());
        this.myAdditionalParamsTable.setAdditionalParameters(configuration.getAdditionalParameters());
    }

    void applyEditorTo(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            SpringBootSettingsPanel.$$$reportNull$$$0(1);
        }
        configuration.setDebugMode(this.myEnableDebugOutput.isSelected());
        configuration.setEnableLaunchOptimization(this.myEnableLaunchOptimization.isSelected());
        configuration.setHideBanner(this.myHideBanner.isSelected());
        configuration.setEnableJmxAgent(this.myEnableJmxAgent.isSelected());
        configuration.setActiveProfiles(((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).getText());
        configuration.setUpdateActionUpdatePolicy((SpringBootApplicationUpdatePolicy)((ComboBox)this.myUpdateActionPolicy.getComponent()).getSelectedItem());
        configuration.setFrameDeactivationUpdatePolicy((SpringBootApplicationUpdatePolicy)((ComboBox)this.myFrameDeactivationPolicy.getComponent()).getSelectedItem());
        configuration.setAdditionalParameters(this.myAdditionalParamsTable.getAdditionalParameters());
    }

    JComponent getComponent() {
        return this.myRootPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myActiveProfiles.setAnchor(anchor);
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myAdditionalParamsTable.setModule(module);
        this.myEnableJmxAgent.setEnabled(this.myModule == null || SpringBootLibraryUtil.isAtLeastVersion((Module)this.myModule, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0));
    }

    private void createUIComponents() {
        TextFieldWithAutoCompletion field = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new ProfileCompletionProvider(), true, "");
        this.myActiveProfiles = LabeledComponent.create((JComponent)field, (String)"Active Profiles");
        ComboBox updateActionComboBox = new ComboBox();
        SpringBootSettingsPanel.initUpdatePolicyComboBox((ComboBox<SpringBootApplicationUpdatePolicy>)updateActionComboBox, false);
        this.myUpdateActionPolicy = LabeledComponent.create((JComponent)updateActionComboBox, (String)"On 'Update' action");
        this.myUpdateActionHelpLabel = ContextHelpLabel.create((String)SpringBootSettingsPanel.getHelpLabelDescription((ComboBox<SpringBootApplicationUpdatePolicy>)updateActionComboBox));
        ComboBox frameDeactivationComboBox = new ComboBox();
        SpringBootSettingsPanel.initUpdatePolicyComboBox((ComboBox<SpringBootApplicationUpdatePolicy>)frameDeactivationComboBox, true);
        this.myFrameDeactivationPolicy = LabeledComponent.create((JComponent)frameDeactivationComboBox, (String)"On frame deactivation");
        this.myFrameDeactivationHelpLabel = ContextHelpLabel.create((String)SpringBootSettingsPanel.getHelpLabelDescription((ComboBox<SpringBootApplicationUpdatePolicy>)frameDeactivationComboBox));
    }

    private static void initUpdatePolicyComboBox(ComboBox<SpringBootApplicationUpdatePolicy> comboBox, boolean onFrameDeactivation) {
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<SpringBootApplicationUpdatePolicy>(){

            public void customize(JList list, SpringBootApplicationUpdatePolicy value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.setText("Do nothing");
                } else {
                    this.setText(UIUtil.removeMnemonic((String)value.getName()));
                }
            }
        });
        comboBox.addItem(null);
        List policies = SpringBootApplicationUpdatePolicy.getAvailablePolicies((boolean)onFrameDeactivation);
        for (SpringBootApplicationUpdatePolicy policy : policies) {
            comboBox.addItem((Object)policy);
        }
        if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    private static String getHelpLabelDescription(ComboBox<SpringBootApplicationUpdatePolicy> updateActionComboBox) {
        StringBuilder description = new StringBuilder();
        for (int i = 0; i < updateActionComboBox.getItemCount(); ++i) {
            SpringBootApplicationUpdatePolicy policy = (SpringBootApplicationUpdatePolicy)updateActionComboBox.getItemAt(i);
            if (policy == null) continue;
            description.append("<p><b>").append(policy.getName()).append("</b><br>").append(policy.getDescription()).append("</p>");
        }
        return description.toString();
    }

    private static List<String> getProfiles(Module module) {
        SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        ArrayList<String> allProfileNames = new ArrayList<String>(SpringModelVisitorUtils.getProfiles((CommonSpringModel)model));
        allProfileNames.remove("_DEFAULT_PROFILE_NAME_");
        Collections.sort(allProfileNames);
        return allProfileNames;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "configuration";
        objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootSettingsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JLabel jLabel;
        JPanel jPanel2;
        JBCheckBox jBCheckBox4;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableDebugOutput = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Enable debug output");
        jBCheckBox4.setMnemonic('D');
        jBCheckBox4.setDisplayedMnemonicIndex(7);
        jBCheckBox4.setToolTipText("<html>Enables debug output by adding VM option <code>-Ddebug</code></html>");
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAdditionalParametersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 6, 0, 3, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithAutoCompletion<String>> labeledComponent = this.myActiveProfiles;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Active profiles");
        jPanel3.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 6, 0, 1, 3, 3, null, null, null));
        this.myDevToolsMessage = jLabel = new JLabel();
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnableLaunchOptimization = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Enable launch optimization");
        jBCheckBox3.setMnemonic('Z');
        jBCheckBox3.setDisplayedMnemonicIndex(20);
        jBCheckBox3.setToolTipText("<html>Adds VM options <code>-XX:TieredStopAtLevel=1</code> and <code>-noverify</code> to speed up startup.<br>Please verify these options do not have adverse impact on your specific project.</html>");
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myHideBanner = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Hide banner");
        jBCheckBox2.setMnemonic('H');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jBCheckBox2.setToolTipText("<html>Hides banner by adding VM option <code>-Dspring.main.banner-mode=OFF</code><br>(<code>-Dspring.main.show-banner=false</code> for Spring Boot 1.4.x or earlier)</html>");
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnableJmxAgent = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Enable JMX agent");
        jBCheckBox.setMnemonic('X');
        jBCheckBox.setDisplayedMnemonicIndex(9);
        jBCheckBox.setToolTipText("<html>Enables JMX agent to show application endpoints data by adding VM options <code><br>-Dcom.sun.management.jmxremote <br>-Dspring.liveBeansView.mbeanDomain <br>-Dspring.application.admin.enabled=true</code><p>Requires Spring Boot 1.3.0 or higher.</html>");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUpdatePoliciesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 1));
        LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> labeledComponent2 = this.myUpdateActionPolicy;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("On '&Update' action");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> labeledComponent3 = this.myFrameDeactivationPolicy;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText("On &frame deactivation");
        jPanel.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        ContextHelpLabel contextHelpLabel = this.myUpdateActionHelpLabel;
        jPanel.add((Component)contextHelpLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        ContextHelpLabel contextHelpLabel2 = this.myFrameDeactivationHelpLabel;
        jPanel.add((Component)contextHelpLabel2, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myAdditionalParametersLabel = jBLabel = new JBLabel();
        jBLabel.setText("Override parameters:");
        jBLabel.setDisplayedMnemonic('P');
        jBLabel.setDisplayedMnemonicIndex(9);
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class ProfileCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<String> {
        private final Map<Module, List<String>> myProfiles;

        ProfileCompletionProvider() {
            super(null);
            this.myProfiles = FactoryMap.create(x$0 -> SpringBootSettingsPanel.getProfiles(x$0));
        }

        @NotNull
        protected String getLookupString(@NotNull String item) {
            if (item == null) {
                ProfileCompletionProvider.$$$reportNull$$$0(0);
            }
            String string = item;
            if (string == null) {
                ProfileCompletionProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected Icon getIcon(@NotNull String item) {
            if (item == null) {
                ProfileCompletionProvider.$$$reportNull$$$0(2);
            }
            return SpringApiIcons.SpringProfile;
        }

        @NotNull
        public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            if (prefix == null || SpringBootSettingsPanel.this.myModule == null) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    ProfileCompletionProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
            Collection collection = this.myProfiles.get(SpringBootSettingsPanel.this.myModule);
            if (collection == null) {
                ProfileCompletionProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/run/editor/SpringBootSettingsPanel$ProfileCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootSettingsPanel$ProfileCompletionProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

