/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.model.impl;

import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveContextImpl
implements LiveContext {
    @NotNull
    private final String myName;
    private LiveContext myParent;
    private final List<LiveResource> myResources;

    LiveContextImpl(@NotNull String name) {
        if (name == null) {
            LiveContextImpl.$$$reportNull$$$0(0);
        }
        this.myResources = new ArrayList<LiveResource>();
        this.myName = name;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LiveContextImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public LiveContext getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public List<LiveResource> getResources() {
        ArrayList<LiveResource> arrayList = new ArrayList<LiveResource>(this.myResources);
        if (arrayList == null) {
            LiveContextImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<LiveBean> getBeans() {
        List<LiveBean> list = this.myResources.stream().flatMap(resource -> resource.getBeans().stream()).collect(Collectors.toList());
        if (list == null) {
            LiveContextImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    void setParent(@Nullable LiveContext parent) {
        this.myParent = parent;
    }

    void addResources(@NotNull Collection<? extends LiveResource> resources) {
        if (resources == null) {
            LiveContextImpl.$$$reportNull$$$0(4);
        }
        this.myResources.addAll(resources);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiveContextImpl)) {
            return false;
        }
        LiveContextImpl liveContext = (LiveContextImpl)obj;
        if (!this.myName.equals(liveContext.myName)) {
            return false;
        }
        if (this.myParent == null || liveContext.myParent == null) {
            return this.myParent == liveContext.myParent;
        }
        return this.myParent.getName().equals(liveContext.myParent.getName());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + (this.myParent != null ? this.myParent.getName().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveContextImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveContextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

