/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.model.impl;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveResourceImpl
implements LiveResource {
    static final String AUTO_CONFIGURATION_RESOURCE = "null";
    private static final String AUTO_CONFIGURATION_RESOURCE_NAME = "Auto Configuration";
    private static final String CLASS_PATH_RESOURCE_DESCRIPTION = "class path resource";
    private static final String FILE_RESOURCE_DESCRIPTION = "file";
    private static final String URL_RESOURCE_DESCRIPTION = "URL";
    private static final String CLASS_DOT_EXTENSION = ".class";
    private static final String XML_DOT_EXTENSION = ".xml";
    @NotNull
    private final String myDescription;
    @NotNull
    private final LiveContext myContext;
    @NotNull
    private final List<LiveBean> myBeans;
    private volatile String myDisplayName;
    private volatile WeakReference<Navigatable> myNavigatableRef;

    LiveResourceImpl(@NotNull String description, @NotNull LiveContext context) {
        if (description == null) {
            LiveResourceImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            LiveResourceImpl.$$$reportNull$$$0(1);
        }
        this.myBeans = ContainerUtil.newSmartList();
        this.myDescription = description;
        this.myContext = context;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            LiveResourceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public LiveContext getContext() {
        LiveContext liveContext = this.myContext;
        if (liveContext == null) {
            LiveResourceImpl.$$$reportNull$$$0(3);
        }
        return liveContext;
    }

    @Override
    @NotNull
    public List<LiveBean> getBeans() {
        List beans = ContainerUtil.newSmartList();
        beans.addAll(this.myBeans);
        List list = beans;
        if (list == null) {
            LiveResourceImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public boolean hasDescription() {
        return !this.myDescription.isEmpty() && !this.myDescription.equalsIgnoreCase(AUTO_CONFIGURATION_RESOURCE);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String displayName = this.myDisplayName;
        if (displayName != null) {
            String string = displayName;
            if (string == null) {
                LiveResourceImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (!this.hasDescription()) {
            String string = this.myDisplayName = AUTO_CONFIGURATION_RESOURCE_NAME;
            if (string == null) {
                LiveResourceImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        displayName = this.myDescription;
        int indexStart = displayName.lastIndexOf("/");
        int indexEnd = displayName.lastIndexOf("]");
        if (indexStart > -1 && indexEnd > -1 && indexStart < indexEnd) {
            displayName = displayName.substring(indexStart + 1, indexEnd);
        }
        if (LiveResourceImpl.isXmlResource(displayName)) {
            String string = this.myDisplayName = displayName;
            if (string == null) {
                LiveResourceImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        int index = (displayName = StringUtil.trimEnd((String)displayName, (String)CLASS_DOT_EXTENSION)).lastIndexOf(".");
        if (index > -1) {
            displayName = displayName.substring(index + 1);
        }
        String[] names = displayName.split("\\$");
        StringBuilder sb = new StringBuilder();
        sb.append(names[names.length - 1]);
        for (int i = names.length - 2; i >= 0; --i) {
            sb.append(" in ");
            sb.append(names[i]);
        }
        String string = this.myDisplayName = sb.toString();
        if (string == null) {
            LiveResourceImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public Navigatable findResourceNavigatable(@NotNull Project project, @Nullable Module module, @Nullable PsiElement runConfigurationElement, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            LiveResourceImpl.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            LiveResourceImpl.$$$reportNull$$$0(10);
        }
        if (!this.hasDescription()) {
            return null;
        }
        Object navigatable = this.getCachedValue();
        if (navigatable != null) {
            return navigatable;
        }
        if (LiveResourceImpl.isClassNameResource(this.myDescription)) {
            navigatable = LiveResourceImpl.findClass(this.myDescription, project, searchScope);
        } else {
            String path = this.getResourcePath();
            navigatable = this.myDescription.startsWith(CLASS_PATH_RESOURCE_DESCRIPTION) ? LiveResourceImpl.getClassPathResource(path, project, module, runConfigurationElement, searchScope) : (this.myDescription.startsWith(FILE_RESOURCE_DESCRIPTION) ? LiveResourceImpl.getFileResource(path, project, searchScope) : (this.myDescription.startsWith(URL_RESOURCE_DESCRIPTION) ? new UrlNavigatable(path) : null));
        }
        this.myNavigatableRef = new WeakReference<Navigatable>((Navigatable)navigatable);
        return navigatable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private Navigatable getCachedValue() {
        Navigatable navigatable = (Navigatable)SoftReference.dereference(this.myNavigatableRef);
        if (navigatable == null) return null;
        if (!(navigatable instanceof PsiElement)) return navigatable;
        if (!((PsiElement)navigatable).isValid()) return null;
        if (navigatable instanceof PsiClass) {
            if (!this.matchesClass((PsiClass)navigatable, false)) return null;
            return navigatable;
        }
        if (!(navigatable instanceof XmlFile)) return navigatable;
        if (!this.matchesXmlConfig((XmlFile)navigatable)) return null;
        return navigatable;
    }

    @Override
    @Nullable
    public PsiElement findResourceElement(@NotNull Project project, @Nullable Module module, @Nullable PsiElement runConfigurationElement, @NotNull GlobalSearchScope searchScope) {
        Navigatable navigatable;
        if (project == null) {
            LiveResourceImpl.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            LiveResourceImpl.$$$reportNull$$$0(12);
        }
        return (navigatable = this.findResourceNavigatable(project, module, runConfigurationElement, searchScope)) instanceof PsiElement ? (PsiElement)navigatable : null;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        if (!this.hasDescription()) {
            return SpringApiIcons.SpringJavaConfig;
        }
        if (LiveResourceImpl.isClassNameResource(this.myDescription)) {
            return AllIcons.Nodes.Class;
        }
        String path = this.getResourcePath();
        if (this.myDescription.startsWith(CLASS_PATH_RESOURCE_DESCRIPTION) || this.myDescription.startsWith(FILE_RESOURCE_DESCRIPTION)) {
            if (LiveResourceImpl.isClassResource(path)) {
                return AllIcons.Nodes.Class;
            }
            if (LiveResourceImpl.isXmlResource(path)) {
                return SpringApiIcons.SpringConfig;
            }
        } else if (this.myDescription.startsWith(URL_RESOURCE_DESCRIPTION)) {
            return AllIcons.Javaee.Web_xml;
        }
        return null;
    }

    @Override
    @NotNull
    public String getResourcePath() {
        String resource = this.myDescription;
        int start = resource.indexOf("[");
        int end = resource.indexOf("]");
        if (start > -1 && end > -1 && start < end) {
            resource = resource.substring(start + 1, end);
        }
        String string = resource;
        if (string == null) {
            LiveResourceImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public boolean matchesClass(@NotNull PsiClass psiClass, boolean strict) {
        if (psiClass == null) {
            LiveResourceImpl.$$$reportNull$$$0(14);
        }
        if (!this.hasDescription()) {
            return false;
        }
        String className = null;
        if (LiveResourceImpl.isClassNameResource(this.myDescription)) {
            className = this.myDescription;
        } else {
            String path = this.getResourcePath();
            if (!LiveResourceImpl.isClassResource(path) || this.myDescription.startsWith(URL_RESOURCE_DESCRIPTION)) {
                return false;
            }
            if (this.myDescription.startsWith(CLASS_PATH_RESOURCE_DESCRIPTION)) {
                path = StringUtil.trimEnd((String)path, (String)CLASS_DOT_EXTENSION, (boolean)true);
                className = path = path.replaceAll("[\\\\/$]", ".");
            } else if (this.myDescription.startsWith(FILE_RESOURCE_DESCRIPTION)) {
                VirtualFile resourceFile;
                String innerClassesSuffix = null;
                int index = path.indexOf(36);
                if (index >= 0) {
                    innerClassesSuffix = StringUtil.trimEnd((String)path.substring(index + 1), (String)CLASS_DOT_EXTENSION, (boolean)true);
                    path = path.substring(0, index) + path.substring(path.length() - CLASS_DOT_EXTENSION.length());
                }
                if ((resourceFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false)) == null || !resourceFile.isValid()) {
                    return false;
                }
                PsiFile psiFile = psiClass.getManager().findFile(resourceFile);
                if (psiFile instanceof PsiClassOwner) {
                    className = ((PsiClassOwner)psiFile).getPackageName() + "." + FileUtil.getNameWithoutExtension((String)psiFile.getName());
                }
                if (className != null && innerClassesSuffix != null) {
                    className = className + "." + StringUtil.replace((String)innerClassesSuffix, (String)"$", (String)".");
                }
            }
        }
        if (className == null) {
            return false;
        }
        if (className.equals(psiClass.getQualifiedName())) {
            return true;
        }
        if (strict) {
            return false;
        }
        PsiClass resourceClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(className, psiClass.getResolveScope());
        return InheritanceUtil.isInheritorOrSelf((PsiClass)resourceClass, (PsiClass)psiClass, (boolean)true);
    }

    @Override
    public boolean matchesXmlConfig(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            LiveResourceImpl.$$$reportNull$$$0(15);
        }
        if (!this.hasDescription()) {
            return false;
        }
        if (LiveResourceImpl.isClassNameResource(this.myDescription) || this.myDescription.startsWith(URL_RESOURCE_DESCRIPTION)) {
            return false;
        }
        String path = this.getResourcePath();
        if (LiveResourceImpl.isClassResource(path)) {
            return false;
        }
        VirtualFile elementFile = xmlFile.getOriginalFile().getVirtualFile();
        if (elementFile == null) {
            return false;
        }
        if (this.myDescription.startsWith(FILE_RESOURCE_DESCRIPTION)) {
            VirtualFile resourceFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
            if (resourceFile == null || !resourceFile.isValid()) {
                return false;
            }
            return resourceFile.equals(elementFile);
        }
        if (this.myDescription.startsWith(CLASS_PATH_RESOURCE_DESCRIPTION)) {
            String elementPath = elementFile.getPath();
            return PathUtil.toSystemIndependentName((String)elementPath).endsWith(PathUtil.toSystemIndependentName((String)path));
        }
        return false;
    }

    void addBean(@NotNull LiveBean bean) {
        if (bean == null) {
            LiveResourceImpl.$$$reportNull$$$0(16);
        }
        this.myBeans.add(bean);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveResourceImpl) {
            LiveResourceImpl liveResource = (LiveResourceImpl)obj;
            return this.myDescription.equals(liveResource.myDescription) && this.myContext.equals(liveResource.myContext);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myDescription.hashCode();
        result = 31 * result + this.myContext.hashCode();
        return result;
    }

    public String toString() {
        return this.myDescription;
    }

    static boolean isClassNameResource(String resourceDescription) {
        return resourceDescription.indexOf(91) < 0;
    }

    static boolean isXmlResource(String path) {
        return StringUtil.endsWithIgnoreCase((String)path, (String)XML_DOT_EXTENSION);
    }

    static boolean isClassResource(String path) {
        return StringUtil.endsWithIgnoreCase((String)path, (String)CLASS_DOT_EXTENSION);
    }

    static PsiClass findClass(@NotNull String className, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        PsiClass psiClass;
        if (className == null) {
            LiveResourceImpl.$$$reportNull$$$0(17);
        }
        if (project == null) {
            LiveResourceImpl.$$$reportNull$$$0(18);
        }
        if (searchScope == null) {
            LiveResourceImpl.$$$reportNull$$$0(19);
        }
        String innerClassesSuffix = null;
        int index = className.indexOf(36);
        if (index >= 0) {
            innerClassesSuffix = className.substring(index + 1);
            className = className.substring(0, index);
        }
        if ((psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)className, (GlobalSearchScope)searchScope)) == null || innerClassesSuffix == null) {
            return psiClass;
        }
        return LiveResourceImpl.findInnerClass(psiClass, innerClassesSuffix);
    }

    private static PsiClass findInnerClass(@NotNull PsiClass parent, @NotNull String innerClassesSuffix) {
        String[] innerClasses;
        if (parent == null) {
            LiveResourceImpl.$$$reportNull$$$0(20);
        }
        if (innerClassesSuffix == null) {
            LiveResourceImpl.$$$reportNull$$$0(21);
        }
        block2: for (String innerClassName : innerClasses = innerClassesSuffix.split("\\$")) {
            if (innerClassName.isEmpty()) {
                return parent;
            }
            if (StringUtil.isDecimalDigit((char)innerClassName.charAt(0))) {
                try {
                    int classIndex = Integer.parseInt(innerClassName) - 1;
                    for (AnonymousElementProvider provider : AnonymousElementProvider.EP_NAME.getExtensionList()) {
                        PsiElement[] elements = provider.getAnonymousElements((PsiElement)parent);
                        if (classIndex >= elements.length) continue;
                        PsiElement anonymousElement = elements[classIndex];
                        if (!(anonymousElement instanceof PsiClass)) {
                            return parent;
                        }
                        parent = (PsiClass)anonymousElement;
                        continue block2;
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    return parent;
                }
            }
            PsiClass innerClass = parent.findInnerClassByName(innerClassName, false);
            if (innerClass == null) {
                return parent;
            }
            parent = innerClass;
        }
        return parent;
    }

    private static NavigatablePsiElement getClassPathResource(@NotNull String path, @NotNull Project project, @Nullable Module module, @Nullable PsiElement runConfigurationElement, @NotNull GlobalSearchScope searchScope) {
        PsiElement element;
        PsiReference reference;
        if (path == null) {
            LiveResourceImpl.$$$reportNull$$$0(22);
        }
        if (project == null) {
            LiveResourceImpl.$$$reportNull$$$0(23);
        }
        if (searchScope == null) {
            LiveResourceImpl.$$$reportNull$$$0(24);
        }
        if (LiveResourceImpl.isClassResource(path)) {
            path = StringUtil.trimEnd((String)path, (String)CLASS_DOT_EXTENSION, (boolean)true);
            path = path.replaceAll("[\\\\/]", ".");
            return LiveResourceImpl.findClass(path, project, searchScope);
        }
        if (module == null || runConfigurationElement == null) {
            return null;
        }
        PsiReference[] references = new FilePathReferenceProvider().getReferencesByElement(runConfigurationElement, path, 0, true, new Module[]{module});
        if (references.length > 0 && (reference = references[references.length - 1]) != null && (element = reference.resolve()) != null) {
            return element.getContainingFile();
        }
        return null;
    }

    private static NavigatablePsiElement getFileResource(@NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        VirtualFile resourceFile;
        int index;
        if (path == null) {
            LiveResourceImpl.$$$reportNull$$$0(25);
        }
        if (project == null) {
            LiveResourceImpl.$$$reportNull$$$0(26);
        }
        if (searchScope == null) {
            LiveResourceImpl.$$$reportNull$$$0(27);
        }
        String innerClassesSuffix = null;
        if (LiveResourceImpl.isClassResource(path) && (index = path.indexOf(36)) >= 0) {
            innerClassesSuffix = StringUtil.trimEnd((String)path.substring(index + 1), (String)CLASS_DOT_EXTENSION, (boolean)true);
            path = path.substring(0, index) + path.substring(path.length() - CLASS_DOT_EXTENSION.length());
        }
        if ((resourceFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false)) != null && resourceFile.isValid()) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(resourceFile);
            if (psiFile instanceof PsiClassOwner) {
                String className = ((PsiClassOwner)psiFile).getPackageName() + "." + FileUtil.getNameWithoutExtension((String)psiFile.getName());
                PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)className, (GlobalSearchScope)searchScope);
                if (psiClass != null && innerClassesSuffix != null) {
                    psiClass = LiveResourceImpl.findInnerClass(psiClass, innerClassesSuffix);
                }
                if (psiClass != null) {
                    return psiClass;
                }
            }
            return psiFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveResourceImpl";
                break;
            }
            case 9: 
            case 11: 
            case 18: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 12: 
            case 19: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClassesSuffix";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveResourceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeans";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findResourceNavigatable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findResourceElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchesClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matchesXmlConfig";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addBean";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findInnerClass";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getClassPathResource";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFileResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UrlNavigatable
    implements Navigatable {
        @NotNull
        private final String myUrl;

        UrlNavigatable(@NotNull String url) {
            if (url == null) {
                UrlNavigatable.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
        }

        public void navigate(boolean requestFocus) {
            BrowserUtil.browse((String)this.myUrl);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UrlNavigatable) {
                return this.myUrl.equals(((UrlNavigatable)obj).myUrl);
            }
            return false;
        }

        public int hashCode() {
            return this.myUrl.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveResourceImpl$UrlNavigatable", "<init>"));
        }
    }
}

