/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.beans.tab.BeansEndpointTabSettings;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveBeansPanelContent;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootRunFeatureUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        if ("statistics.spring.boot.run" == null) {
            SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(0);
        }
        return "statistics.spring.boot.run";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(1);
        }
        HashSet<UsageDescriptor> usages = new HashSet<UsageDescriptor>();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(3);
            }
            if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
                return;
            }
            List runnerAndConfigurationSettings = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
            usages.add(new UsageDescriptor("configs.count_" + runnerAndConfigurationSettings.size()));
            HashMap<String, Integer> mainClassCounter = new HashMap<String, Integer>();
            for (RunnerAndConfigurationSettings settings : runnerAndConfigurationSettings) {
                RunConfiguration configuration = settings.getConfiguration();
                if (!(configuration instanceof SpringBootApplicationRunConfiguration)) continue;
                SpringBootApplicationRunConfiguration sbRunConfig = (SpringBootApplicationRunConfiguration)configuration;
                mainClassCounter.merge(sbRunConfig.getSpringBootMainClass(), 1, (integer, integer2) -> integer + 1);
                SpringBootRunFeatureUsagesCollector.recordRunConfigBoolean(usages, "active.profiles.set", StringUtil.isNotEmpty((String)sbRunConfig.getActiveProfiles()));
                SpringBootRunFeatureUsagesCollector.recordRunConfigBoolean(usages, "hide.banner", sbRunConfig.isHideBanner());
                SpringBootRunFeatureUsagesCollector.recordRunConfigBoolean(usages, "debug.mode", sbRunConfig.isDebugMode());
                SpringBootRunFeatureUsagesCollector.recordRunConfigBoolean(usages, "enable.launch.optimization", sbRunConfig.isEnableLaunchOptimization());
                SpringBootRunFeatureUsagesCollector.recordRunConfigBoolean(usages, "enable.jmx.agent", sbRunConfig.isEnableJmxAgent());
                usages.add(new UsageDescriptor("config.update.action.update.policy." + SpringBootRunFeatureUsagesCollector.getUpdatePolicyDescriptor(sbRunConfig.getUpdateActionUpdatePolicy())));
                usages.add(new UsageDescriptor("config.frame.deactivation.update.policy." + SpringBootRunFeatureUsagesCollector.getUpdatePolicyDescriptor(sbRunConfig.getFrameDeactivationUpdatePolicy())));
                List<SpringBootAdditionalParameter> parameters = sbRunConfig.getAdditionalParameters();
                int additionalParamsSize = parameters.size();
                usages.add(new UsageDescriptor("config.additional.params.total_" + additionalParamsSize));
                if (additionalParamsSize > 0) {
                    long enabledParams = parameters.stream().filter(SpringBootAdditionalParameter::isEnabled).count();
                    usages.add(new UsageDescriptor("config.additional.params.enabled_" + enabledParams));
                    usages.add(new UsageDescriptor("config.additional.params.disabled_" + ((long)additionalParamsSize - enabledParams)));
                }
                SpringBootRunFeatureUsagesCollector.recordRunConfigBoolean(usages, "include.provided.scope", sbRunConfig.isIncludeProvidedScope());
            }
            boolean showRunDashboard = RunDashboardManager.getInstance((Project)project).getTypes().contains(SpringBootApplicationConfigurationTypeBase.getInstance().getId());
            usages.add(new UsageDescriptor("run.dashboard." + (showRunDashboard ? "on" : "off")));
            for (Integer integer3 : mainClassCounter.values()) {
                usages.add(new UsageDescriptor("configs.main.class.count_" + integer3));
            }
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"endpoints.beans.diagram", (((LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()).length != 0 && BeansEndpointTabSettings.getInstance(project).isDiagramMode() ? 1 : 0) != 0));
        });
        HashSet<UsageDescriptor> hashSet = usages;
        if (hashSet == null) {
            SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static void recordRunConfigBoolean(Set<UsageDescriptor> usages, String name, boolean value) {
        String key = "config." + name + "." + (value ? "on" : "off");
        usages.add(new UsageDescriptor(key));
    }

    private static String getUpdatePolicyDescriptor(@Nullable SpringBootApplicationUpdatePolicy policy) {
        return policy == null ? "Nothing" : policy.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/statistics/SpringBootRunFeatureUsagesCollector";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/statistics/SpringBootRunFeatureUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getUsages$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

