/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view;

import com.intellij.ide.DeleteProvider;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.actionSystem.DataContext;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JamDeleteProvider
implements DeleteProvider {
    private final Collection<CommonModelElement> myElements;
    private final JamUserResponse myResponse;

    public JamDeleteProvider(Collection<? extends JamDeleteProvider> providers) {
        this.myElements = new THashSet();
        JamUserResponse response = JamUserResponse.QUIET;
        for (JamDeleteProvider jamDeleteProvider : providers) {
            this.myElements.addAll(jamDeleteProvider.myElements);
            response = jamDeleteProvider.myResponse;
        }
        this.myResponse = response;
    }

    public JamDeleteProvider(JamUserResponse response, Collection<CommonModelElement> elements) {
        this.myElements = elements;
        this.myResponse = response;
    }

    public JamDeleteProvider(CommonModelElement element, JamUserResponse response) {
        this(response, Collections.singletonList(element));
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JamDeleteProvider.$$$reportNull$$$0(0);
        }
        CommonModelManager.getInstance().deleteModelElements(this.myElements, this.myResponse);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JamDeleteProvider.$$$reportNull$$$0(1);
        }
        for (CommonModelElement element : this.myElements) {
            if (element == null || element.isValid()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/jam/view/JamDeleteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

