/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.util.xml.GenericValue;

public abstract class ReadOnlyGenericValue<T>
implements GenericValue<T> {
    public static GenericValue<?> NULL = ReadOnlyGenericValue.getInstance(null);

    public static <T> GenericValue<T> nullInstance() {
        return NULL;
    }

    public static <T> GenericValue<T> getInstance(final T value) {
        return new ReadOnlyGenericValue<T>(){

            @Override
            public T getValue() {
                return value;
            }
        };
    }

    public static <T> GenericValue<T> getInstance(final T value, final String stringValue) {
        return new ReadOnlyGenericValue<T>(){

            @Override
            public String getStringValue() {
                return stringValue;
            }

            @Override
            public T getValue() {
                return value;
            }
        };
    }

    public final void setStringValue(String value) {
        throw new UnsupportedOperationException("Model is read-only");
    }

    @Override
    public String getStringValue() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof PsiClass) {
            return ((PsiClass)value).getQualifiedName();
        }
        if (value instanceof PsiPackage) {
            return ((PsiPackage)value).getQualifiedName();
        }
        if (value instanceof PsiNamedElement) {
            return ((PsiNamedElement)value).getName();
        }
        return value.toString();
    }

    public final void setValue(T value) {
        throw new UnsupportedOperationException("Model is read-only");
    }

    public String toString() {
        return this.getStringValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Object value1 = ((ReadOnlyGenericValue)o).getValue();
        Object value = this.getValue();
        if (value != null ? !value.equals(value1) : value1 != null) {
            return false;
        }
        String str1 = ((ReadOnlyGenericValue)o).getStringValue();
        String str = this.getStringValue();
        return !(str != null ? !str.equals(str1) : str1 != null);
    }

    public int hashCode() {
        Object value = this.getValue();
        if (value != null) {
            return value.hashCode();
        }
        String str = this.getStringValue();
        return str != null ? str.hashCode() : 0;
    }
}

