/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.NamedDomModel;
import com.intellij.struts.StrutsDomFactory;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.WebDomFactory;
import com.intellij.struts.dom.PlugIn;
import com.intellij.struts.dom.SetProperty;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StrutsPluginDomFactory<T extends DomElement, M extends NamedDomModel<T>>
extends WebDomFactory<T, M> {
    private final String mySuperClass;
    private final String myConfigProperty;
    protected final StrutsDomFactory myStrutsFactory;

    protected StrutsPluginDomFactory(@NotNull Class<T> aClass, @NotNull String superClass, @NotNull String configProperty, @NotNull StrutsDomFactory strutsFactory, Project project, @NonNls String name) {
        if (aClass == null) {
            StrutsPluginDomFactory.$$$reportNull$$$0(0);
        }
        if (superClass == null) {
            StrutsPluginDomFactory.$$$reportNull$$$0(1);
        }
        if (configProperty == null) {
            StrutsPluginDomFactory.$$$reportNull$$$0(2);
        }
        if (strutsFactory == null) {
            StrutsPluginDomFactory.$$$reportNull$$$0(3);
        }
        super(aClass, project, name);
        this.myStrutsFactory = strutsFactory;
        this.mySuperClass = superClass;
        this.myConfigProperty = configProperty;
    }

    @Nullable
    private PlugIn getPlugin(@NotNull StrutsModel struts) {
        if (struts == null) {
            StrutsPluginDomFactory.$$$reportNull$$$0(4);
        }
        PsiClass superClass = null;
        for (PlugIn plugin : ((StrutsConfig)struts.getMergedModel()).getPlugIns()) {
            PsiClass pluginClass = (PsiClass)plugin.getClassName().getValue();
            if (pluginClass == null) continue;
            if (superClass == null && (superClass = JavaPsiFacade.getInstance((Project)pluginClass.getProject()).findClass(this.mySuperClass, pluginClass.getResolveScope())) == null) {
                return null;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)pluginClass, superClass, (boolean)true)) continue;
            return plugin;
        }
        return null;
    }

    @Nullable
    public List<M> computeAllModels(@NotNull Module module) {
        List strutsModels;
        if (module == null) {
            StrutsPluginDomFactory.$$$reportNull$$$0(5);
        }
        if ((strutsModels = this.myStrutsFactory.getAllModels((UserDataHolder)module)).size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<M> list = new ArrayList<M>(strutsModels.size());
        for (StrutsModel strutsModel : strutsModels) {
            M model = this.getModelFromStruts(strutsModel);
            if (model == null) continue;
            list.add(model);
        }
        return list;
    }

    @Nullable
    protected M getModelFromStruts(@NotNull StrutsModel strutsModel) {
        PlugIn plugin;
        if (strutsModel == null) {
            StrutsPluginDomFactory.$$$reportNull$$$0(6);
        }
        if ((plugin = this.getPlugin(strutsModel)) != null) {
            LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
            XmlTag element = plugin.getXmlTag();
            assert (element != null);
            WebFacet webFacet = WebUtil.getWebFacet((PsiElement)element);
            if (webFacet == null) {
                return null;
            }
            WebDirectoryUtil webDirectoryUtil = WebDirectoryUtil.getWebDirectoryUtil((Project)plugin.getManager().getProject());
            for (SetProperty prop : plugin.getSetProperties()) {
                String[] configPaths;
                String configString;
                String name = prop.getProperty().getStringValue();
                if (!this.myConfigProperty.equals(name) || (configString = prop.getValue().getStringValue()) == null) continue;
                for (String configPath : configPaths = configString.split(",")) {
                    PsiElement psiElement = this.resolveFile(configPath, webDirectoryUtil, webFacet);
                    if (!(psiElement instanceof XmlFile)) continue;
                    configFiles.add((XmlFile)psiElement);
                }
            }
            if (configFiles.size() > 0) {
                DomFileElement mergedModel = this.createMergedModelRoot(configFiles);
                return mergedModel == null ? null : (M)this.createModel(configFiles, mergedModel, strutsModel);
            }
        }
        return null;
    }

    protected abstract M createModel(@NotNull Set<XmlFile> var1, @NotNull DomFileElement<T> var2, StrutsModel var3);

    @Nullable
    protected PsiElement resolveFile(String path, WebDirectoryUtil webDirectoryUtil, WebFacet webFacet) {
        return webDirectoryUtil.findFileByPath(path.trim(), webFacet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configProperty";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strutsFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strutsModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/struts/StrutsPluginDomFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPlugin";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAllModels";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelFromStruts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

