/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.jsf.composite.CompositeComponentDescriptor;
import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeComponentQuickFixProvider {
    @NonNls
    public static final String COMPOSITE_COMPONENT_TEMPLATE_NAME = "composite_component.xhtml";
    private static final String INTERFACE_NAME_VAR = "INTERFACE_NAME";
    private static final String ATTRIBUTES_VAR = "ATTRIBUTES";

    private CompositeComponentQuickFixProvider() {
    }

    @Nullable
    public static LocalQuickFix createCompositeComponentFileQuickFix(@NotNull XmlTag tag, String resourcesPath) {
        PsiFile psiFile;
        if (tag == null) {
            CompositeComponentQuickFixProvider.$$$reportNull$$$0(0);
        }
        if ((psiFile = tag.getContainingFile()) == null) {
            return null;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)tag);
        if (module == null) {
            return null;
        }
        PsiDirectory directory = CompositeComponentQuickFixProvider.getDirectory(module, resourcesPath);
        if (directory != null) {
            final String newFileName = tag.getLocalName() + ".xhtml";
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ATTRIBUTES_VAR, CompositeComponentQuickFixProvider.getAttributes(tag));
            String text = CompositeComponentQuickFixProvider.getCompositeText(map, directory.getProject());
            if (text == null) {
                return null;
            }
            try {
                directory.checkCreateFile(newFileName);
            }
            catch (IncorrectOperationException e) {
                return null;
            }
            return new CreateFileFix(false, newFileName, directory, text, "Create Composite Component File"){

                @NotNull
                public String getText() {
                    String string = FacesBundle.message("create.composite.component.file", newFileName);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = FacesBundle.message("composite.component.quick.fixes", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/jsf/composite/CompositeComponentQuickFixProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
        return null;
    }

    @Nullable
    static String getCompositeText(Map<String, Object> props, Project project) {
        try {
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(COMPOSITE_COMPONENT_TEMPLATE_NAME);
            Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object key : properties.keySet()) {
                String s = (String)key;
                hashMap.put(s, properties.getProperty(s));
            }
            hashMap.putAll(props);
            return template.getText(hashMap);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static ArrayList<String> getAttributes(XmlTag tag) {
        ArrayList<String> strings = new ArrayList<String>();
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            strings.add(xmlAttribute.getLocalName());
        }
        return strings;
    }

    private static PsiDirectory getDirectory(Module module, String resourcesPath) {
        Set<PsiDirectory> directories = JsfCommonUtils.collectDirectories(module, resourcesPath);
        for (PsiDirectory directory : directories) {
            if (!directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    public static IntentionAction createCompositeComponentAttributeQuickFix(final XmlAttribute attribute, String resourcesPath) {
        XmlTag interfaceTag;
        PsiElement psiElement;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlTag.class, (boolean)false);
        if (tag == null) {
            return null;
        }
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor instanceof CompositeComponentDescriptor && (psiElement = descriptor.getDeclaration()) instanceof XmlFile && (interfaceTag = CompositeUtil.findInterfaceTag((XmlFile)psiElement)) != null) {
            return new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = FacesBundle.message("create.composite.component.attribute", attribute.getLocalName());
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = FacesBundle.message("composite.component.quick.fixes", new Object[0]);
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return true;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    XmlTag childTag = interfaceTag.createChildTag(CompositeUtil.ATTRIBUTE_TAG_NAME, interfaceTag.getNamespace(), null, false);
                    childTag.setAttribute("name", attribute.getLocalName());
                    childTag.setAttribute("required", "true");
                    childTag.setAttribute("targets", "");
                    interfaceTag.add((PsiElement)childTag);
                    CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
                }

                public boolean startInWriteAction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/jsf/composite/CompositeComponentQuickFixProvider$2";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/jsf/composite/CompositeComponentQuickFixProvider$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isAvailable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "invoke";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/jsf/composite/CompositeComponentQuickFixProvider", "createCompositeComponentFileQuickFix"));
    }
}

