/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.el.contibutors;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.el.ELVariableProcessingContext;
import com.intellij.jsf.el.contibutors.JsfElVariablesContributor;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.CustomJsfVariableResolverProvider;
import com.intellij.psi.util.CachedValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomVariableResolversContributor
extends JsfElVariablesContributor {
    private static final Key<CachedValue<List<PsiVariable>>> CUSTOM_RESOLVERS_VARS = Key.create((String)"custom resolvers el vars");

    @Override
    @NotNull
    public List<PsiVariable> getVariables(ELVariableProcessingContext context) {
        ArrayList<PsiVariable> vars = new ArrayList<PsiVariable>();
        List<String> variableResolverClasses = CustomVariableResolversContributor.getCustomVariableResolverClasses(context);
        if (variableResolverClasses.size() > 0) {
            List providers = CustomJsfVariableResolverProvider.EP_NAME.getExtensionList();
            for (String resolverClass : variableResolverClasses) {
                for (CustomJsfVariableResolverProvider provider : providers) {
                    if (!provider.acceptVariableResolver(resolverClass, context.getModule())) continue;
                    provider.addVars(vars, context.getModule());
                }
            }
        }
        ArrayList<PsiVariable> arrayList = vars;
        if (arrayList == null) {
            CustomVariableResolversContributor.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    public Key<CachedValue<List<PsiVariable>>> getKey() {
        return CUSTOM_RESOLVERS_VARS;
    }

    private static List<String> getCustomVariableResolverClasses(ELVariableProcessingContext context) {
        ArrayList<String> classes = new ArrayList<String>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)context.getModule())) {
            List<FacesDomModel> models = FacesDomModelManager.getInstance(context.getProject()).getAllModels(webFacet);
            for (FacesDomModel facesDomModel : models) {
                CustomVariableResolversContributor.addNotNull(classes, facesDomModel.getFacesConfig().getApplication().getVariableResolver().getStringValue());
                CustomVariableResolversContributor.addNotNull(classes, facesDomModel.getFacesConfig().getApplication().getElResolver().getStringValue());
            }
        }
        return classes;
    }

    private static void addNotNull(@NotNull List<String> classes, @Nullable String aClass) {
        if (classes == null) {
            CustomVariableResolversContributor.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmptyOrSpaces((String)aClass)) {
            classes.add(aClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/el/contibutors/CustomVariableResolversContributor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/el/contibutors/CustomVariableResolversContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

