/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.flows;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.flows.beans.AnnotatedFlowDefinitionRenameable;
import com.intellij.jsf.flows.beans.AnnotatedNodeDefinition;
import com.intellij.jsf.flows.beans.AnnotatedNodeDefinitionRenameable;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.flows.FlowDefinition;
import com.intellij.jsf.model.xml.flows.FlowNode;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowsCommonUtils {
    public static final String PRODUCES_ANNOTATION = "javax.enterprise.inject.Produces";
    public static final Key<FakePsiElement> FLOW_FAKE_PSI_ELEMENT_KEY = Key.create((String)"FLOW_FAKE_PSI_ELEMENT_KEY");
    public static final Key<FakePsiElement> NODE_FAKE_PSI_ELEMENT_KEY = Key.create((String)"FLOW_NODE_FAKE_PSI_ELEMENT_KEY");
    private static final Collection EXCLUDE_FLOWS = Arrays.asList("WEB-INF", "resources");
    public static final String[] VIEW_CREATE_METHODS = new String[]{"viewNode", "switchNode", "returnNode", "flowCallNode", "methodCallNode"};

    @Nullable
    public static Pair<PsiElement, String> findFlowDefinitionByName(@NotNull Module module, @NotNull String value) {
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(0);
        }
        if (value == null) {
            FlowsCommonUtils.$$$reportNull$$$0(1);
        }
        Ref resolve = Ref.create(null);
        FlowsCommonUtils.processAllFlows((Processor<? super Pair<PsiElement, String>>)((Processor)pair -> {
            if (value == null) {
                FlowsCommonUtils.$$$reportNull$$$0(37);
            }
            if (value.equals(pair.second)) {
                resolve.set(pair);
                return false;
            }
            return true;
        }), module);
        return (Pair)resolve.get();
    }

    public static boolean processAllFlows(@NotNull Processor<? super Pair<PsiElement, String>> processor, @NotNull Module module) {
        if (processor == null) {
            FlowsCommonUtils.$$$reportNull$$$0(2);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(3);
        }
        if (!FlowsCommonUtils.processAnnotatedFlowDefinitions(processor, module)) {
            return false;
        }
        if (!FlowsCommonUtils.processDirectoryFlowDefinitions(processor, module)) {
            return false;
        }
        return FlowsCommonUtils.processFacesConfigFlowDefinitions(processor, module);
    }

    public static boolean processAnnotatedFlowDefinitions(@NotNull Processor<? super Pair<PsiElement, String>> processor, @NotNull Module module) {
        if (processor == null) {
            FlowsCommonUtils.$$$reportNull$$$0(4);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(5);
        }
        Set<PsiMethod> producers = FlowsCommonUtils.getFlowDefinitionProducers(module);
        for (PsiMethod producer : producers) {
            for (Pair<PsiElement, String> flow : FlowsCommonUtils.getFlowIds(producer, module)) {
                if (processor.process(flow)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDirectoryFlowDefinitions(@NotNull Processor<? super Pair<PsiElement, String>> processor, @NotNull Module module) {
        if (processor == null) {
            FlowsCommonUtils.$$$reportNull$$$0(6);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(7);
        }
        for (PsiDirectory psiDirectory : FlowsCommonUtils.getFlowsDirectories(module)) {
            FlowDefinition definition = FlowsCommonUtils.getExplicitFlowDefinition(psiDirectory);
            if (!(definition != null ? !FlowsCommonUtils.processFlowDefinition(processor, definition) : !processor.process((Object)Pair.create((Object)psiDirectory, (Object)psiDirectory.getName())))) continue;
            return false;
        }
        return true;
    }

    public static boolean processFacesConfigFlowDefinitions(@NotNull Processor<? super Pair<PsiElement, String>> processor, @NotNull Module module) {
        if (processor == null) {
            FlowsCommonUtils.$$$reportNull$$$0(8);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(9);
        }
        for (FacesDomModel facesDomModel : JsfCommonUtils.getAllFacesModels(module)) {
            for (FlowDefinition flowDefinition : facesDomModel.getFacesConfig().getFlowDefinitions()) {
                if (FlowsCommonUtils.processFlowDefinition(processor, flowDefinition)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processFlowDefinition(@NotNull Processor<? super Pair<PsiElement, String>> processor, @NotNull FlowDefinition definition) {
        if (processor == null) {
            FlowsCommonUtils.$$$reportNull$$$0(10);
        }
        if (definition == null) {
            FlowsCommonUtils.$$$reportNull$$$0(11);
        }
        XmlElement element = definition.getXmlElement();
        String value = definition.getId().getStringValue();
        return element == null || StringUtil.isEmptyOrSpaces((String)value) || processor.process((Object)Pair.create((Object)element, (Object)value));
    }

    @NotNull
    public static Set<PsiMethod> getFlowDefinitionProducers(@NotNull Module module) {
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(12);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiClass annoClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(PRODUCES_ANNOTATION, searchScope);
        if (annoClass == null) {
            Set<PsiMethod> set = Collections.emptySet();
            if (set == null) {
                FlowsCommonUtils.$$$reportNull$$$0(13);
            }
            return set;
        }
        final HashSet flowDefinitionProduces = ContainerUtil.newHashSet();
        AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)searchScope).forEach((Processor)new CommonProcessors.CollectProcessor<PsiMember>(){

            protected boolean accept(PsiMember member) {
                if (member instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)"javax.faces.flow.builder.FlowDefinition", (int)0)) {
                    PsiMethod psiMethod = (PsiMethod)member;
                    for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                        PsiType parameterType;
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javax.faces.flow.builder.FlowBuilderParameter", (int)0) || !((parameterType = parameter.getType()) instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiType)parameterType, (String)"javax.faces.flow.builder.FlowBuilder")) continue;
                        flowDefinitionProduces.add((PsiMethod)member);
                    }
                }
                return super.accept((Object)member);
            }
        });
        HashSet hashSet = flowDefinitionProduces;
        if (hashSet == null) {
            FlowsCommonUtils.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    public static Set<Pair<PsiElement, String>> getViewIds(@NotNull PsiMethod produceMethod, @NotNull Module module) {
        if (produceMethod == null) {
            FlowsCommonUtils.$$$reportNull$$$0(15);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(16);
        }
        HashSet<Pair<PsiElement, String>> pairs = new HashSet<Pair<PsiElement, String>>();
        PsiClass flowBuilderClass = JavaPsiFacade.getInstance((Project)produceMethod.getProject()).findClass("javax.faces.flow.builder.FlowBuilder", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (flowBuilderClass != null) {
            LocalSearchScope scope = new LocalSearchScope((PsiElement)produceMethod);
            for (String viewCreateMethodName : VIEW_CREATE_METHODS) {
                for (PsiMethod method : flowBuilderClass.findMethodsByName(viewCreateMethodName, true)) {
                    pairs.addAll(StringExpressionHelper.searchStringExpressions((PsiMethod)method, (SearchScope)scope, (int)0));
                }
            }
        }
        return pairs;
    }

    public static Set<Pair<PsiElement, String>> getFlowIds(@NotNull PsiMethod produceMethod, @NotNull Module module) {
        PsiMethod[] flowIdMethods;
        PsiClass flowBuilderClass;
        if (produceMethod == null) {
            FlowsCommonUtils.$$$reportNull$$$0(17);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(18);
        }
        if ((flowBuilderClass = JavaPsiFacade.getInstance((Project)produceMethod.getProject()).findClass("javax.faces.flow.builder.FlowBuilder", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null && (flowIdMethods = flowBuilderClass.findMethodsByName("id", true)).length == 1) {
            return StringExpressionHelper.searchStringExpressions((PsiMethod)flowIdMethods[0], (SearchScope)new LocalSearchScope((PsiElement)produceMethod), (int)1);
        }
        return Collections.emptySet();
    }

    public static FakePsiElement getOrCreateNodeFakeElement(@NotNull Pair<PsiElement, String> definition) {
        PsiElement psiElement;
        Object data;
        if (definition == null) {
            FlowsCommonUtils.$$$reportNull$$$0(19);
        }
        if ((data = (FakePsiElement)(psiElement = (PsiElement)definition.first).getUserData(NODE_FAKE_PSI_ELEMENT_KEY)) == null) {
            data = psiElement instanceof PsiLiteralExpression ? new AnnotatedNodeDefinitionRenameable((PsiLiteralExpression)psiElement) : new AnnotatedNodeDefinition(psiElement, (String)definition.second);
            psiElement.putUserData(NODE_FAKE_PSI_ELEMENT_KEY, data);
        }
        return data;
    }

    public static FakePsiElement getOrCreateFlowFakeElement(@NotNull PsiLiteralExpression expression) {
        Object data;
        if (expression == null) {
            FlowsCommonUtils.$$$reportNull$$$0(20);
        }
        if ((data = (FakePsiElement)expression.getUserData(FLOW_FAKE_PSI_ELEMENT_KEY)) == null) {
            data = new AnnotatedFlowDefinitionRenameable(expression);
            expression.putUserData(FLOW_FAKE_PSI_ELEMENT_KEY, data);
        }
        return data;
    }

    public static FakePsiElement getOrCreateNodeFakeElement(@NotNull PsiLiteralExpression expression) {
        Object data;
        if (expression == null) {
            FlowsCommonUtils.$$$reportNull$$$0(21);
        }
        if ((data = (FakePsiElement)expression.getUserData(NODE_FAKE_PSI_ELEMENT_KEY)) == null) {
            data = new AnnotatedNodeDefinitionRenameable(expression);
            expression.putUserData(NODE_FAKE_PSI_ELEMENT_KEY, data);
        }
        return data;
    }

    @NotNull
    public static List<FlowNode> getFlowNodes(@NotNull FlowDefinition flow) {
        if (flow == null) {
            FlowsCommonUtils.$$$reportNull$$$0(22);
        }
        List list = DomUtil.getChildrenOfType((DomElement)flow, FlowNode.class);
        if (list == null) {
            FlowsCommonUtils.$$$reportNull$$$0(23);
        }
        return list;
    }

    public static boolean isFlowDirectoryCandidate(@NotNull VirtualFile file) {
        if (file == null) {
            FlowsCommonUtils.$$$reportNull$$$0(24);
        }
        return !EXCLUDE_FLOWS.contains(file.getName());
    }

    @NotNull
    public static Set<PsiDirectory> getFlowsDirectories(@NotNull Module module) {
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(25);
        }
        HashSet<PsiDirectory> directories = new HashSet<PsiDirectory>();
        FlowsCommonUtils.collectWebAppTopLevelFlowsDirectories(directories, module);
        FlowsCommonUtils.collectMetaInfFlowsDirectories(directories, module);
        HashSet<PsiDirectory> hashSet = directories;
        if (hashSet == null) {
            FlowsCommonUtils.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    private static void collectWebAppTopLevelFlowsDirectories(@NotNull Set<? super PsiDirectory> dirs, @NotNull Module module) {
        if (dirs == null) {
            FlowsCommonUtils.$$$reportNull$$$0(27);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(28);
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        for (WebFacet webFacet : webFacets) {
            List roots = webFacet.getWebRoots();
            for (WebRoot root : roots) {
                VirtualFile file = root.getFile();
                if (file == null || !file.isDirectory()) continue;
                for (VirtualFile virtualFile : file.getChildren()) {
                    PsiDirectory directory;
                    if (!virtualFile.isDirectory() || !FlowsCommonUtils.isFlowDirectoryCandidate(virtualFile) || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(virtualFile)) == null) continue;
                    dirs.add((PsiDirectory)directory);
                }
            }
        }
    }

    public static void collectMetaInfFlowsDirectories(@NotNull Set<? super PsiDirectory> dirs, @NotNull Module module) {
        if (dirs == null) {
            FlowsCommonUtils.$$$reportNull$$$0(29);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(30);
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            VirtualFile flows;
            VirtualFile metaInf = root.findChild("META-INF");
            if (metaInf == null || (flows = metaInf.findChild("flows")) == null) continue;
            for (VirtualFile flowsDir : flows.getChildren()) {
                PsiDirectory directory;
                if (!flowsDir.isDirectory() || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(flowsDir)) == null) continue;
                dirs.add((PsiDirectory)directory);
            }
        }
    }

    @Nullable
    public static FlowNode findFlowNode(@NotNull String nodeId, @NotNull PsiFile file, @NotNull Module module) {
        FlowNode flowNode;
        if (nodeId == null) {
            FlowsCommonUtils.$$$reportNull$$$0(31);
        }
        if (file == null) {
            FlowsCommonUtils.$$$reportNull$$$0(32);
        }
        if (module == null) {
            FlowsCommonUtils.$$$reportNull$$$0(33);
        }
        if ((flowNode = FlowsCommonUtils.findNodeById(nodeId, FlowsCommonUtils.getFlowByFile(file))) != null) {
            return flowNode;
        }
        for (FacesDomModel facesDomModel : JsfCommonUtils.getAllFacesModels(module)) {
            for (FlowDefinition flowDefinition : facesDomModel.getFacesConfig().getFlowDefinitions()) {
                flowNode = FlowsCommonUtils.findNodeById(nodeId, flowDefinition);
                if (flowNode == null) continue;
                return flowNode;
            }
        }
        return null;
    }

    @Nullable
    private static FlowNode findNodeById(@NotNull String flowId, @Nullable FlowDefinition flow) {
        if (flowId == null) {
            FlowsCommonUtils.$$$reportNull$$$0(34);
        }
        if (flow == null || !DomUtil.hasXml((DomElement)flow)) {
            return null;
        }
        for (FlowNode flowNode : FlowsCommonUtils.getFlowNodes(flow)) {
            if (!flowId.equals(flowNode.getId().getStringValue())) continue;
            return flowNode;
        }
        return null;
    }

    @Nullable
    public static FlowDefinition getFlowByFile(@NotNull PsiFile file) {
        PsiDirectory directory;
        if (file == null) {
            FlowsCommonUtils.$$$reportNull$$$0(35);
        }
        if ((directory = file.getContainingDirectory()) != null) {
            return FlowsCommonUtils.getExplicitFlowDefinition(directory);
        }
        return null;
    }

    @Nullable
    public static FlowDefinition getExplicitFlowDefinition(@NotNull PsiDirectory directory) {
        DomFileElement facesConfigDomFileElement;
        PsiFile flowConfig;
        if (directory == null) {
            FlowsCommonUtils.$$$reportNull$$$0(36);
        }
        if ((flowConfig = directory.findFile(directory.getName() + "-flow.xml")) instanceof XmlFile && (facesConfigDomFileElement = DomManager.getDomManager((Project)flowConfig.getProject()).getFileElement((XmlFile)flowConfig, FacesConfig.class)) != null) {
            for (FlowDefinition flowDefinition : ((FacesConfig)facesConfigDomFileElement.getRootElement()).getFlowDefinitions()) {
                if (!DomUtil.hasXml((DomElement)flowDefinition)) continue;
                return flowDefinition;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 13: 
            case 14: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/flows/FlowsCommonUtils";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "produceMethod";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 24: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowId";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/flows/FlowsCommonUtils";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowDefinitionProducers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowNodes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowsDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFlowDefinitionByName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAllFlows";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAnnotatedFlowDefinitions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDirectoryFlowDefinitions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processFacesConfigFlowDefinitions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processFlowDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFlowDefinitionProducers";
                break;
            }
            case 13: 
            case 14: 
            case 23: 
            case 26: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getViewIds";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFlowIds";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateNodeFakeElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFlowFakeElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFlowNodes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isFlowDirectoryCandidate";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFlowsDirectories";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectWebAppTopLevelFlowsDirectories";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectMetaInfFlowsDirectories";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findFlowNode";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findNodeById";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFlowByFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitFlowDefinition";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFlowDefinitionByName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

