/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.jsf.toolWindow.tree.nodes.FacesModelNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelNodeUtils;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModuleNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfNodeTypes;
import com.intellij.jsf.toolWindow.tree.nodes.WebFacetNode;
import com.intellij.jsf.utils.FacesConfigUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJsfTypeNode
extends SimpleNode {
    private final Module myModule;
    private final JsfNodeTypes myType;
    private final boolean myShowFromLibraries;

    protected AbstractJsfTypeNode(JsfModuleNode jsfModuleNode, @NotNull Module module, @NotNull JsfNodeTypes type, boolean showFromLibraries) {
        if (module == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(0);
        }
        if (type == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(1);
        }
        super((SimpleNode)jsfModuleNode);
        this.myModule = module;
        this.myType = type;
        this.myShowFromLibraries = showFromLibraries;
    }

    public Module getModule() {
        return this.myModule;
    }

    public JsfNodeTypes getType() {
        return this.myType;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myType, this.myShowFromLibraries};
        if (objectArray == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @NotNull
    public final SimpleNode[] getChildren() {
        SimpleNode[] simpleNodeArray = (SimpleNode[])DumbService.getInstance((Project)this.getModule().getProject()).runReadActionInSmartMode(() -> {
            ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
            Collection<JsfModelElementNode> annotatedNodes = JsfModelNodeUtils.createSortedList();
            this.addFacesConfigsNodes(nodes);
            this.addAnnotatedNodes(annotatedNodes);
            nodes.addAll(annotatedNodes);
            return nodes.toArray(new SimpleNode[0]);
        });
        if (simpleNodeArray == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(3);
        }
        return simpleNodeArray;
    }

    private void addFacesConfigsNodes(List<SimpleNode> nodes) {
        Collection webFacets = WebFacet.getInstances((Module)this.getModule());
        if (webFacets.size() == 1) {
            nodes.addAll(this.getWebFacetsNodes((WebFacet)webFacets.iterator().next()));
        } else {
            for (WebFacet webFacet : webFacets) {
                final Collection<SimpleNode> webFacetNodes = this.getWebFacetsNodes(webFacet);
                if (webFacetNodes.size() <= 0) continue;
                nodes.add(new WebFacetNode(webFacet, this){

                    @Override
                    @NotNull
                    public SimpleNode[] getChildren() {
                        SimpleNode[] simpleNodeArray = webFacetNodes.toArray(new SimpleNode[0]);
                        if (simpleNodeArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return simpleNodeArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode$1", "getChildren"));
                    }
                });
            }
        }
    }

    @NotNull
    private Collection<SimpleNode> getWebFacetsNodes(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(4);
        }
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        List<FacesDomModel> models = this.getFacesDomModels(webFacet);
        if (models.size() == 1) {
            nodes.addAll(this.getFacesDomModelNodes(models.get(0)));
        } else {
            for (FacesDomModel model : models) {
                final Collection<SimpleNode> modelNodes = this.getFacesDomModelNodes(model);
                if (modelNodes.size() <= 0) continue;
                nodes.add(new FacesModelNode(webFacet.getModule().getProject(), model, this){

                    @Override
                    @NotNull
                    public SimpleNode[] getChildren() {
                        SimpleNode[] simpleNodeArray = modelNodes.toArray(new SimpleNode[0]);
                        if (simpleNodeArray == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return simpleNodeArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode$2", "getChildren"));
                    }
                });
            }
        }
        ArrayList<SimpleNode> arrayList = nodes;
        if (arrayList == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private List<FacesDomModel> getFacesDomModels(WebFacet webFacet) {
        if (this.isShowFromLibraries()) {
            List<FacesDomModel> list = FacesDomModelManager.getInstance(this.getModule().getProject()).getAllModels(webFacet);
            if (list == null) {
                AbstractJsfTypeNode.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<FacesDomModel> models = new ArrayList<FacesDomModel>();
        AbstractJsfTypeNode.addNotNullModel(webFacet, models, FacesConfigUtils.getFacesConfigsFromWebInf(webFacet));
        for (XmlFile xmlFile : FacesConfigUtils.getFacesConfigDefinedInWebXml(webFacet)) {
            AbstractJsfTypeNode.addNotNullModel(webFacet, models, xmlFile);
        }
        ArrayList<FacesDomModel> arrayList = models;
        if (arrayList == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void addNotNullModel(@NotNull WebFacet webFacet, @NotNull List<FacesDomModel> models, @Nullable XmlFile xmlFile) {
        FacesDomModel domModel;
        if (webFacet == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(8);
        }
        if (models == null) {
            AbstractJsfTypeNode.$$$reportNull$$$0(9);
        }
        if (xmlFile != null && (domModel = FacesDomModelManager.getInstance(webFacet.getModule().getProject()).getFacesDomModel(xmlFile, webFacet)) != null) {
            models.add(domModel);
        }
    }

    protected abstract void addAnnotatedNodes(Collection<JsfModelElementNode> var1);

    @NotNull
    protected abstract Collection<SimpleNode> getFacesDomModelNodes(@NotNull FacesDomModel var1);

    public boolean isShowFromLibraries() {
        return this.myShowFromLibraries;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebFacetsNodes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacesDomModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWebFacetsNodes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addNotNullModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

