/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.fileEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.dnd.GraphDnDSupport;
import com.intellij.openapi.graph.builder.dnd.GraphDnDUtils;
import com.intellij.openapi.graph.builder.dnd.SimpleDnDPanel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.graph.PageflowDataModel;
import com.intellij.seam.graph.PageflowEdge;
import com.intellij.seam.graph.PageflowNode;
import com.intellij.seam.graph.PageflowPresentationModel;
import com.intellij.seam.graph.dnd.PageflowDnDSupport;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageflowDesignerComponent
extends JPanel
implements DataProvider,
Disposable {
    @NonNls
    public static final String SEAM_PAGEFLOW_DESIGNER_COMPONENT = "SEAM_PAGEFLOW_DESIGNER_COMPONENT";
    @NonNls
    private static final String SEAM_PAGEFLOW_DESIGNER_NAVIGATION_PROVIDER_NAME = "SEAM_PAGEFLOW_DESIGNER_NAVIGATION_PROVIDER_NAME";
    @NonNls
    private final SeamPageflowDesignerNavigationProvider myNavigationProvider = new SeamPageflowDesignerNavigationProvider();
    private final GraphBuilder<PageflowNode, PageflowEdge> myBuilder;
    private final XmlFile myXmlFile;
    private final PageflowDataModel myDataModel;

    public PageflowDesignerComponent(XmlFile xmlFile) {
        this.myXmlFile = xmlFile;
        Project project = xmlFile.getProject();
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
        this.myDataModel = new PageflowDataModel(xmlFile);
        PageflowPresentationModel presentationModel = new PageflowPresentationModel(graph, project);
        this.myBuilder = GraphBuilderFactory.getInstance((Project)project).createGraphBuilder(graph, view, (GraphDataModel)this.myDataModel, (GraphPresentationModel)presentationModel);
        GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)new MyDataProvider(this.myBuilder));
        Splitter splitter = new Splitter(false, 0.85f);
        this.setLayout(new BorderLayout());
        final SimpleDnDPanel simpleDnDPanel = GraphDnDUtils.createDnDActions((Project)project, this.myBuilder, (GraphDnDSupport)new PageflowDnDSupport(this.myDataModel));
        JComponent graphComponent = this.myBuilder.getView().getJComponent();
        splitter.setSecondComponent((JComponent)simpleDnDPanel.getTree());
        splitter.setFirstComponent(graphComponent);
        splitter.setDividerWidth(5);
        this.add((Component)this.createToolbarPanel(), "North");
        this.add((Component)splitter, "Center");
        Disposer.register((Disposable)this, this.myBuilder);
        this.myBuilder.initialize();
        DomManager.getDomManager((Project)this.myBuilder.getProject()).addDomEventListener(new DomEventListener(){

            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PageflowDesignerComponent.this.isShowing()) {
                    simpleDnDPanel.getBuilder().updateFromRoot();
                    PageflowDesignerComponent.this.myBuilder.queueUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/seam/fileEditor/PageflowDesignerComponent$1", "eventOccured"));
            }
        }, (Disposable)this);
    }

    private JComponent createToolbarPanel() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)GraphViewUtil.getBasicToolbar(this.myBuilder));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SeamPageflowDesigner", (ActionGroup)actions, true);
        return actionToolbar.getComponent();
    }

    public List<DomElement> getSelectedDomElements() {
        ArrayList<DomElement> selected = new ArrayList<DomElement>();
        Graph2D graph = this.myBuilder.getGraph();
        for (Node n : graph.getNodeArray()) {
            PageflowNode nodeObject;
            if (!graph.isSelected(n) || (nodeObject = (PageflowNode)this.myBuilder.getNodeObject(n)) == null) continue;
            ContainerUtil.addIfNotNull(selected, nodeObject.getIdentifyingElement());
        }
        return selected;
    }

    public void setSelectedDomElement(DomElement domElement) {
    }

    public GraphBuilder getBuilder() {
        return this.myBuilder;
    }

    public Overview getOverview() {
        return GraphManager.getGraphManager().createOverview(this.myBuilder.getView());
    }

    public void dispose() {
    }

    public SeamPageflowDesignerNavigationProvider getNavigationProvider() {
        return this.myNavigationProvider;
    }

    public XmlFile getXmlFile() {
        return this.myXmlFile;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            PageflowDesignerComponent.$$$reportNull$$$0(0);
        }
        if (dataId.equals(SEAM_PAGEFLOW_DESIGNER_COMPONENT)) {
            return this;
        }
        return null;
    }

    public PageflowDataModel getDataModel() {
        return this.myDataModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/seam/fileEditor/PageflowDesignerComponent", "getData"));
    }

    private class MyDataProvider
    implements DataProvider {
        private final Project myProject;
        private final Graph2D myGraph;

        MyDataProvider(GraphBuilder<PageflowNode, PageflowEdge> builder) {
            this.myProject = builder.getProject();
            this.myGraph = builder.getGraph();
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyDataProvider.$$$reportNull$$$0(0);
            }
            if (dataId.equals(CommonDataKeys.PROJECT.getName())) {
                return this.myProject;
            }
            if (dataId.equals(CommonDataKeys.PSI_ELEMENT.getName())) {
                for (Node node : this.myGraph.getNodeArray()) {
                    PageflowNode pageflowNode;
                    if (!this.myGraph.getRealizer(node).isSelected() || (pageflowNode = (PageflowNode)PageflowDesignerComponent.this.myBuilder.getNodeObject(node)) == null) continue;
                    return pageflowNode.getIdentifyingElement().getXmlElement();
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/seam/fileEditor/PageflowDesignerComponent$MyDataProvider", "getData"));
        }
    }

    private class SeamPageflowDesignerNavigationProvider
    extends DomElementNavigationProvider {
        private SeamPageflowDesignerNavigationProvider() {
        }

        public String getProviderName() {
            return PageflowDesignerComponent.SEAM_PAGEFLOW_DESIGNER_NAVIGATION_PROVIDER_NAME;
        }

        public void navigate(DomElement domElement, boolean requestFocus) {
            PageflowDesignerComponent.this.setSelectedDomElement(domElement);
        }

        public boolean canNavigate(DomElement domElement) {
            return domElement.isValid();
        }
    }
}

