/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentDeployment;
import com.intellij.javaee.heroku.cloud.HerokuBashSessionHelper;
import com.intellij.javaee.heroku.cloud.HerokuDebugConnectionDelegate;
import com.intellij.javaee.heroku.cloud.HerokuDebugConnectionProvider;
import com.intellij.javaee.heroku.cloud.HerokuServerRuntimeInstance;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudGitDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.SshKeyAwareServerRuntime;
import com.intellij.remoteServer.util.ssh.SshKeyChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class HerokuModuleDeploymentRuntime
extends CloudGitDeploymentRuntime
implements HerokuDebugConnectionProvider {
    private static final String REMOTE_NAME = "heroku";
    private static final String CLOUD_NAME = "Heroku";
    private static final String SYSTEM_PROPERTY_FILE_NAME = "system.properties";
    private static final String JAVA_RUNTIME_NAME = "java.runtime.version";
    private static final String JAVA_RUNTIME_VALUE = "1.7";
    private final HerokuDebugConnectionDelegate myDebugConnectionDelegate;
    private final HerokuBashSessionHelper myBashSessionHelper;

    public HerokuModuleDeploymentRuntime(CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentSource source, File repositoryRoot, DeploymentTask<? extends CloudDeploymentNameConfiguration> task, DeploymentLogManager logManager) throws ServerRuntimeException {
        super(serverRuntime, source, repositoryRoot, task, logManager, REMOTE_NAME, CLOUD_NAME);
        this.myDebugConnectionDelegate = new HerokuDebugConnectionDelegate(task, this.getDeployment(), this.getAgentTaskExecutor());
        this.myBashSessionHelper = new HerokuBashSessionHelper((CloudDeploymentRuntime)this);
    }

    public HerokuCloudAgentDeployment getDeployment() {
        return (HerokuCloudAgentDeployment)super.getDeployment();
    }

    public CloudGitApplication deploy() throws ServerRuntimeException {
        try {
            this.myDebugConnectionDelegate.checkDebugMode();
            CloudGitApplication result = super.deploy();
            this.getDeployment().startListeningLog(this.getLoggingHandler());
            return result;
        }
        catch (ServerRuntimeException e) {
            new SshKeyChecker().checkDeploymentError(e.getMessage(), (SshKeyAwareServerRuntime)((HerokuServerRuntimeInstance)this.getServerRuntime()), this.getLogManager(), this.getTask());
            throw e;
        }
    }

    public void undeploy() throws ServerRuntimeException {
        super.undeploy();
        this.getDeployment().stopListeningLog();
    }

    public void createApplicationByTemplate(String templateGitUrl) throws ServerRuntimeException {
        new CloudGitDeploymentRuntime.CloneJob((CloudGitDeploymentRuntime)this).cloneToModule(templateGitUrl);
        this.fixJavaRuntime();
        CloudGitApplication application = this.createApplication();
        this.addGitRemote(application);
        this.fetchAndRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixJavaRuntime() throws ServerRuntimeException {
        try {
            Properties systemProperties = new Properties();
            File systemPropertyFile = new File(this.getRepositoryRootFile(), SYSTEM_PROPERTY_FILE_NAME);
            if (systemPropertyFile.exists()) {
                FileInputStream inputStream = new FileInputStream(systemPropertyFile);
                try {
                    systemProperties.load(inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (StringUtil.equals((CharSequence)systemProperties.getProperty(JAVA_RUNTIME_NAME), (CharSequence)JAVA_RUNTIME_VALUE)) {
                    return;
                }
            }
            systemProperties.setProperty(JAVA_RUNTIME_NAME, JAVA_RUNTIME_VALUE);
            FileOutputStream outputStream = new FileOutputStream(systemPropertyFile);
            try {
                systemProperties.store(outputStream, null);
            }
            finally {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException iOException) {}
            }
            this.add();
            this.commit("Fix Java runtime version");
        }
        catch (IOException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
    }

    @Override
    public JavaDebugConnectionData getDebugConnectionData() throws ServerRuntimeException {
        return this.myDebugConnectionDelegate.getDebugConnectionData();
    }
}

