/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.lang.javascript.library.download.TypeScriptAllStubsFile;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableWebLibrariesSource;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class TypeScriptDefinitionFilesSource
extends DownloadableWebLibrariesSource {
    TypeScriptDefinitionFilesSource() {
        super("TypeScript community stubs", false);
    }

    public void prepareTableModel(DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl> callback) {
        File cacheFile = TypeScriptAllStubsFile.getAllTsStubDescriptionsCacheFile();
        if (cacheFile.isFile() && cacheFile.lastModified() > System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(30L)) {
            try {
                callback.onSuccess(TypeScriptAllStubsFile.INSTANCE.parseDescriptions(cacheFile));
                TypeScriptAllStubsFile.INSTANCE.downloadTsStubDescriptionsCacheFile(false);
                return;
            }
            catch (IOException ignored) {
                FileUtil.delete((File)cacheFile);
            }
        }
        try {
            TypeScriptAllStubsFile.INSTANCE.downloadTsStubDescriptionsCacheFile(true);
        }
        catch (IOException e) {
            callback.onError(e.getMessage());
            return;
        }
        try {
            callback.onSuccess(TypeScriptAllStubsFile.INSTANCE.parseDescriptions(cacheFile));
        }
        catch (IOException e) {
            FileUtil.delete((File)cacheFile);
            callback.onError(e.getMessage());
        }
    }
}

