/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.JSMatchingStrategy;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralSearchProfile
extends StructuralSearchProfile {
    private static final String TYPED_VAR_PREFIX = "__$_";

    @NotNull
    public CompiledPattern createCompiledPattern() {
        CompiledPattern compiledPattern = new CompiledPattern(){
            {
                this.setStrategy(JSMatchingStrategy.getInstance());
            }

            public String[] getTypedVarPrefixes() {
                return new String[]{JSStructuralSearchProfile.TYPED_VAR_PREFIX};
            }

            public boolean isTypedVar(String str) {
                return str.startsWith(JSStructuralSearchProfile.TYPED_VAR_PREFIX);
            }
        };
        if (compiledPattern == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        return compiledPattern;
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        if (element instanceof JSExpressionStatement) {
            String string = StringUtil.trimEnd((String)element.getText(), (char)';');
            if (string == null) {
                JSStructuralSearchProfile.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = super.getTypedVarString(element);
        if (string == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> JSStructuralSearchProfile.isLexicalNode(element);
        if (nodeFilter == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        return nodeFilter;
    }

    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        new JSCompilingVisitor(globalVisitor).compile(elements);
    }

    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        JSMatchingVisitor jSMatchingVisitor = new JSMatchingVisitor(globalVisitor);
        if (jSMatchingVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        return jSMatchingVisitor;
    }

    static boolean isLexicalNode(@NotNull PsiElement element) {
        if (element == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (!(element instanceof LeafElement)) {
            return false;
        }
        IElementType type = ((LeafElement)element).getElementType();
        return type == JSTokenTypes.COMMA || type == JSTokenTypes.SEMICOLON;
    }

    static boolean canBePatternVariable(PsiElement element) {
        ASTNode node;
        PsiElement child = element.getFirstChild();
        if (child == null) {
            return true;
        }
        if ((element instanceof JSReferenceExpression || element instanceof JSParameter) && (node = child.getNode()) != null) {
            return node.getElementType() == JSTokenTypes.IDENTIFIER && child.getNextSibling() == null;
        }
        return false;
    }

    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        return language instanceof JavascriptLanguage || language instanceof JSLanguageDialect;
    }

    public boolean isIdentifier(@Nullable PsiElement element) {
        return element != null && element.getNode().getElementType() == JSTokenTypes.IDENTIFIER;
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        if (JavaScriptCodeContextType.class == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        return JavaScriptCodeContextType.class;
    }

    public void checkSearchPattern(CompiledPattern pattern) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    public void checkReplacementPattern(Project project, ReplaceOptions options) {
        MatchOptions matchOptions = options.getMatchOptions();
        FileType fileType = matchOptions.getFileType();
        boolean searchIsExpression = this.isProbableExpression(matchOptions.getSearchPattern(), fileType, project);
        boolean replacementIsExpression = this.isProbableExpression(options.getReplacement(), fileType, project);
        boolean targetFound = false;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (!constraint.isPartOfSearchResults()) continue;
            targetFound = true;
            break;
        }
        if (!targetFound && searchIsExpression != replacementIsExpression) {
            throw new UnsupportedPatternException(searchIsExpression ? SSRBundle.message((String)"replacement.template.is.not.expression.error.message", (Object[])new Object[0]) : SSRBundle.message((String)"search.template.is.not.expression.error.message", (Object[])new Object[0]));
        }
    }

    private boolean isProbableExpression(String pattern, FileType fileType, Project project) {
        PsiElement[] searchElements = this.createPatternTree(pattern, PatternTreeContext.File, fileType, project, false);
        if (searchElements.length != 1) {
            return false;
        }
        PsiElement element = searchElements[0];
        if (!(element instanceof JSExpressionStatement)) {
            return false;
        }
        PsiElement lastChild = element.getLastChild();
        return !(lastChild instanceof LeafPsiElement) || ((LeafPsiElement)lastChild).getElementType() != JSTokenTypes.SEMICOLON;
    }

    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (replaceOptions == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        return new DocumentBasedReplaceHandler(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/JSStructuralSearchProfile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiledPattern";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/JSStructuralSearchProfile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatchingVisitor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContextTypeClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isLexicalNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSCompilingVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final GlobalCompilingVisitor myCompilingVisitor;
        private PsiElement myTopLevelElement = null;

        JSCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
            this.myCompilingVisitor = compilingVisitor;
        }

        public void compile(PsiElement[] topLevelElements) {
            CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
            MatchOptions options = this.myCompilingVisitor.getContext().getOptions();
            Language dialect = options.getDialect();
            if (dialect != null) {
                pattern.setStrategy((MatchingStrategy)new JSMatchingStrategy(dialect));
            }
            for (PsiElement element : topLevelElements) {
                if (topLevelElements.length == 1) {
                    this.myTopLevelElement = element;
                }
                if (element instanceof PsiWhiteSpace) {
                    this.myCompilingVisitor.addLexicalNode(element);
                    continue;
                }
                element.accept((PsiElementVisitor)this);
                pattern.setHandler(element, (MatchingHandler)new TopLevelMatchingHandler(pattern.getHandler(element)));
            }
        }

        public void visitElement(PsiElement element) {
            if (!(element instanceof JSReferenceListMember)) {
                this.myCompilingVisitor.handle(element);
            }
            super.visitElement(element);
            if (this.myCompilingVisitor.getContext().getSearchHelper().doOptimizing() && element instanceof LeafElement && ((LeafElement)element).getElementType() == JSTokenTypes.IDENTIFIER && !this.myCompilingVisitor.getContext().getPattern().isTypedVar(element.getText())) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)element.getText(), (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)this.myCompilingVisitor.getContext());
            }
        }

        public void visitJSVariable(JSVariable variable) {
            super.visitJSVariable(variable);
            GlobalCompilingVisitor.setFilter((MatchingHandler)this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)variable), e -> e instanceof JSVariable);
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            super.visitJSReferenceExpression(expression);
            PsiElement parent = expression.getParent();
            if (parent instanceof JSClass || parent instanceof JSExpressionStatement && parent != this.myTopLevelElement) {
                return;
            }
            CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
            if (pattern.isRealTypedVar((PsiElement)expression)) {
                GlobalCompilingVisitor.setFilter((MatchingHandler)pattern.getHandler((PsiElement)expression), e -> e instanceof JSExpression || e instanceof LeafElement && ((LeafElement)e).getElementType() == JSTokenTypes.IDENTIFIER);
            }
        }

        public void visitJSLiteralExpression(JSLiteralExpression expression) {
            MatchingHandler handler;
            super.visitJSLiteralExpression(expression);
            if ((expression.isQuotedLiteral() || expression.isRegExpLiteral()) && (handler = this.myCompilingVisitor.processPatternStringWithFragments(expression.getText(), GlobalCompilingVisitor.OccurenceKind.LITERAL)) != null) {
                expression.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
            }
        }

        public void visitJSExpressionStatement(JSExpressionStatement statement) {
            super.visitJSExpressionStatement(statement);
            JSExpression expression = statement.getExpression();
            MatchingHandler statementHandler = new MatchingHandler(){

                public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
                    return context.getMatcher().match((PsiElement)((JSExpressionStatement)patternNode).getExpression(), matchedNode);
                }
            };
            if (this.myTopLevelElement == statement && expression != null && statement.getFirstChild() == statement.getLastChild()) {
                this.myCompilingVisitor.setHandler((PsiElement)statement, statementHandler);
                GlobalCompilingVisitor.setFilter((MatchingHandler)statementHandler, e -> e instanceof JSExpression || e instanceof LeafElement && ((LeafElement)e).getElementType() == JSTokenTypes.IDENTIFIER);
            } else {
                MatchingHandler handler;
                CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
                if (expression instanceof JSReferenceExpression && pattern.isRealTypedVar((PsiElement)statement) && (handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)statement)) instanceof SubstitutionHandler) {
                    ((SubstitutionHandler)handler).setMatchHandler(statementHandler);
                    handler.setFilter(e -> e instanceof JSStatement && !(e.getParent() instanceof JSFunction) && !(e instanceof JSPackageStatement) || e instanceof PsiComment && e.getParent() instanceof JSBlockStatement);
                }
            }
        }

        public void visitJSAttributeNameValuePair(JSAttributeNameValuePair attributeNameValuePair) {
            super.visitJSAttributeNameValuePair(attributeNameValuePair);
            ASTNode valueNode = attributeNameValuePair.getValueNode();
            if (valueNode == null) {
                return;
            }
            String text = valueNode.getText();
            if (!StringUtil.isQuotedString((String)text)) {
                return;
            }
            MatchingHandler handler = this.myCompilingVisitor.processPatternStringWithFragments(text, GlobalCompilingVisitor.OccurenceKind.LITERAL);
            if (handler != null) {
                valueNode.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
            }
        }

        public void visitJSAttributeList(JSAttributeList list) {
            super.visitJSAttributeList(list);
            if (this.myTopLevelElement != list) {
                return;
            }
            JSAttribute[] attributes = list.getAttributes();
            if (attributes.length != 1) {
                return;
            }
            JSAttribute attribute = attributes[0];
            if (!attribute.getText().equals(list.getText())) {
                return;
            }
            MatchingHandler handler = new MatchingHandler(){

                public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
                    return super.match(patternNode, matchedNode, context) && context.getMatcher().match((PsiElement)((JSAttributeList)patternNode).getAttributes()[0], matchedNode);
                }
            };
            this.myCompilingVisitor.setHandler((PsiElement)list, handler);
            handler.setFilter(element -> element instanceof JSAttribute);
        }
    }

    private static class JSMatchingVisitor
    extends JSElementVisitor {
        private final GlobalMatchingVisitor myMatchingVisitor;

        JSMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
            this.myMatchingVisitor = matchingVisitor;
        }

        PsiElement extractOnlyStatement(PsiElement element) {
            if (!(element instanceof JSBlockStatement) || !this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
                return element;
            }
            JSBlockStatement blockStatement = (JSBlockStatement)element;
            if (blockStatement.getParent() instanceof JSFunction) {
                return blockStatement;
            }
            JSStatement[] statements = blockStatement.getStatements();
            return statements.length == 1 ? statements[0] : blockStatement;
        }

        public void visitElement(PsiElement element) {
            PsiElement other = this.myMatchingVisitor.getElement();
            PsiElement statement = this.extractOnlyStatement(other);
            if (statement != other) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(element, statement));
                return;
            }
            super.visitElement(element);
            if (JSStructuralSearchProfile.canBePatternVariable(element)) {
                if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(element)) {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(element, other));
                } else {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(element, other));
                }
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((NodeIterator)new SsrFilteringNodeIterator(element.getFirstChild()), (NodeIterator)new SsrFilteringNodeIterator(other.getFirstChild())));
            }
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            boolean multiMatch;
            PsiElement other = this.myMatchingVisitor.getElement();
            if (other instanceof LeafElement && ((LeafElement)other).getElementType() == JSTokenTypes.IDENTIFIER && other.getParent() instanceof JSReferenceExpression) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
            JSExpression qualifier = expression.getQualifier();
            boolean typedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)expression);
            boolean bl = multiMatch = expression.getContainingFile() == other.getContainingFile();
            if (!(qualifier == null && typedVar || !(other instanceof JSReferenceExpression) || multiMatch)) {
                JSReferenceExpression referenceExpression = (JSReferenceExpression)other;
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(expression.getReferenceNameElement(), referenceExpression.getReferenceNameElement()))) {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)qualifier, (PsiElement)referenceExpression.getQualifier()));
                }
            } else {
                super.visitJSReferenceExpression(expression);
            }
        }

        public void visitJSAttributeNameValuePair(JSAttributeNameValuePair attributeNameValuePair) {
            JSAttributeNameValuePair other = (JSAttributeNameValuePair)this.myMatchingVisitor.getElement();
            if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(attributeNameValuePair.getNameIdentifier(), other.getNameIdentifier()))) {
                return;
            }
            ASTNode valueNode = attributeNameValuePair.getValueNode();
            if (valueNode == null) {
                return;
            }
            PsiElement value2 = other.getLastChild();
            MatchingHandler handler = (MatchingHandler)valueNode.getUserData(CompiledPattern.HANDLER_KEY);
            if (handler instanceof SubstitutionHandler) {
                String text = value2.getText();
                int offset = 0;
                int length = text.length();
                if (StringUtil.isQuotedString((String)text)) {
                    ++offset;
                    --length;
                }
                this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle(value2, offset, length, this.myMatchingVisitor.getMatchContext()));
            } else if (handler != null) {
                this.myMatchingVisitor.setResult(handler.match(attributeNameValuePair.getLastChild(), value2, this.myMatchingVisitor.getMatchContext()));
            } else {
                String text1 = StringUtil.unquoteString((String)valueNode.getText());
                String text2 = StringUtil.unquoteString((String)value2.getText());
                boolean caseSensitiveMatch = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch();
                this.myMatchingVisitor.setResult(caseSensitiveMatch ? text1.equals(text2) : text1.equalsIgnoreCase(text2));
            }
        }

        public void visitJSLiteralExpression(JSLiteralExpression patternLiteral) {
            JSLiteralExpression matchLiteral = (JSLiteralExpression)this.myMatchingVisitor.getElement();
            if (!this.myMatchingVisitor.setResult(patternLiteral.isQuotedLiteral() == matchLiteral.isQuotedLiteral() && patternLiteral.isRegExpLiteral() == matchLiteral.isRegExpLiteral())) {
                return;
            }
            MatchingHandler handler = (MatchingHandler)patternLiteral.getUserData(CompiledPattern.HANDLER_KEY);
            if (handler instanceof SubstitutionHandler) {
                int offset = 0;
                int length = matchLiteral.getTextLength();
                if (matchLiteral.isQuotedLiteral() || matchLiteral.isRegExpLiteral()) {
                    --length;
                    ++offset;
                }
                this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)matchLiteral, offset, length, this.myMatchingVisitor.getMatchContext()));
            } else if (handler != null) {
                this.myMatchingVisitor.setResult(handler.match((PsiElement)patternLiteral, (PsiElement)matchLiteral, this.myMatchingVisitor.getMatchContext()));
            } else {
                Object value1 = patternLiteral.getValue();
                Object value2 = matchLiteral.getValue();
                if (value1 instanceof String && value2 instanceof String) {
                    boolean caseSensitiveMatch = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch();
                    String string1 = (String)value1;
                    String string2 = (String)value2;
                    this.myMatchingVisitor.setResult(caseSensitiveMatch ? string1.equals(string2) : string1.equalsIgnoreCase(string2));
                } else if (value1 != null && value2 != null) {
                    this.myMatchingVisitor.setResult(value1.equals(value2));
                } else {
                    this.myMatchingVisitor.setResult(false);
                }
            }
        }

        public void visitJSFunctionDeclaration(JSFunction f1) {
            JSFunction f2 = (JSFunction)this.myMatchingVisitor.getElement();
            this.myMatchingVisitor.setResult(f1.getKind() == f2.getKind() && this.myMatchingVisitor.match(f1.getNameIdentifier(), f2.getNameIdentifier()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)f1.getAttributeList(), (PsiElement)f2.getAttributeList()) && this.myMatchingVisitor.matchSons((PsiElement)f1.getParameterList(), (PsiElement)f2.getParameterList()) && this.myMatchingVisitor.matchOptionally(f1.getReturnTypeElement(), f2.getReturnTypeElement()) && this.myMatchingVisitor.matchOptionally((PsiElement[])f1.getBody(), (PsiElement[])f2.getBody()));
        }

        public void visitJSClass(JSClass c1) {
            JSClass c2 = (JSClass)this.myMatchingVisitor.getElement();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(c1.getNameIdentifier(), c2.getNameIdentifier()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)c1.getAttributeList(), (PsiElement)c2.getAttributeList()) && this.myMatchingVisitor.matchSonsInAnyOrder((PsiElement)c1.getExtendsList(), (PsiElement)c2.getExtendsList()) && this.myMatchingVisitor.matchSonsInAnyOrder((PsiElement)c1.getImplementsList(), (PsiElement)c2.getImplementsList()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])c1.getFields(), (PsiElement[])c2.getFields()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])c1.getFunctions(), (PsiElement[])c2.getFunctions()));
        }

        public void visitJSVarStatement(JSVarStatement vs1) {
            JSVarStatement vs2 = (JSVarStatement)this.myMatchingVisitor.getElement();
            PsiElement firstChild1 = vs1.getFirstChild();
            PsiElement firstChild2 = vs2.getFirstChild();
            boolean result2 = !(firstChild1 instanceof JSAttributeList) || firstChild1.getTextLength() <= 0 || firstChild2 instanceof JSAttributeList && this.myMatchingVisitor.match(firstChild1, firstChild2);
            this.myMatchingVisitor.setResult(result2 && this.myMatchingVisitor.matchSequentially((PsiElement[])vs1.getVariables(), (PsiElement[])vs2.getVariables()));
        }

        public void visitJSVariable(JSVariable variable1) {
            JSVariable variable2 = (JSVariable)this.myMatchingVisitor.getElement();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(variable1.getNameIdentifier(), variable2.getNameIdentifier()) && this.myMatchingVisitor.matchOptionally((PsiElement)variable1.getInitializerOrStub(), (PsiElement)variable2.getInitializerOrStub()));
        }

        public void visitJSIfStatement(JSIfStatement if1) {
            JSIfStatement if2 = (JSIfStatement)this.myMatchingVisitor.getElement();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)if1.getCondition(), (PsiElement)if2.getCondition()) && this.matchBody((PsiElement)if1.getThen(), (PsiElement)if2.getThen()) && this.matchBody((PsiElement)if1.getElse(), (PsiElement)if2.getElse()));
        }

        public void visitJSForStatement(JSForStatement for1) {
            JSForStatement for2 = (JSForStatement)this.myMatchingVisitor.getElement();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getVarDeclaration(), (PsiElement)for2.getVarDeclaration()) && this.myMatchingVisitor.match((PsiElement)for1.getInitialization(), (PsiElement)for2.getInitialization()) && this.myMatchingVisitor.match((PsiElement)for1.getCondition(), (PsiElement)for2.getCondition()) && this.myMatchingVisitor.match((PsiElement)for1.getUpdate(), (PsiElement)for2.getUpdate()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
        }

        public void visitJSForInStatement(JSForInStatement for1) {
            JSForInStatement for2 = (JSForInStatement)this.myMatchingVisitor.getElement();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getDeclarationStatement(), (PsiElement)for2.getDeclarationStatement()) && this.myMatchingVisitor.match((PsiElement)for1.getVariableExpression(), (PsiElement)for2.getVariableExpression()) && this.myMatchingVisitor.match((PsiElement)for1.getCollectionExpression(), (PsiElement)for1.getCollectionExpression()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement while1) {
            JSDoWhileStatement while2 = (JSDoWhileStatement)this.myMatchingVisitor.getElement();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
        }

        public void visitJSWhileStatement(JSWhileStatement while1) {
            JSWhileStatement while2 = (JSWhileStatement)this.myMatchingVisitor.getElement();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
        }

        public void visitJSBlock(JSBlockStatement patternBlock) {
            PsiElement matchElement = this.myMatchingVisitor.getElement();
            if (matchElement instanceof JSBlockStatement) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)patternBlock, matchElement));
            } else {
                List patternChildren = PsiTreeUtil.getChildrenOfAnyType((PsiElement)patternBlock, (Class[])new Class[]{JSStatement.class, PsiComment.class});
                if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching() && patternChildren.size() == 1) {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)patternChildren.get(0), matchElement));
                } else {
                    this.myMatchingVisitor.setResult(false);
                }
            }
        }

        private boolean matchBody(PsiElement patternElement, PsiElement matchElement) {
            if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
                List<PsiElement> matchElements;
                if (patternElement == null) {
                    return true;
                }
                if (matchElement instanceof JSBlockStatement) {
                    List<PsiElement> children = PsiTreeUtil.getChildrenOfAnyType((PsiElement)matchElement, (Class[])new Class[]{JSStatement.class, PsiComment.class});
                    matchElements = patternElement instanceof JSBlockStatement || children.size() == 1 ? children : Collections.singletonList(matchElement);
                } else {
                    matchElements = Collections.singletonList(matchElement);
                }
                List patternElements = patternElement instanceof JSBlockStatement ? PsiTreeUtil.getChildrenOfAnyType((PsiElement)patternElement, (Class[])new Class[]{JSStatement.class, PsiComment.class}) : Collections.singletonList(patternElement);
                return this.myMatchingVisitor.matchSequentially(patternElements.toArray(PsiElement.EMPTY_ARRAY), matchElements.toArray(PsiElement.EMPTY_ARRAY));
            }
            return this.myMatchingVisitor.matchSequentially(patternElement, matchElement);
        }
    }

    static class ValidatingVisitor
    extends JSRecursiveWalkingElementVisitor {
        ValidatingVisitor() {
        }

        public void visitErrorElement(PsiErrorElement element) {
            super.visitErrorElement(element);
            String errorDescription = element.getErrorDescription();
            throw new MalformedPatternException(errorDescription);
        }
    }
}

