/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.semantic.SemService;
import com.intellij.spring.boot.cloud.stream.SpringCloudStreamBundle;
import com.intellij.spring.boot.cloud.stream.inspections.SpringCloudStreamInspectionBase;
import com.intellij.spring.boot.cloud.stream.model.jam.ReactiveOutput;
import com.intellij.spring.boot.cloud.stream.model.jam.SendTo;
import com.intellij.spring.boot.cloud.stream.model.jam.StreamEmitter;
import com.intellij.spring.boot.cloud.stream.model.jam.StreamListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

public class SpringCloudStreamInconsistencyInspection
extends SpringCloudStreamInspectionBase {
    @Override
    @Nullable
    protected ProblemDescriptor[] doCheckClass(@NotNull UClass aClass, @NotNull Module module, @NotNull ProblemsHolder holder) {
        if (aClass == null) {
            SpringCloudStreamInconsistencyInspection.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringCloudStreamInconsistencyInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringCloudStreamInconsistencyInspection.$$$reportNull$$$0(2);
        }
        SemService semService = SemService.getSemService((Project)module.getProject());
        for (UMethod uMethod : aClass.getMethods()) {
            boolean hasMethodOutput;
            PsiElement psiIdentifier;
            PsiMethod psiMethod = uMethod.getJavaPsi();
            StreamListener streamListener = (StreamListener)semService.getSemElement(StreamListener.JAM_KEY, (PsiElement)psiMethod);
            StreamEmitter streamEmitter = null;
            if (streamListener == null) {
                streamEmitter = (StreamEmitter)semService.getSemElement(StreamEmitter.JAM_KEY, (PsiElement)psiMethod);
            }
            if (streamListener == null && streamEmitter == null || (psiIdentifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) continue;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"org.springframework.cloud.stream.annotation.Input", (int)0)) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.input.at.stream.listener", new Object[0]), new LocalQuickFix[0]);
            }
            boolean bl = hasMethodOutput = !StringUtil.isEmptyOrSpaces((String)SpringCloudStreamInconsistencyInspection.checkMethodOutput(psiMethod, holder, semService));
            if (streamListener != null) {
                SpringCloudStreamInconsistencyInspection.checkStreamListener(streamListener, hasMethodOutput, uMethod, psiIdentifier, holder);
                continue;
            }
            SpringCloudStreamInconsistencyInspection.checkStreamEmitter(hasMethodOutput, uMethod, psiIdentifier, holder);
        }
        return holder.getResultsArray();
    }

    private static void checkStreamListener(StreamListener streamListener, boolean hasMethodOutput, UMethod uMethod, PsiElement psiIdentifier, ProblemsHolder holder) {
        boolean hasCondition;
        boolean hasMethodInput = !StringUtil.isEmptyOrSpaces((String)streamListener.getInboundChannelName());
        int inputParamsCount = SpringCloudStreamInconsistencyInspection.getAnnotatedParametersCount(uMethod, "org.springframework.cloud.stream.annotation.Input");
        int outputParamsCount = SpringCloudStreamInconsistencyInspection.getAnnotatedParametersCount(uMethod, "org.springframework.cloud.stream.annotation.Output");
        if (hasMethodInput) {
            if (inputParamsCount != 0) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.invalid.input.values", new Object[0]), new LocalQuickFix[0]);
            }
            if (outputParamsCount != 0) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.invalid.input.value.with.output.method.param", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (inputParamsCount == 0) {
            holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.no.input.destination", new Object[0]), new LocalQuickFix[0]);
        }
        boolean isVoid = PsiType.VOID.equals((Object)uMethod.getReturnType());
        if (hasMethodOutput) {
            if (outputParamsCount != 0) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.invalid.output.values", new Object[0]), new LocalQuickFix[0]);
            }
            if (isVoid) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.output.on.void.method", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (!isVoid) {
            if (outputParamsCount == 0) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.no.output.on.non.void.method", new Object[0]), new LocalQuickFix[0]);
            } else if (outputParamsCount > 1) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.multiple.outputs", new Object[0]), new LocalQuickFix[0]);
            }
        }
        boolean bl = hasCondition = !StringUtil.isEmptyOrSpaces((String)streamListener.getCondition());
        if (!isVoid && hasCondition) {
            holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.condition.on.non.void.method", new Object[0]), new LocalQuickFix[0]);
        }
        int paramsCount = uMethod.getUastParameters().size();
        if (inputParamsCount != 0 || outputParamsCount != 0) {
            if (paramsCount > 1 && inputParamsCount + outputParamsCount != paramsCount) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.invalid.declarative.params", new Object[0]), new LocalQuickFix[0]);
            }
            if (hasCondition) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.condition.on.declarative.method", new Object[0]), new LocalQuickFix[0]);
            }
        } else {
            int annotatedParamsCount;
            int payloadParamsCount = SpringCloudStreamInconsistencyInspection.getAnnotatedParametersCount(uMethod, "org.springframework.messaging.handler.annotation.Payload");
            if (payloadParamsCount > 0 && ((annotatedParamsCount = SpringCloudStreamInconsistencyInspection.getAnnotatedParametersCount(uMethod)) != paramsCount || payloadParamsCount > 1)) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.ambiguous.method.arguments", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkStreamEmitter(boolean hasMethodOutput, UMethod uMethod, PsiElement psiIdentifier, ProblemsHolder holder) {
        int outputParamsCount = SpringCloudStreamInconsistencyInspection.getAnnotatedParametersCount(uMethod, "org.springframework.cloud.stream.annotation.Output");
        if (hasMethodOutput) {
            if (outputParamsCount != 0) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.invalid.output.values", new Object[0]), new LocalQuickFix[0]);
            }
        } else {
            if (outputParamsCount == 0) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.no.output.destination", new Object[0]), new LocalQuickFix[0]);
            }
            if (!PsiType.VOID.equals((Object)uMethod.getReturnType())) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.no.output.on.non.void.method", new Object[0]), new LocalQuickFix[0]);
            } else if (outputParamsCount != uMethod.getUastParameters().size()) {
                holder.registerProblem(psiIdentifier, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.no.output.on.void.method.param", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static int getAnnotatedParametersCount(UMethod uMethod, String annotationName) {
        int count = 0;
        for (UParameter uParameter : uMethod.getUastParameters()) {
            PsiParameter psiParameter = (PsiParameter)UElementKt.getAsJavaPsiElement((UElement)uParameter, PsiParameter.class);
            if (psiParameter == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)annotationName, (int)0)) continue;
            ++count;
        }
        return count;
    }

    private static int getAnnotatedParametersCount(UMethod uMethod) {
        int count = 0;
        for (UParameter uParameter : uMethod.getUastParameters()) {
            if (!uParameter.getAnnotations().stream().anyMatch(uAnnotation -> uAnnotation.getSourcePsi() != null)) continue;
            ++count;
        }
        return count;
    }

    private static String checkMethodOutput(PsiMethod psiMethod, ProblemsHolder holder, SemService semService) {
        SendTo sendTo = (SendTo)semService.getSemElement(SendTo.JAM_KEY, (PsiElement)psiMethod);
        if (sendTo != null) {
            PsiElement elementToReport;
            List<String> values = sendTo.getValues();
            if (values.isEmpty()) {
                PsiElement elementToReport2 = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)sendTo.getAnnotation(), UAnnotation.class)));
                if (elementToReport2 != null) {
                    holder.registerProblem(elementToReport2, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.no.output.value", new Object[0]), new LocalQuickFix[0]);
                }
                return null;
            }
            if (values.size() > 1 && (elementToReport = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)sendTo.getAnnotation(), UAnnotation.class)))) != null) {
                holder.registerProblem(elementToReport, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.multiple.destinations", new Object[0]), new LocalQuickFix[0]);
            }
            return values.get(0);
        }
        ReactiveOutput output = (ReactiveOutput)semService.getSemElement(ReactiveOutput.JAM_KEY, (PsiElement)psiMethod);
        if (output != null) {
            PsiElement elementToReport;
            String value = output.getValue();
            if (value == null && (elementToReport = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)output.getAnnotation(), UAnnotation.class)))) != null) {
                holder.registerProblem(elementToReport, SpringCloudStreamBundle.message("spring.cloud.stream.inconsistency.inspection.no.output.value", new Object[0]), new LocalQuickFix[0]);
            }
            return value;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/cloud/stream/inspections/SpringCloudStreamInconsistencyInspection";
        objectArray[2] = "doCheckClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

