/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.java.JavaUmlProvider;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.uml.utils.UmlJavaUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ElementPresentation;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JavaUmlElementManager
extends AbstractDiagramElementManager<PsiElement> {
    public PsiElement findInDataContext(DataContext context) {
        PsiFile psiFile;
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (element instanceof PsiDirectory) {
            JavaDirectoryService service = JavaDirectoryService.getInstance();
            return service == null || project == null ? null : service.getPackage((PsiDirectory)element);
        }
        if (element instanceof PsiPackage) {
            return project == null ? null : element;
        }
        PsiElement psiElement = element = element == null || element.getLanguage() != JavaFileType.INSTANCE.getLanguage() ? null : element;
        if (element instanceof PsiClass) {
            return element;
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            return ((PsiMethod)element).getContainingClass();
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile psiFile2 = psiFile = element instanceof PsiFile ? (PsiFile)element : (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (psiFile == null && editor != null) {
            psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (psiFile != null) {
            if (editor != null) {
                PsiClass psiClass;
                PsiElement psiElement2 = PsiUtil.getElementAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset());
                PsiElement resolved = psiElement2.getParent() instanceof PsiReference ? ((PsiReference)psiElement2.getParent()).resolve() : null;
                PsiClass psiClass2 = psiClass = resolved instanceof PsiClass ? (PsiClass)resolved : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, PsiClass.class);
                while (psiClass instanceof PsiAnonymousClass) {
                    psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
                }
                return psiClass;
            }
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null) {
                String className = file.getNameWithoutExtension();
                for (PsiElement psiElement3 : psiFile.getChildren()) {
                    if (!(psiElement3 instanceof PsiClass) || !className.equals(((PsiClass)psiElement3).getName())) continue;
                    return psiElement3;
                }
            }
        }
        return null;
    }

    @NotNull
    public Collection<PsiElement> findElementsInDataContext(DataContext context) {
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (psiElements != null && psiElements.length > 1) {
            for (PsiElement element : psiElements) {
                if (this.isAcceptableAsNode(element)) continue;
                Collection collection = super.findElementsInDataContext(context);
                if (collection == null) {
                    JavaUmlElementManager.$$$reportNull$$$0(0);
                }
                return collection;
            }
            List<PsiElement> list = Arrays.asList(psiElements);
            if (list == null) {
                JavaUmlElementManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection collection = super.findElementsInDataContext(context);
        if (collection == null) {
            JavaUmlElementManager.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public boolean isAcceptableAsNode(Object element) {
        if (element instanceof PsiClass) {
            return !(element instanceof PsiAnonymousClass);
        }
        return element instanceof PsiPackage;
    }

    public Object[] getNodeItems(PsiElement parent) {
        if (parent instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)parent;
            ArrayList<JavaProperty> elements = new ArrayList<JavaProperty>();
            ContainerUtil.addAll(elements, (Object[])psiClass.getFields());
            ContainerUtil.addAll(elements, (Object[])psiClass.getMethods());
            elements.addAll(JavaProperty.getAllProperties(psiClass));
            return elements.isEmpty() ? PsiElement.EMPTY_ARRAY : elements.toArray();
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean isContainerFor(PsiElement parent, PsiElement child) {
        if (parent instanceof PsiPackage && child instanceof PsiQualifiedNamedElement) {
            PsiQualifiedNamedElement psiQualifiedNamedElement = (PsiQualifiedNamedElement)child;
            PsiPackage psiPackage = (PsiPackage)parent;
            String fqn = psiQualifiedNamedElement.getQualifiedName();
            return fqn != null && fqn.startsWith(psiPackage.getQualifiedName());
        }
        return false;
    }

    public String getElementTitle(PsiElement element) {
        if (element instanceof PsiClass) {
            if (element instanceof PsiAnonymousClass) {
                return ElementPresentation.forElement((PsiElement)element).getName();
            }
            return ((PsiClass)element).getName();
        }
        String name = ((PsiPackage)element).getName();
        return name == null ? UmlBundle.message("uml.java.default.package.title", new Object[0]) : UmlBundle.message("uml.java.package.title", name);
    }

    public int getTitleAttributes(PsiElement element) {
        if (element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated()) {
            return 4;
        }
        return super.getTitleAttributes((Object)element);
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        if (element instanceof PsiEnumConstant) {
            return null;
        }
        if (element instanceof Iconable) {
            return ((Iconable)element).getIcon(1);
        }
        return super.getItemIcon(element, presentation);
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        if (element instanceof PsiMethod) {
            return JavaUmlElementManager.getMethodPresentableName((PsiMethod)element);
        }
        if (element instanceof PsiField) {
            return JavaUmlElementManager.getFieldPresentableName((PsiField)element);
        }
        if (element instanceof PsiClass) {
            return JavaUmlElementManager.getClassPresentableName((PsiClass)element);
        }
        if (element instanceof PsiPackage) {
            return JavaUmlElementManager.getPackagePresentableName((PsiPackage)element);
        }
        if (element instanceof JavaProperty) {
            return JavaUmlElementManager.getPropertyPresentableName((JavaProperty)element);
        }
        return null;
    }

    private static SimpleColoredText getPackagePresentableName(PsiPackage psiPackage) {
        SimpleColoredText text = new SimpleColoredText();
        text.append(psiPackage.getQualifiedName(), new SimpleTextAttributes(1, JavaUmlElementManager.getFGColor()));
        return text;
    }

    private static SimpleColoredText getClassPresentableName(PsiClass psiClass) {
        int style = 1;
        if (psiClass.isDeprecated()) {
            style |= 4;
        }
        if (!psiClass.isPhysical()) {
            style |= 2;
        }
        String label = psiClass.getName();
        PsiTypeParameterList classParams = psiClass.getTypeParameterList();
        if (classParams != null && classParams.getText() != null) {
            String params = classParams.getText();
            label = label + (params.length() > 7 ? "<...>" : params);
        }
        SimpleColoredText text = new SimpleColoredText();
        text.append(label, new SimpleTextAttributes(style, JavaUmlElementManager.getFGColor()));
        return text;
    }

    private static SimpleColoredText getMethodPresentableName(PsiMethod method) {
        int style = 0;
        if (method.isDeprecated()) {
            style |= 4;
        }
        if (!method.isPhysical()) {
            style |= 2;
        }
        SimpleColoredText text = new SimpleColoredText();
        text.append(JavaUmlElementManager.getMethodSignature(method), new SimpleTextAttributes(style, JavaUmlElementManager.getFGColor()));
        return text;
    }

    private static SimpleColoredText getFieldPresentableName(@NotNull PsiField field) {
        if (field == null) {
            JavaUmlElementManager.$$$reportNull$$$0(3);
        }
        int style = 0;
        if (field.isDeprecated()) {
            style |= 4;
        }
        if (!field.isPhysical()) {
            style |= 2;
        }
        return new SimpleColoredText(field.getName(), new SimpleTextAttributes(style, JavaUmlElementManager.getFGColor()));
    }

    private static SimpleColoredText getPropertyPresentableName(@NotNull JavaProperty property) {
        if (property == null) {
            JavaUmlElementManager.$$$reportNull$$$0(4);
        }
        int style = 0;
        if (property.isDeprecated()) {
            style |= 4;
        }
        if (!property.isPhysical()) {
            style |= 2;
        }
        return new SimpleColoredText(property.getName(), new SimpleTextAttributes(style, JavaUmlElementManager.getFGColor()));
    }

    private static Color getFGColor() {
        DiagramProvider provider = JavaUmlProvider.findByID((String)"JAVA");
        assert (provider != null);
        return provider.getColorManager().getNodeForegroundColor(false);
    }

    public SimpleColoredText getItemType(Object element) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        PsiType type = null;
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            type = field instanceof PsiEnumConstant ? null : field.getType();
        } else if (element instanceof PsiMethod) {
            type = ((PsiMethod)element).getReturnType();
        } else if (element instanceof JavaProperty) {
            type = ((JavaProperty)element).getType();
        }
        if (type == null) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        int style = 0;
        if (psiClass != null && psiClass.isDeprecated()) {
            style |= 4;
        }
        return new SimpleColoredText(type.getPresentableText(), new SimpleTextAttributes(style, JavaUmlElementManager.getFGColor()));
    }

    public String getNodeTooltip(PsiElement element) {
        if (element instanceof PsiClass) {
            return XmlStringUtil.wrapInHtml((CharSequence)((PsiClass)element).getQualifiedName());
        }
        if (element instanceof PsiPackage) {
            return UmlJavaUtils.getInfo((PsiPackage)element).toString();
        }
        return "unknown";
    }

    public static String getMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            JavaUmlElementManager.$$$reportNull$$$0(5);
        }
        StringBuilder signature = new StringBuilder(method.getName());
        signature.append("(");
        for (PsiParameter param : method.getParameterList().getParameters()) {
            signature.append(param.getType().getPresentableText());
            signature.append(", ");
        }
        if (method.getParameterList().getParameters().length != 0) {
            signature.delete(signature.length() - 2, signature.length());
        }
        signature.append(")");
        return signature.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlElementManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlElementManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFieldPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

