/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.values;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.xml.util.ColorIconCache;
import com.intellij.xml.util.ColorMap;
import com.intellij.xml.util.ColorSampleLookupValue;
import com.intellij.xml.util.UserColorLookup;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

class JavaFxColorTemplateExpression
extends Expression {
    JavaFxColorTemplateExpression() {
    }

    @Nullable
    public Result calculateResult(ExpressionContext context) {
        return new TextResult("");
    }

    @Nullable
    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    @Nullable
    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        ArrayList<Object> colors = new ArrayList<Object>();
        colors.add(new UserColorLookup());
        for (ColorSampleLookupValue color : ColorSampleLookupValue.getColors()) {
            if (ColorMap.isSystemColorName((String)color.getName().toLowerCase())) continue;
            LookupElementBuilder builder = LookupElementBuilder.create((String)color.getName());
            Color iconColor = ColorMap.getColor((String)color.getPresentation());
            if (iconColor != null) {
                builder = builder.withIcon(ColorIconCache.getIconCache().getIcon(iconColor, 16));
            }
            colors.add(builder);
        }
        return colors.toArray(LookupElement.EMPTY_ARRAY);
    }
}

