/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.model.xml.core.Channel;
import com.intellij.spring.integration.model.xml.core.Filter;
import com.intellij.spring.integration.model.xml.core.Gateway;
import com.intellij.spring.integration.model.xml.core.GatewayMethod;
import com.intellij.spring.integration.model.xml.core.Header;
import com.intellij.spring.integration.model.xml.core.LoggingChannelAdapter;
import com.intellij.spring.integration.model.xml.core.MapToObjectTransformer;
import com.intellij.spring.integration.model.xml.core.Poller;
import com.intellij.spring.integration.model.xml.core.Queue;
import com.intellij.spring.integration.model.xml.core.Resequencer;
import com.intellij.spring.integration.model.xml.core.UserDefinedHeader;
import com.intellij.spring.integration.model.xml.file.OutboundFileBase;
import com.intellij.spring.integration.model.xml.ftp.OutboundChannelAdapter;
import com.intellij.spring.integration.model.xml.http.InboundGateway;
import com.intellij.spring.integration.model.xml.jdbc.OutboundGateway;
import com.intellij.spring.integration.model.xml.jdbc.Parameter;
import com.intellij.spring.integration.model.xml.jdbc.StoredProcInboundChannelAdapter;
import com.intellij.spring.integration.model.xml.jdbc.StoredProcOutboundChannelAdapter;
import com.intellij.spring.integration.model.xml.jdbc.StoredProcOutboundGateway;
import com.intellij.spring.integration.model.xml.mail.InboundChannelAdapter;
import com.intellij.spring.integration.model.xml.security.SecuredChannels;
import com.intellij.spring.integration.model.xml.ws.HeaderEnricher;
import com.intellij.spring.integration.model.xml.ws.SoapAction;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringDomInspectionUtils;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;

class ModelSpecificVisitor
implements DomElementVisitor {
    private final DomElementAnnotationHolder holder;
    private final SpringDomInspectionUtils mySpringDomInspectionUtils;

    ModelSpecificVisitor(DomElementAnnotationHolder holder) {
        this.holder = holder;
        this.mySpringDomInspectionUtils = new SpringDomInspectionUtils(holder);
    }

    public void visitDomElement(DomElement element) {
    }

    public void visitChannel(Channel channel) {
        Queue queue = channel.getQueue();
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)queue, new GenericAttributeValue[]{queue.getMessageStore(), queue.getRef()});
        if (SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{channel.getDispatcher(), channel.getDispatcherAttr()}) && SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{channel.getQueue(), channel.getPriorityQueue(), channel.getRendezvousQueue()})) {
            this.holder.createProblem((DomElement)channel, SpringIntegrationBundle.message("SpringIntegrationModelInspection.channel.dispatcher.with.queue.definitions", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public void visitFilter(Filter filter) {
        if (DomUtil.hasXml((DomElement)filter.getMethod())) {
            return;
        }
        SpringBeanPointer value = (SpringBeanPointer)filter.getRef().getValue();
        if (value == null) {
            return;
        }
        PsiClass beanClass = value.getBeanClass();
        if (beanClass == null) {
            return;
        }
        for (PsiMethod method : beanClass.getMethods()) {
            if (!method.getModifierList().hasModifierProperty("public") || !PsiType.BOOLEAN.equals((Object)method.getReturnType()) || method.getParameterList().getParametersCount() != 1 || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.integration.annotation.Filter", (int)0)) continue;
            return;
        }
        this.mySpringDomInspectionUtils.beanOfType(filter.getRef(), "org.springframework.integration.core.MessageSelector");
    }

    public void visitGateway(Gateway gateway) {
        PsiClass serviceInterface = (PsiClass)gateway.getServiceInterface().getValue();
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            this.holder.createProblem(gateway.getServiceInterface(), SpringIntegrationBundle.message("SpringIntegrationModelInspection.interface.is.expected.here", new Object[0]), new LocalQuickFix[0]);
        }
        for (GatewayMethod gatewayMethod : gateway.getMethods()) {
            for (Header header : gatewayMethod.getHeaders()) {
                this.mySpringDomInspectionUtils.onlyOneOf((DomElement)header, new GenericAttributeValue[]{header.getValue(), header.getExpression()});
            }
        }
    }

    public void visitHeaderEnricher(com.intellij.spring.integration.model.xml.core.HeaderEnricher headerEnricher) {
        for (UserDefinedHeader header : headerEnricher.getHeaders()) {
            if (!SpringDomInspectionUtils.hasMoreThanOne((DomElement[])new DomElement[]{header.getRef(), header.getExpressionAttr(), header.getValue(), header.getExpression()})) continue;
            this.holder.createProblem((DomElement)header, SpringIntegrationBundle.message("SpringIntegrationModelInspection.ref.expression.or.value", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public void visitLoggingChannelAdapter(LoggingChannelAdapter loggingChannelAdapter) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)loggingChannelAdapter, new GenericAttributeValue[]{loggingChannelAdapter.getLogFullMessage(), loggingChannelAdapter.getExpression()});
    }

    public void visitMapToObjectTransformerType(MapToObjectTransformer transformer) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)transformer, new GenericAttributeValue[]{transformer.getRef(), transformer.getType()});
        SpringBeanPointer value = (SpringBeanPointer)transformer.getRef().getValue();
        if (value != null) {
            CommonSpringBean commonSpringBean = value.getSpringBean();
            if (!(commonSpringBean instanceof SpringBean)) {
                return;
            }
            SpringBean springBean = (SpringBean)commonSpringBean;
            if (springBean.getScope().getValue() != SpringBeanScope.PROTOTYPE_SCOPE) {
                this.holder.createProblem((DomElement)transformer.getRef(), SpringIntegrationBundle.message("SpringIntegrationModelInspection.map.to.object.transformer.ref.must.be.prototype", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    public void visitPoller(Poller poller) {
        Boolean value;
        if (!(DomUtil.hasXml((DomElement)poller.getId()) || (value = (Boolean)poller.getDefault().getValue()) != null && value.booleanValue())) {
            this.holder.createProblem((DomElement)poller, SpringIntegrationBundle.message("SpringIntegrationModelInspection.poller.id.required.unless.default", new Object[0]), new LocalQuickFix[0]);
        }
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)poller, new GenericAttributeValue[]{poller.getTimeUnit(), poller.getCron()});
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)poller, new GenericAttributeValue[]{poller.getTimeUnit(), poller.getTrigger()});
    }

    public void visitResequencer(Resequencer resequencer) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)resequencer, new GenericAttributeValue[]{resequencer.getReleasePartialSequences(), resequencer.getReleaseStrategy()});
    }

    public void visitOutboundFileBase(OutboundFileBase outboundFileBase) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)outboundFileBase, new GenericAttributeValue[]{outboundFileBase.getFilenameGenerator(), outboundFileBase.getFilenameGeneratorExpression()});
    }

    public void visitEventInboundChannelAdapter(com.intellij.spring.integration.model.xml.event.InboundChannelAdapter inboundChannelAdapter) {
        Collection eventTypes = (Collection)inboundChannelAdapter.getEventTypes().getValue();
        if (eventTypes != null) {
            for (PsiClass psiClass : eventTypes) {
                if (InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)false, (String)"org.springframework.context.ApplicationEvent")) continue;
                this.holder.createProblem(inboundChannelAdapter.getEventTypes(), SpringIntegrationBundle.message("SpringIntegrationModelInspection.incorrect.event.type", psiClass.getQualifiedName(), "org.springframework.context.ApplicationEvent"), new LocalQuickFix[0]);
            }
        }
    }

    public void visitFileInboundChannelAdapter(com.intellij.spring.integration.model.xml.file.InboundChannelAdapter inboundChannelAdapter) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)inboundChannelAdapter, new GenericAttributeValue[]{inboundChannelAdapter.getFilter(), inboundChannelAdapter.getFilenamePattern(), inboundChannelAdapter.getFilenameRegex()});
    }

    public void visitFtpInboundChannelAdapter(com.intellij.spring.integration.model.xml.ftp.InboundChannelAdapter inboundChannelAdapter) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)inboundChannelAdapter, new GenericAttributeValue[]{inboundChannelAdapter.getFilter(), inboundChannelAdapter.getFilenamePattern(), inboundChannelAdapter.getFilenameRegex()});
    }

    public void visitFtpOutboundChannelAdapter(OutboundChannelAdapter outboundChannelAdapter) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)outboundChannelAdapter, new GenericAttributeValue[]{outboundChannelAdapter.getRemoteFilenameGenerator(), outboundChannelAdapter.getRemoteFilenameGeneratorExpression()});
    }

    public void visitHttpInboundChannelAdapter(com.intellij.spring.integration.model.xml.http.InboundChannelAdapter channelAdapter) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)channelAdapter, new GenericAttributeValue[]{channelAdapter.getViewName(), channelAdapter.getViewExpression()});
    }

    public void visitHttpInboundGateway(InboundGateway inboundGateway) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)inboundGateway, new GenericAttributeValue[]{inboundGateway.getViewName(), inboundGateway.getViewExpression()});
    }

    public void visitHttpOutboundChannelAdapter(com.intellij.spring.integration.model.xml.http.OutboundChannelAdapter adapter) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)adapter, new GenericAttributeValue[]{adapter.getExpectedResponseType(), adapter.getExpectedResponseTypeExpression()});
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)adapter, new GenericAttributeValue[]{adapter.getHttpMethod(), adapter.getHttpMethodExpression()});
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)adapter, new GenericAttributeValue[]{adapter.getUrl(), adapter.getUrlExpression()});
    }

    public void visitHttpOutboundGateway(com.intellij.spring.integration.model.xml.http.OutboundGateway gateway) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)gateway, new GenericAttributeValue[]{gateway.getExpectedResponseType(), gateway.getExpectedResponseTypeExpression()});
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)gateway, new GenericAttributeValue[]{gateway.getHttpMethod(), gateway.getHttpMethodExpression()});
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)gateway, new GenericAttributeValue[]{gateway.getUrl(), gateway.getUrlExpression()});
    }

    public void visitJdbcOutboundGateway(OutboundGateway outboundGateway) {
        this.mySpringDomInspectionUtils.oneOfRequired((DomElement)outboundGateway, new DomElement[]{outboundGateway.getUpdateAttr(), outboundGateway.getUpdate()});
    }

    public void visitJdbcStoredProcInboundChannelAdapter(StoredProcInboundChannelAdapter adapter) {
        for (Parameter parameter : adapter.getParameters()) {
            this.checkJdbcParameter(parameter);
        }
    }

    public void visitStoredProcOutboundChannelAdapter(StoredProcOutboundChannelAdapter adapter) {
        for (Parameter parameter : adapter.getParameters()) {
            this.checkJdbcParameter(parameter);
        }
    }

    public void visitStoredProcOutboundGateway(StoredProcOutboundGateway gateway) {
        for (Parameter parameter : gateway.getParameters()) {
            this.checkJdbcParameter(parameter);
        }
    }

    private void checkJdbcParameter(Parameter parameter) {
        if (!SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{parameter.getExpression()})) {
            return;
        }
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)parameter, new GenericAttributeValue[]{parameter.getValue(), parameter.getExpression()});
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)parameter, new GenericAttributeValue[]{parameter.getType(), parameter.getExpression()});
    }

    public void visitJmsOutboundGateway(com.intellij.spring.integration.model.xml.jms.OutboundGateway gateway) {
        if (gateway.getExplicitQosEnabled().getValue() != Boolean.TRUE && SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{gateway.getDeliveryPersistent(), gateway.getTimeToLive(), gateway.getPriority()})) {
            this.holder.createProblem((DomElement)gateway, SpringIntegrationBundle.message("SpringIntegrationModelInspection.jms.qos.not.effective", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public void visitJmsOutboundChannelAdapter(com.intellij.spring.integration.model.xml.jms.OutboundChannelAdapter adapter) {
        if (adapter.getExplicitQosEnabled().getValue() != Boolean.TRUE && SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{adapter.getDeliveryPersistent(), adapter.getTimeToLive(), adapter.getPriority()})) {
            this.holder.createProblem((DomElement)adapter, SpringIntegrationBundle.message("SpringIntegrationModelInspection.jms.qos.not.effective", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public void visitMailInboundChannelAdapter(InboundChannelAdapter adapter) {
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)adapter, new GenericAttributeValue[]{adapter.getProtocol(), adapter.getStoreUri()});
    }

    public void visitMongodbInboundChannelAdapter(com.intellij.spring.integration.model.xml.mongodb.InboundChannelAdapter adapter) {
        this.mySpringDomInspectionUtils.oneOfRequired((DomElement)adapter, new DomElement[]{adapter.getQuery(), adapter.getQueryExpression()});
    }

    public void visitWsHeaderEnricher(HeaderEnricher headerEnricher) {
        SoapAction soapAction = headerEnricher.getSoapAction();
        this.mySpringDomInspectionUtils.onlyOneOf((DomElement)soapAction, new GenericAttributeValue[]{soapAction.getRef(), soapAction.getValue(), soapAction.getExpression()});
    }

    public void visitSecuredChannels(SecuredChannels securedChannels) {
        this.mySpringDomInspectionUtils.explicitBeanRequired((DomElement)securedChannels, securedChannels.getAuthenticationManager(), "authenticationManager");
        this.mySpringDomInspectionUtils.explicitBeanRequired((DomElement)securedChannels, securedChannels.getAccessDecisionManager(), "accessDecisionManager");
    }
}

