/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml.fake;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.spring.integration.model.xml.fake.SpringIntegrationHeader;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationHeadersFactory
implements Disposable {
    private final Set<SpringIntegrationHeader> myHeaders = ContainerUtil.newConcurrentSet();
    private final Map<PsiFile, Long> myContributors = ContainerUtil.newConcurrentMap();
    private final PsiFile myDummyFile;

    public static SpringIntegrationHeadersFactory getInstance(Module module) {
        return (SpringIntegrationHeadersFactory)ModuleServiceManager.getService((Module)module, SpringIntegrationHeadersFactory.class);
    }

    public SpringIntegrationHeadersFactory(Module module) {
        this.myDummyFile = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText("dummy_headers.java", (FileType)StdFileTypes.JAVA, (CharSequence)"");
    }

    @NotNull
    public SpringIntegrationHeader getOrCreateHeader(String headerName, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(0);
        }
        if (this.myContributors.containsKey(containingFile) && this.myContributors.get(containingFile).longValue() != containingFile.getModificationStamp()) {
            this.myHeaders.clear();
            this.myContributors.clear();
        }
        for (SpringIntegrationHeader header : this.myHeaders) {
            if (!headerName.equals(header.getName())) continue;
            SpringIntegrationHeader springIntegrationHeader = header;
            if (springIntegrationHeader == null) {
                SpringIntegrationHeadersFactory.$$$reportNull$$$0(1);
            }
            return springIntegrationHeader;
        }
        SpringIntegrationHeader header = new SpringIntegrationHeader(headerName, this.myDummyFile);
        this.myHeaders.add(header);
        this.myContributors.put(containingFile, containingFile.getModificationStamp());
        SpringIntegrationHeader springIntegrationHeader = header;
        if (springIntegrationHeader == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(2);
        }
        return springIntegrationHeader;
    }

    @NotNull
    public Set<SpringIntegrationHeader> getHeaders() {
        Set<SpringIntegrationHeader> set = this.myHeaders;
        if (set == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(3);
        }
        return set;
    }

    public void dispose() {
        this.myHeaders.clear();
        this.myContributors.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeadersFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeadersFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateHeader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHeader";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

